/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.Closeable;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public class ProxyOutputStream
extends FilterOutputStream {
    public ProxyOutputStream(OutputStream outputStream2) {
        super(outputStream2);
    }

    @Override
    public void write(int n) {
        try {
            this.beforeWrite(1);
            this.out.write(n);
            this.afterWrite(1);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
    }

    @Override
    public void write(byte[] byArray) {
        try {
            int n = IOUtils.length(byArray);
            this.beforeWrite(n);
            this.out.write(byArray);
            this.afterWrite(n);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        try {
            this.beforeWrite(n2);
            this.out.write(byArray, n, n2);
            this.afterWrite(n2);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
    }

    @Override
    public void flush() {
        try {
            this.out.flush();
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
    }

    @Override
    public void close() {
        IOUtils.close((Closeable)this.out, this::handleIOException);
    }

    protected void beforeWrite(int n) {
    }

    protected void afterWrite(int n) {
    }

    protected void handleIOException(IOException iOException) {
        throw iOException;
    }
}

