/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.ClosedInputStream;
import org.apache.commons.io.output.AbstractByteArrayOutputStream$InputStreamConstructor;

public abstract class AbstractByteArrayOutputStream
extends OutputStream {
    static final int DEFAULT_SIZE = 1024;
    private final List<byte[]> buffers = new ArrayList<byte[]>();
    private int currentBufferIndex;
    private int filledBufferSum;
    private byte[] currentBuffer;
    protected int count;
    private boolean reuseBuffers = true;

    protected void needNewBuffer(int n) {
        if (this.currentBufferIndex < this.buffers.size() - 1) {
            this.filledBufferSum += this.currentBuffer.length;
            ++this.currentBufferIndex;
            this.currentBuffer = this.buffers.get(this.currentBufferIndex);
        } else {
            int n2;
            if (this.currentBuffer == null) {
                n2 = n;
                this.filledBufferSum = 0;
            } else {
                n2 = Math.max(this.currentBuffer.length << 1, n - this.filledBufferSum);
                this.filledBufferSum += this.currentBuffer.length;
            }
            ++this.currentBufferIndex;
            this.currentBuffer = IOUtils.byteArray(n2);
            this.buffers.add(this.currentBuffer);
        }
    }

    @Override
    public abstract void write(byte[] var1, int var2, int var3);

    protected void writeImpl(byte[] byArray, int n, int n2) {
        int n3 = this.count + n2;
        int n4 = n2;
        int n5 = this.count - this.filledBufferSum;
        while (n4 > 0) {
            int n6 = Math.min(n4, this.currentBuffer.length - n5);
            System.arraycopy(byArray, n + n2 - n4, this.currentBuffer, n5, n6);
            if ((n4 -= n6) <= 0) continue;
            this.needNewBuffer(n3);
            n5 = 0;
        }
        this.count = n3;
    }

    @Override
    public abstract void write(int var1);

    protected void writeImpl(int n) {
        int n2 = this.count - this.filledBufferSum;
        if (n2 == this.currentBuffer.length) {
            this.needNewBuffer(this.count + 1);
            n2 = 0;
        }
        this.currentBuffer[n2] = (byte)n;
        ++this.count;
    }

    public abstract int write(InputStream var1);

    protected int writeImpl(InputStream inputStream2) {
        int n = 0;
        int n2 = this.count - this.filledBufferSum;
        int n3 = inputStream2.read(this.currentBuffer, n2, this.currentBuffer.length - n2);
        while (n3 != -1) {
            n += n3;
            this.count += n3;
            if ((n2 += n3) == this.currentBuffer.length) {
                this.needNewBuffer(this.currentBuffer.length);
                n2 = 0;
            }
            n3 = inputStream2.read(this.currentBuffer, n2, this.currentBuffer.length - n2);
        }
        return n;
    }

    public abstract int size();

    @Override
    public void close() {
    }

    public abstract void reset();

    protected void resetImpl() {
        this.count = 0;
        this.filledBufferSum = 0;
        this.currentBufferIndex = 0;
        if (this.reuseBuffers) {
            this.currentBuffer = this.buffers.get(this.currentBufferIndex);
        } else {
            this.currentBuffer = null;
            int n = this.buffers.get(0).length;
            this.buffers.clear();
            this.needNewBuffer(n);
            this.reuseBuffers = true;
        }
    }

    public abstract void writeTo(OutputStream var1);

    protected void writeToImpl(OutputStream outputStream2) {
        int n = this.count;
        for (byte[] byArray : this.buffers) {
            int n2 = Math.min(byArray.length, n);
            outputStream2.write(byArray, 0, n2);
            if ((n -= n2) != 0) continue;
            break;
        }
    }

    public abstract InputStream toInputStream();

    protected <T extends InputStream> InputStream toInputStream(AbstractByteArrayOutputStream$InputStreamConstructor<T> abstractByteArrayOutputStream$InputStreamConstructor) {
        int n = this.count;
        if (n == 0) {
            return ClosedInputStream.CLOSED_INPUT_STREAM;
        }
        ArrayList<T> arrayList = new ArrayList<T>(this.buffers.size());
        for (byte[] byArray : this.buffers) {
            int n2 = Math.min(byArray.length, n);
            arrayList.add(abstractByteArrayOutputStream$InputStreamConstructor.construct(byArray, 0, n2));
            if ((n -= n2) != 0) continue;
            break;
        }
        this.reuseBuffers = false;
        return new SequenceInputStream(Collections.enumeration(arrayList));
    }

    public abstract byte[] toByteArray();

    protected byte[] toByteArrayImpl() {
        int n = this.count;
        if (n == 0) {
            return IOUtils.EMPTY_BYTE_ARRAY;
        }
        byte[] byArray = IOUtils.byteArray(n);
        int n2 = 0;
        for (byte[] byArray2 : this.buffers) {
            int n3 = Math.min(byArray2.length, n);
            System.arraycopy(byArray2, 0, byArray, n2, n3);
            n2 += n3;
            if ((n -= n3) != 0) continue;
            break;
        }
        return byArray;
    }

    @Deprecated
    public String toString() {
        return new String(this.toByteArray(), Charset.defaultCharset());
    }

    public String toString(String string) {
        return new String(this.toByteArray(), string);
    }

    public String toString(Charset charset) {
        return new String(this.toByteArray(), charset);
    }
}

