/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;

public abstract class ProxyInputStream
extends FilterInputStream {
    public ProxyInputStream(InputStream inputStream2) {
        super(inputStream2);
    }

    @Override
    public int read() {
        try {
            this.beforeRead(1);
            int n = this.in.read();
            this.afterRead(n != -1 ? 1 : -1);
            return n;
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            return -1;
        }
    }

    @Override
    public int read(byte[] byArray) {
        try {
            this.beforeRead(IOUtils.length(byArray));
            int n = this.in.read(byArray);
            this.afterRead(n);
            return n;
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            return -1;
        }
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        try {
            this.beforeRead(n2);
            int n3 = this.in.read(byArray, n, n2);
            this.afterRead(n3);
            return n3;
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            return -1;
        }
    }

    @Override
    public long skip(long l) {
        try {
            return this.in.skip(l);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            return 0L;
        }
    }

    @Override
    public int available() {
        try {
            return super.available();
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            return 0;
        }
    }

    @Override
    public void close() {
        IOUtils.close((Closeable)this.in, this::handleIOException);
    }

    @Override
    public synchronized void mark(int n) {
        this.in.mark(n);
    }

    @Override
    public synchronized void reset() {
        try {
            this.in.reset();
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    protected void beforeRead(int n) {
    }

    protected void afterRead(int n) {
    }

    protected void handleIOException(IOException iOException) {
        throw iOException;
    }
}

