/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.Serializable;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.AbstractFileFilter;

public class PrefixFileFilter
extends AbstractFileFilter
implements Serializable {
    private static final long serialVersionUID = 8533897440809599867L;
    private final String[] prefixes;
    private final IOCase caseSensitivity;

    public PrefixFileFilter(List<String> list) {
        this(list, IOCase.SENSITIVE);
    }

    public PrefixFileFilter(List<String> list, IOCase iOCase) {
        if (list == null) {
            throw new IllegalArgumentException("The list of prefixes must not be null");
        }
        this.prefixes = list.toArray(EMPTY_STRING_ARRAY);
        this.caseSensitivity = iOCase == null ? IOCase.SENSITIVE : iOCase;
    }

    public PrefixFileFilter(String string) {
        this(string, IOCase.SENSITIVE);
    }

    public PrefixFileFilter(String ... stringArray) {
        this(stringArray, IOCase.SENSITIVE);
    }

    public PrefixFileFilter(String string, IOCase iOCase) {
        if (string == null) {
            throw new IllegalArgumentException("The prefix must not be null");
        }
        this.prefixes = new String[]{string};
        this.caseSensitivity = iOCase == null ? IOCase.SENSITIVE : iOCase;
    }

    public PrefixFileFilter(String[] stringArray, IOCase iOCase) {
        if (stringArray == null) {
            throw new IllegalArgumentException("The array of prefixes must not be null");
        }
        this.prefixes = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.prefixes, 0, stringArray.length);
        this.caseSensitivity = iOCase == null ? IOCase.SENSITIVE : iOCase;
    }

    @Override
    public boolean accept(File file) {
        return this.accept(file == null ? null : file.getName());
    }

    @Override
    public boolean accept(File file, String string) {
        return this.accept(string);
    }

    @Override
    public FileVisitResult accept(Path path, BasicFileAttributes basicFileAttributes) {
        Path path2 = path.getFileName();
        return PrefixFileFilter.toFileVisitResult(this.accept(path2 == null ? null : path2.toFile()), path);
    }

    private boolean accept(String string) {
        for (String string2 : this.prefixes) {
            if (!this.caseSensitivity.checkStartsWith(string, string2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append("(");
        if (this.prefixes != null) {
            for (int i = 0; i < this.prefixes.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(this.prefixes[i]);
            }
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

