/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file.spi;

import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.spi.FileSystemProvider;
import java.util.List;
import java.util.Objects;

public class FileSystemProviders {
    private static final FileSystemProviders INSTALLED = new FileSystemProviders(FileSystemProvider.installedProviders());
    private final List<FileSystemProvider> providers;

    public static FileSystemProvider getFileSystemProvider(Path path) {
        return Objects.requireNonNull(path, "path").getFileSystem().provider();
    }

    public static FileSystemProviders installed() {
        return INSTALLED;
    }

    private FileSystemProviders(List<FileSystemProvider> list) {
        this.providers = list;
    }

    public FileSystemProvider getFileSystemProvider(String string) {
        Objects.requireNonNull(string, "scheme");
        if (string.equalsIgnoreCase("file")) {
            return FileSystems.getDefault().provider();
        }
        if (this.providers != null) {
            for (FileSystemProvider fileSystemProvider : this.providers) {
                if (!fileSystemProvider.getScheme().equalsIgnoreCase(string)) continue;
                return fileSystemProvider;
            }
        }
        return null;
    }

    public FileSystemProvider getFileSystemProvider(URI uRI) {
        return this.getFileSystemProvider(Objects.requireNonNull(uRI, "uri").getScheme());
    }

    public FileSystemProvider getFileSystemProvider(URL uRL) {
        return this.getFileSystemProvider(Objects.requireNonNull(uRL, "url").getProtocol());
    }
}

