/*
 * Decompiled with CFR 0.152.
 */
package okio.internal;

import java.io.EOFException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.-SegmentedByteString;
import okio.Buffer;
import okio.Buffer$UnsafeCursor;
import okio.ByteString;
import okio.Options;
import okio.Segment;
import okio.SegmentPool;
import okio.SegmentedByteString;
import okio.Sink;
import okio.Source;
import okio._JvmPlatformKt;
import okio.internal._Utf8Kt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0080\u0001\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a0\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nH\u0000\u001a\r\u0010\u0013\u001a\u00020\u0014*\u00020\u0015H\u0080\b\u001a\r\u0010\u0016\u001a\u00020\u0014*\u00020\u0017H\u0080\b\u001a\r\u0010\u0018\u001a\u00020\u0007*\u00020\u0015H\u0080\b\u001a\r\u0010\u0019\u001a\u00020\u0015*\u00020\u0015H\u0080\b\u001a%\u0010\u001a\u001a\u00020\u0015*\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0007H\u0080\b\u001a\u0017\u0010\u001e\u001a\u00020\f*\u00020\u00152\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0080\b\u001a\u0015\u0010!\u001a\u00020\u0007*\u00020\u00172\u0006\u0010\"\u001a\u00020\nH\u0080\b\u001a\u0015\u0010#\u001a\u00020$*\u00020\u00152\u0006\u0010%\u001a\u00020\u0007H\u0080\b\u001a\r\u0010&\u001a\u00020\n*\u00020\u0015H\u0080\b\u001a%\u0010'\u001a\u00020\u0007*\u00020\u00152\u0006\u0010(\u001a\u00020$2\u0006\u0010)\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u0007H\u0080\b\u001a\u001d\u0010'\u001a\u00020\u0007*\u00020\u00152\u0006\u0010\u0010\u001a\u00020+2\u0006\u0010)\u001a\u00020\u0007H\u0080\b\u001a\u001d\u0010,\u001a\u00020\u0007*\u00020\u00152\u0006\u0010-\u001a\u00020+2\u0006\u0010)\u001a\u00020\u0007H\u0080\b\u001a\r\u0010.\u001a\u00020\n*\u00020\u0017H\u0080\b\u001a-\u0010/\u001a\u00020\f*\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020+2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\nH\u0080\b\u001a\u0015\u00100\u001a\u00020\n*\u00020\u00152\u0006\u00101\u001a\u00020\u0001H\u0080\b\u001a%\u00100\u001a\u00020\n*\u00020\u00152\u0006\u00101\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\nH\u0080\b\u001a\u001d\u00100\u001a\u00020\u0007*\u00020\u00152\u0006\u00101\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0007H\u0080\b\u001a\u0015\u00102\u001a\u00020\u0007*\u00020\u00152\u0006\u00101\u001a\u000203H\u0080\b\u001a\u0014\u00104\u001a\u00020\u0017*\u00020\u00152\u0006\u00105\u001a\u00020\u0017H\u0000\u001a\r\u00106\u001a\u00020$*\u00020\u0015H\u0080\b\u001a\r\u00107\u001a\u00020\u0001*\u00020\u0015H\u0080\b\u001a\u0015\u00107\u001a\u00020\u0001*\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0007H\u0080\b\u001a\r\u00108\u001a\u00020+*\u00020\u0015H\u0080\b\u001a\u0015\u00108\u001a\u00020+*\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0007H\u0080\b\u001a\r\u00109\u001a\u00020\u0007*\u00020\u0015H\u0080\b\u001a\u0015\u0010:\u001a\u00020\u0014*\u00020\u00152\u0006\u00101\u001a\u00020\u0001H\u0080\b\u001a\u001d\u0010:\u001a\u00020\u0014*\u00020\u00152\u0006\u00101\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0007H\u0080\b\u001a\r\u0010;\u001a\u00020\u0007*\u00020\u0015H\u0080\b\u001a\r\u0010<\u001a\u00020\n*\u00020\u0015H\u0080\b\u001a\r\u0010=\u001a\u00020\u0007*\u00020\u0015H\u0080\b\u001a\r\u0010>\u001a\u00020?*\u00020\u0015H\u0080\b\u001a\u0014\u0010@\u001a\u00020\u0017*\u00020\u00152\u0006\u00105\u001a\u00020\u0017H\u0000\u001a\u0015\u0010A\u001a\u00020B*\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0007H\u0080\b\u001a\r\u0010C\u001a\u00020\n*\u00020\u0015H\u0080\b\u001a\u000f\u0010D\u001a\u0004\u0018\u00010B*\u00020\u0015H\u0080\b\u001a\u0015\u0010E\u001a\u00020B*\u00020\u00152\u0006\u0010F\u001a\u00020\u0007H\u0080\b\u001a\u0015\u0010G\u001a\u00020\u0007*\u00020\u00172\u0006\u0010H\u001a\u00020\u0007H\u0080\b\u001a\u0015\u0010I\u001a\u00020\n*\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0007H\u0080\b\u001a\u0015\u0010J\u001a\u00020\n*\u00020\u00152\u0006\u0010K\u001a\u00020LH\u0080\b\u001a\u0015\u0010M\u001a\u00020\u0014*\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0007H\u0080\b\u001a\r\u0010N\u001a\u00020+*\u00020\u0015H\u0080\b\u001a\u0015\u0010N\u001a\u00020+*\u00020\u00152\u0006\u0010\u001d\u001a\u00020\nH\u0080\b\u001a\u0015\u0010O\u001a\u00020\u000e*\u00020\u00152\u0006\u0010P\u001a\u00020\nH\u0080\b\u001a\u0015\u0010Q\u001a\u00020\u0015*\u00020\u00152\u0006\u0010R\u001a\u00020\u0001H\u0080\b\u001a%\u0010Q\u001a\u00020\u0015*\u00020\u00152\u0006\u0010R\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\nH\u0080\b\u001a\u001d\u0010Q\u001a\u00020\u0014*\u00020\u00152\u0006\u0010R\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0007H\u0080\b\u001a)\u0010Q\u001a\u00020\u0015*\u00020\u00152\u0006\u0010S\u001a\u00020+2\b\b\u0002\u0010\u001c\u001a\u00020\n2\b\b\u0002\u0010\u001d\u001a\u00020\nH\u0080\b\u001a\u001d\u0010Q\u001a\u00020\u0015*\u00020\u00152\u0006\u0010R\u001a\u00020T2\u0006\u0010\u001d\u001a\u00020\u0007H\u0080\b\u001a\u0015\u0010U\u001a\u00020\u0007*\u00020\u00152\u0006\u0010R\u001a\u00020TH\u0080\b\u001a\u0015\u0010V\u001a\u00020\u0015*\u00020\u00152\u0006\u0010(\u001a\u00020\nH\u0080\b\u001a\u0015\u0010W\u001a\u00020\u0015*\u00020\u00152\u0006\u0010X\u001a\u00020\u0007H\u0080\b\u001a\u0015\u0010Y\u001a\u00020\u0015*\u00020\u00152\u0006\u0010X\u001a\u00020\u0007H\u0080\b\u001a\u0015\u0010Z\u001a\u00020\u0015*\u00020\u00152\u0006\u0010[\u001a\u00020\nH\u0080\b\u001a\u0015\u0010\\\u001a\u00020\u0015*\u00020\u00152\u0006\u0010X\u001a\u00020\u0007H\u0080\b\u001a\u0015\u0010]\u001a\u00020\u0015*\u00020\u00152\u0006\u0010^\u001a\u00020\nH\u0080\b\u001a%\u0010_\u001a\u00020\u0015*\u00020\u00152\u0006\u0010`\u001a\u00020B2\u0006\u0010a\u001a\u00020\n2\u0006\u0010b\u001a\u00020\nH\u0080\b\u001a\u0015\u0010c\u001a\u00020\u0015*\u00020\u00152\u0006\u0010d\u001a\u00020\nH\u0080\b\u001a\u0014\u0010e\u001a\u00020B*\u00020\u00152\u0006\u0010f\u001a\u00020\u0007H\u0000\u001a?\u0010g\u001a\u0002Hh\"\u0004\b\u0000\u0010h*\u00020\u00152\u0006\u0010)\u001a\u00020\u00072\u001a\u0010i\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u0002Hh0jH\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010k\u001a\u001e\u0010l\u001a\u00020\n*\u00020\u00152\u0006\u0010K\u001a\u00020L2\b\b\u0002\u0010m\u001a\u00020\fH\u0000\"\u001c\u0010\u0000\u001a\u00020\u00018\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0002\u0010\u0003\u001a\u0004\b\u0004\u0010\u0005\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0007X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\nX\u0080T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006n"}, d2={"HEX_DIGIT_BYTES", "", "getHEX_DIGIT_BYTES$annotations", "()V", "getHEX_DIGIT_BYTES", "()[B", "OVERFLOW_DIGIT_START", "", "OVERFLOW_ZONE", "SEGMENTING_THRESHOLD", "", "rangeEquals", "", "segment", "Lokio/Segment;", "segmentPos", "bytes", "bytesOffset", "bytesLimit", "commonClear", "", "Lokio/Buffer;", "commonClose", "Lokio/Buffer$UnsafeCursor;", "commonCompleteSegmentByteCount", "commonCopy", "commonCopyTo", "out", "offset", "byteCount", "commonEquals", "other", "", "commonExpandBuffer", "minByteCount", "commonGet", "", "pos", "commonHashCode", "commonIndexOf", "b", "fromIndex", "toIndex", "Lokio/ByteString;", "commonIndexOfElement", "targetBytes", "commonNext", "commonRangeEquals", "commonRead", "sink", "commonReadAll", "Lokio/Sink;", "commonReadAndWriteUnsafe", "unsafeCursor", "commonReadByte", "commonReadByteArray", "commonReadByteString", "commonReadDecimalLong", "commonReadFully", "commonReadHexadecimalUnsignedLong", "commonReadInt", "commonReadLong", "commonReadShort", "", "commonReadUnsafe", "commonReadUtf8", "", "commonReadUtf8CodePoint", "commonReadUtf8Line", "commonReadUtf8LineStrict", "limit", "commonResizeBuffer", "newSize", "commonSeek", "commonSelect", "options", "Lokio/Options;", "commonSkip", "commonSnapshot", "commonWritableSegment", "minimumCapacity", "commonWrite", "source", "byteString", "Lokio/Source;", "commonWriteAll", "commonWriteByte", "commonWriteDecimalLong", "v", "commonWriteHexadecimalUnsignedLong", "commonWriteInt", "i", "commonWriteLong", "commonWriteShort", "s", "commonWriteUtf8", "string", "beginIndex", "endIndex", "commonWriteUtf8CodePoint", "codePoint", "readUtf8Line", "newline", "seek", "T", "lambda", "Lkotlin/Function2;", "(Lokio/Buffer;JLkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "selectPrefix", "selectTruncated", "okio"})
@JvmName(name="-Buffer")
@SourceDebugExtension(value={"SMAP\nBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Buffer.kt\nokio/internal/-Buffer\n+ 2 Util.kt\nokio/-SegmentedByteString\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1730:1\n112#1,20:1753\n112#1,20:1786\n112#1:1806\n114#1,18:1808\n112#1,20:1826\n74#2:1731\n74#2:1732\n74#2:1733\n74#2:1734\n74#2:1735\n74#2:1736\n74#2:1737\n74#2:1738\n74#2:1739\n74#2:1740\n74#2:1741\n74#2:1742\n83#2:1743\n83#2:1744\n77#2:1745\n77#2:1746\n77#2:1747\n77#2:1748\n77#2:1749\n77#2:1750\n77#2:1751\n77#2:1752\n86#2:1773\n89#2:1775\n74#2:1776\n74#2:1777\n74#2:1778\n74#2:1779\n74#2:1780\n74#2:1781\n74#2:1782\n74#2:1783\n74#2:1784\n74#2:1785\n89#2:1807\n86#2:1846\n1#3:1774\n*S KotlinDebug\n*F\n+ 1 Buffer.kt\nokio/internal/-Buffer\n*L\n415#1:1753,20\n1292#1:1786,20\n1323#1:1806\n1323#1:1808,18\n1357#1:1826,20\n178#1:1731\n202#1:1732\n321#1:1733\n326#1:1734\n349#1:1735\n350#1:1736\n351#1:1737\n352#1:1738\n358#1:1739\n359#1:1740\n360#1:1741\n361#1:1742\n385#1:1743\n386#1:1744\n392#1:1745\n393#1:1746\n394#1:1747\n395#1:1748\n396#1:1749\n397#1:1750\n398#1:1751\n399#1:1752\n427#1:1773\n888#1:1775\n906#1:1776\n908#1:1777\n912#1:1778\n914#1:1779\n918#1:1780\n920#1:1781\n924#1:1782\n926#1:1783\n946#1:1784\n949#1:1785\n1336#1:1807\n1676#1:1846\n*E\n"})
public final class -Buffer {
    @NotNull
    private static final byte[] HEX_DIGIT_BYTES = _JvmPlatformKt.asUtf8ToByteArray("0123456789abcdef");
    public static final int SEGMENTING_THRESHOLD = 4096;
    public static final long OVERFLOW_ZONE = -922337203685477580L;
    public static final long OVERFLOW_DIGIT_START = -7L;

    @NotNull
    public static final byte[] getHEX_DIGIT_BYTES() {
        return HEX_DIGIT_BYTES;
    }

    public static /* synthetic */ void getHEX_DIGIT_BYTES$annotations() {
    }

    public static final boolean rangeEquals(@NotNull Segment segment, int n, @NotNull byte[] byArray, int n2, int n3) {
        Intrinsics.checkNotNullParameter(segment, "segment");
        Intrinsics.checkNotNullParameter(byArray, "bytes");
        Segment segment2 = segment;
        int n4 = n;
        int n5 = segment2.limit;
        byte[] byArray2 = segment2.data;
        for (int i = n2; i < n3; ++i) {
            if (n4 == n5) {
                Intrinsics.checkNotNull(segment2.next);
                byArray2 = segment2.data;
                n4 = segment2.pos;
                n5 = segment2.limit;
            }
            if (byArray2[n4] != byArray[i]) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    @NotNull
    public static final String readUtf8Line(@NotNull Buffer buffer, long l) {
        String string;
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        if (l > 0L && buffer.getByte(l - 1L) == 13) {
            String string2 = buffer.readUtf8(l - 1L);
            buffer.skip(2L);
            string = string2;
        } else {
            String string3 = buffer.readUtf8(l);
            buffer.skip(1L);
            string = string3;
        }
        return string;
    }

    public static final <T> T seek(@NotNull Buffer buffer, long l, @NotNull Function2<? super Segment, ? super Long, ? extends T> function2) {
        long l2;
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        Intrinsics.checkNotNullParameter(function2, "lambda");
        boolean bl = false;
        Segment segment = buffer.head;
        if (segment == null) {
            return function2.invoke(null, -1L);
        }
        Segment segment2 = segment;
        if (buffer.size() - l < l) {
            long l3;
            for (l3 = buffer.size(); l3 > l; l3 -= (long)(segment2.limit - segment2.pos)) {
                Intrinsics.checkNotNull(segment2.prev);
            }
            return function2.invoke(segment2, l3);
        }
        long l4 = 0L;
        while ((l2 = l4 + (long)(segment2.limit - segment2.pos)) <= l) {
            Intrinsics.checkNotNull(segment2.next);
            l4 = l2;
        }
        return function2.invoke(segment2, l4);
    }

    public static final int selectPrefix(@NotNull Buffer buffer, @NotNull Options options, boolean bl) {
        Segment segment;
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        Intrinsics.checkNotNullParameter(options, "options");
        Segment segment2 = buffer.head;
        if (segment2 == null) {
            return bl ? -2 : -1;
        }
        Segment segment3 = segment = segment2;
        byte[] byArray = segment.data;
        int n = segment.pos;
        int n2 = segment.limit;
        int[] nArray = options.getTrie$okio();
        int n3 = 0;
        int n4 = -1;
        block0: while (true) {
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            int n11 = nArray[n3++];
            if ((n10 = nArray[n3++]) != -1) {
                n4 = n10;
            }
            int n12 = 0;
            if (segment3 == null) break;
            if (n11 < 0) {
                n9 = -1 * n11;
                n8 = n3 + n9;
                do {
                    n7 = byArray[n++];
                    n6 = 255;
                    boolean bl2 = false;
                    n5 = n7 & n6;
                    if (n5 != nArray[n3++]) {
                        return n4;
                    }
                    int n13 = n7 = n3 == n8 ? 1 : 0;
                    if (n != n2) continue;
                    Segment segment4 = segment3;
                    Intrinsics.checkNotNull(segment4);
                    Intrinsics.checkNotNull(segment4.next);
                    n = segment3.pos;
                    byArray = segment3.data;
                    n2 = segment3.limit;
                    if (segment3 != segment) continue;
                    if (n7 == 0) break block0;
                    segment3 = null;
                } while (n7 == 0);
                n12 = nArray[n3];
            } else {
                n9 = n11;
                n5 = byArray[n++];
                n7 = 255;
                n6 = 0;
                n8 = n5 & n7;
                n5 = n3 + n9;
                while (true) {
                    if (n3 == n5) {
                        return n4;
                    }
                    if (n8 == nArray[n3]) break;
                    ++n3;
                }
                n12 = nArray[n3 + n9];
                if (n == n2) {
                    Intrinsics.checkNotNull(segment3.next);
                    n = segment3.pos;
                    byArray = segment3.data;
                    n2 = segment3.limit;
                    if (segment3 == segment) {
                        segment3 = null;
                    }
                }
            }
            if (n12 >= 0) {
                return n12;
            }
            n3 = -n12;
        }
        if (bl) {
            return -2;
        }
        return n4;
    }

    public static /* synthetic */ int selectPrefix$default(Buffer buffer, Options options, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return -Buffer.selectPrefix(buffer, options, bl);
    }

    @NotNull
    public static final Buffer commonCopyTo(@NotNull Buffer buffer, @NotNull Buffer buffer2, long l, long l2) {
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        Intrinsics.checkNotNullParameter(buffer2, "out");
        boolean bl = false;
        long l3 = l;
        long l4 = l2;
        -SegmentedByteString.checkOffsetAndCount(buffer.size(), l3, l4);
        if (l4 == 0L) {
            return buffer;
        }
        buffer2.setSize$okio(buffer2.size() + l4);
        Segment segment = buffer.head;
        while (true) {
            Segment segment2 = segment;
            Intrinsics.checkNotNull(segment2);
            if (l3 < (long)(segment2.limit - segment.pos)) break;
            l3 -= (long)(segment.limit - segment.pos);
            segment = segment.next;
        }
        while (l4 > 0L) {
            Segment segment3 = segment;
            Intrinsics.checkNotNull(segment3);
            Segment segment4 = segment3.sharedCopy();
            segment4.pos += (int)l3;
            segment4.limit = Math.min(segment4.pos + (int)l4, segment4.limit);
            if (buffer2.head == null) {
                buffer2.head = segment4.next = (segment4.prev = segment4);
            } else {
                Segment segment5 = buffer2.head;
                Intrinsics.checkNotNull(segment5);
                Segment segment6 = segment5.prev;
                Intrinsics.checkNotNull(segment6);
                segment6.push(segment4);
            }
            l4 -= (long)(segment4.limit - segment4.pos);
            l3 = 0L;
            segment = segment.next;
        }
        return buffer;
    }

    public static final long commonCompleteSegmentByteCount(@NotNull Buffer buffer) {
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        boolean bl = false;
        long l = buffer.size();
        if (l == 0L) {
            return 0L;
        }
        Segment segment = buffer.head;
        Intrinsics.checkNotNull(segment);
        Segment segment2 = segment.prev;
        Intrinsics.checkNotNull(segment2);
        Segment segment3 = segment2;
        if (segment3.limit < 8192 && segment3.owner) {
            l -= (long)(segment3.limit - segment3.pos);
        }
        return l;
    }

    public static final byte commonReadByte(@NotNull Buffer buffer) {
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        boolean bl = false;
        if (buffer.size() == 0L) {
            throw new EOFException();
        }
        Segment segment = buffer.head;
        Intrinsics.checkNotNull(segment);
        Segment segment2 = segment;
        int n = segment2.pos;
        int n2 = segment2.limit;
        byte[] byArray = segment2.data;
        byte by = byArray[n++];
        buffer.setSize$okio(buffer.size() - 1L);
        if (n == n2) {
            buffer.head = segment2.pop();
            SegmentPool.recycle(segment2);
        } else {
            segment2.pos = n;
        }
        return by;
    }

    public static final short commonReadShort(@NotNull Buffer buffer) {
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        boolean bl = false;
        if (buffer.size() < 2L) {
            throw new EOFException();
        }
        Segment segment = buffer.head;
        Intrinsics.checkNotNull(segment);
        Segment segment2 = segment;
        int n = segment2.pos;
        int n2 = segment2.limit;
        if (n2 - n < 2) {
            byte by = buffer.readByte();
            int n3 = 255;
            boolean bl2 = false;
            int n4 = (by & n3) << 8;
            by = buffer.readByte();
            n3 = 255;
            bl2 = false;
            int n5 = n4 | by & n3;
            return (short)n5;
        }
        byte[] byArray = segment2.data;
        byte by = byArray[n++];
        int n6 = 255;
        boolean bl3 = false;
        int n7 = (by & n6) << 8;
        by = byArray[n++];
        n6 = 255;
        bl3 = false;
        int n8 = n7 | by & n6;
        buffer.setSize$okio(buffer.size() - 2L);
        if (n == n2) {
            buffer.head = segment2.pop();
            SegmentPool.recycle(segment2);
        } else {
            segment2.pos = n;
        }
        return (short)n8;
    }

    public static final int commonReadInt(@NotNull Buffer buffer) {
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        boolean bl = false;
        if (buffer.size() < 4L) {
            throw new EOFException();
        }
        Segment segment = buffer.head;
        Intrinsics.checkNotNull(segment);
        Segment segment2 = segment;
        int n = segment2.pos;
        int n2 = segment2.limit;
        if ((long)(n2 - n) < 4L) {
            byte by = buffer.readByte();
            int n3 = 255;
            boolean bl2 = false;
            int n4 = (by & n3) << 24;
            by = buffer.readByte();
            n3 = 255;
            bl2 = false;
            int n5 = n4 | (by & n3) << 16;
            by = buffer.readByte();
            n3 = 255;
            bl2 = false;
            int n6 = n5 | (by & n3) << 8;
            by = buffer.readByte();
            n3 = 255;
            bl2 = false;
            return n6 | by & n3;
        }
        byte[] byArray = segment2.data;
        byte by = byArray[n++];
        int n7 = 255;
        boolean bl3 = false;
        int n8 = (by & n7) << 24;
        by = byArray[n++];
        n7 = 255;
        bl3 = false;
        int n9 = n8 | (by & n7) << 16;
        by = byArray[n++];
        n7 = 255;
        bl3 = false;
        int n10 = n9 | (by & n7) << 8;
        by = byArray[n++];
        n7 = 255;
        bl3 = false;
        int n11 = n10 | by & n7;
        buffer.setSize$okio(buffer.size() - 4L);
        if (n == n2) {
            buffer.head = segment2.pop();
            SegmentPool.recycle(segment2);
        } else {
            segment2.pos = n;
        }
        return n11;
    }

    public static final long commonReadLong(@NotNull Buffer buffer) {
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        boolean bl = false;
        if (buffer.size() < 8L) {
            throw new EOFException();
        }
        Segment segment = buffer.head;
        Intrinsics.checkNotNull(segment);
        Segment segment2 = segment;
        int n = segment2.pos;
        int n2 = segment2.limit;
        if ((long)(n2 - n) < 8L) {
            int n3 = buffer.readInt();
            long l = 0xFFFFFFFFL;
            boolean bl2 = false;
            long l2 = ((long)n3 & l) << 32;
            n3 = buffer.readInt();
            l = 0xFFFFFFFFL;
            bl2 = false;
            return l2 | (long)n3 & l;
        }
        byte[] byArray = segment2.data;
        byte by = byArray[n++];
        long l = 255L;
        boolean bl3 = false;
        long l3 = ((long)by & l) << 56;
        by = byArray[n++];
        l = 255L;
        bl3 = false;
        long l4 = l3 | ((long)by & l) << 48;
        by = byArray[n++];
        l = 255L;
        bl3 = false;
        long l5 = l4 | ((long)by & l) << 40;
        by = byArray[n++];
        l = 255L;
        bl3 = false;
        long l6 = l5 | ((long)by & l) << 32;
        by = byArray[n++];
        l = 255L;
        bl3 = false;
        long l7 = l6 | ((long)by & l) << 24;
        by = byArray[n++];
        l = 255L;
        bl3 = false;
        long l8 = l7 | ((long)by & l) << 16;
        by = byArray[n++];
        l = 255L;
        bl3 = false;
        long l9 = l8 | ((long)by & l) << 8;
        by = byArray[n++];
        l = 255L;
        bl3 = false;
        long l10 = l9 | (long)by & l;
        buffer.setSize$okio(buffer.size() - 8L);
        if (n == n2) {
            buffer.head = segment2.pop();
            SegmentPool.recycle(segment2);
        } else {
            segment2.pos = n;
        }
        return l10;
    }

    public static final byte commonGet(@NotNull Buffer buffer, long l) {
        long l2;
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        boolean bl = false;
        -SegmentedByteString.checkOffsetAndCount(buffer.size(), l, 1L);
        Buffer buffer2 = buffer;
        boolean bl2 = false;
        Segment segment = buffer2.head;
        if (segment == null) {
            long l3 = -1L;
            Object var8_7 = null;
            boolean bl3 = false;
            Object v1 = var8_7;
            Intrinsics.checkNotNull(v1);
            return v1.data[(int)((long)var8_7.pos + l - l3)];
        }
        Segment segment2 = segment;
        if (buffer2.size() - l < l) {
            long l4;
            for (l4 = buffer2.size(); l4 > l; l4 -= (long)(segment2.limit - segment2.pos)) {
                Intrinsics.checkNotNull(segment2.prev);
            }
            long l5 = l4;
            Segment segment3 = segment2;
            boolean bl4 = false;
            Segment segment4 = segment3;
            Intrinsics.checkNotNull(segment4);
            return segment4.data[(int)((long)segment3.pos + l - l5)];
        }
        long l6 = 0L;
        while ((l2 = l6 + (long)(segment2.limit - segment2.pos)) <= l) {
            Intrinsics.checkNotNull(segment2.next);
            l6 = l2;
        }
        long l7 = l6;
        Segment segment5 = segment2;
        boolean bl5 = false;
        Segment segment6 = segment5;
        Intrinsics.checkNotNull(segment6);
        return segment6.data[(int)((long)segment5.pos + l - l7)];
    }

    public static final void commonClear(@NotNull Buffer buffer) {
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        boolean bl = false;
        buffer.skip(buffer.size());
    }

    public static final void commonSkip(@NotNull Buffer buffer, long l) {
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        boolean bl = false;
        long l2 = l;
        while (l2 > 0L) {
            Segment segment;
            if (buffer.head == null) {
                throw new EOFException();
            }
            int n = segment.limit - segment.pos;
            boolean bl2 = false;
            int n2 = (int)Math.min(l2, (long)n);
            buffer.setSize$okio(buffer.size() - (long)n2);
            l2 -= (long)n2;
            segment.pos += n2;
            if (segment.pos != segment.limit) continue;
            buffer.head = segment.pop();
            SegmentPool.recycle(segment);
        }
    }

    @NotNull
    public static final Buffer commonWrite(@NotNull Buffer buffer, @NotNull ByteString byteString, int n, int n2) {
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        Intrinsics.checkNotNullParameter(byteString, "byteString");
        boolean bl = false;
        byteString.write$okio(buffer, n, n2);
        return buffer;
    }

    public static /* synthetic */ Buffer commonWrite$default(Buffer buffer, ByteString byteString, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byteString.size();
        }
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        Intrinsics.checkNotNullParameter(byteString, "byteString");
        n3 = 0;
        byteString.write$okio(buffer, n, n2);
        return buffer;
    }

    @NotNull
    public static final Buffer commonWriteDecimalLong(@NotNull Buffer buffer, long l) {
        int n;
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        boolean bl = false;
        long l2 = l;
        if (l2 == 0L) {
            return buffer.writeByte(48);
        }
        boolean bl2 = false;
        if (l2 < 0L) {
            if ((l2 = -l2) < 0L) {
                return buffer.writeUtf8("-9223372036854775808");
            }
            bl2 = true;
        }
        int n2 = l2 < 100000000L ? (l2 < 10000L ? (l2 < 100L ? (l2 < 10L ? 1 : 2) : (l2 < 1000L ? 3 : 4)) : (l2 < 1000000L ? (l2 < 100000L ? 5 : 6) : (l2 < 10000000L ? 7 : 8))) : (l2 < 1000000000000L ? (l2 < 10000000000L ? (l2 < 1000000000L ? 9 : 10) : (l2 < 100000000000L ? 11 : 12)) : (l2 < 1000000000000000L ? (l2 < 10000000000000L ? 13 : (l2 < 100000000000000L ? 14 : 15)) : (l2 < 100000000000000000L ? (l2 < 10000000000000000L ? 16 : 17) : (n = l2 < 1000000000000000000L ? 18 : 19))));
        if (bl2) {
            ++n;
        }
        Segment segment = buffer.writableSegment$okio(n);
        byte[] byArray = segment.data;
        int n3 = segment.limit + n;
        while (l2 != 0L) {
            int n4 = (int)(l2 % (long)10);
            byArray[--n3] = -Buffer.getHEX_DIGIT_BYTES()[n4];
            l2 /= (long)10;
        }
        if (bl2) {
            byArray[--n3] = 45;
        }
        segment.limit += n;
        buffer.setSize$okio(buffer.size() + (long)n);
        return buffer;
    }

    @NotNull
    public static final Buffer commonWriteHexadecimalUnsignedLong(@NotNull Buffer buffer, long l) {
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        boolean bl = false;
        long l2 = l;
        if (l2 == 0L) {
            return buffer.writeByte(48);
        }
        long l3 = l2;
        l3 |= l3 >>> 1;
        l3 |= l3 >>> 2;
        l3 |= l3 >>> 4;
        l3 |= l3 >>> 8;
        l3 |= l3 >>> 16;
        l3 |= l3 >>> 32;
        l3 -= l3 >>> 1 & 0x5555555555555555L;
        l3 = (l3 >>> 2 & 0x3333333333333333L) + (l3 & 0x3333333333333333L);
        l3 = (l3 >>> 4) + l3 & 0xF0F0F0F0F0F0F0FL;
        l3 += l3 >>> 8;
        l3 += l3 >>> 16;
        l3 = (l3 & 0x3FL) + (l3 >>> 32 & 0x3FL);
        int n = (int)((l3 + (long)3) / (long)4);
        Segment segment = buffer.writableSegment$okio(n);
        byte[] byArray = segment.data;
        int n2 = segment.limit;
        for (int i = segment.limit + n - 1; i >= n2; --i) {
            byArray[i] = -Buffer.getHEX_DIGIT_BYTES()[(int)(l2 & 0xFL)];
            l2 >>>= 4;
        }
        segment.limit += n;
        buffer.setSize$okio(buffer.size() + (long)n);
        return buffer;
    }

    @NotNull
    public static final Segment commonWritableSegment(@NotNull Buffer buffer, int n) {
        Segment segment;
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        boolean bl = false;
        if (!(n >= 1 && n <= 8192)) {
            boolean bl2 = false;
            String string = "unexpected capacity";
            throw new IllegalArgumentException(string.toString());
        }
        if (buffer.head == null) {
            Segment segment2;
            buffer.head = segment2 = SegmentPool.take();
            segment2.prev = segment2;
            segment2.next = segment2;
            return segment2;
        }
        Segment segment3 = buffer.head;
        Intrinsics.checkNotNull(segment3);
        Segment segment4 = segment = segment3.prev;
        Intrinsics.checkNotNull(segment4);
        if (segment4.limit + n > 8192 || !segment.owner) {
            segment = segment.push(SegmentPool.take());
        }
        return segment;
    }

    @NotNull
    public static final Buffer commonWrite(@NotNull Buffer buffer, @NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        Intrinsics.checkNotNullParameter(byArray, "source");
        boolean bl = false;
        return buffer.write(byArray, 0, byArray.length);
    }

    @NotNull
    public static final Buffer commonWrite(@NotNull Buffer buffer, @NotNull byte[] byArray, int n, int n2) {
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        Intrinsics.checkNotNullParameter(byArray, "source");
        boolean bl = false;
        int n3 = n;
        -SegmentedByteString.checkOffsetAndCount(byArray.length, n3, n2);
        int n4 = n3 + n2;
        while (n3 < n4) {
            Segment segment = buffer.writableSegment$okio(1);
            int n5 = Math.min(n4 - n3, 8192 - segment.limit);
            ArraysKt.copyInto(byArray, segment.data, segment.limit, n3, n3 + n5);
            n3 += n5;
            segment.limit += n5;
        }
        buffer.setSize$okio(buffer.size() + (long)n2);
        return buffer;
    }

    @NotNull
    public static final byte[] commonReadByteArray(@NotNull Buffer buffer) {
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        boolean bl = false;
        return buffer.readByteArray(buffer.size());
    }

    @NotNull
    public static final byte[] commonReadByteArray(@NotNull Buffer buffer, long l) {
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        boolean bl = false;
        if (!(l >= 0L && l <= Integer.MAX_VALUE)) {
            boolean bl2 = false;
            String string = "byteCount: " + l;
            throw new IllegalArgumentException(string.toString());
        }
        if (buffer.size() < l) {
            throw new EOFException();
        }
        byte[] byArray = new byte[(int)l];
        buffer.readFully(byArray);
        return byArray;
    }

    public static final int commonRead(@NotNull Buffer buffer, @NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        Intrinsics.checkNotNullParameter(byArray, "sink");
        boolean bl = false;
        return buffer.read(byArray, 0, byArray.length);
    }

    public static final void commonReadFully(@NotNull Buffer buffer, @NotNull byte[] byArray) {
        int n;
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        Intrinsics.checkNotNullParameter(byArray, "sink");
        boolean bl = false;
        for (int i = 0; i < byArray.length; i += n) {
            n = buffer.read(byArray, i, byArray.length - i);
            if (n != -1) continue;
            throw new EOFException();
        }
    }

    public static final int commonRead(@NotNull Buffer buffer, @NotNull byte[] byArray, int n, int n2) {
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        Intrinsics.checkNotNullParameter(byArray, "sink");
        boolean bl = false;
        -SegmentedByteString.checkOffsetAndCount(byArray.length, n, n2);
        Segment segment = buffer.head;
        if (segment == null) {
            return -1;
        }
        Segment segment2 = segment;
        int n3 = Math.min(n2, segment2.limit - segment2.pos);
        ArraysKt.copyInto(segment2.data, byArray, n, segment2.pos, segment2.pos + n3);
        segment2.pos += n3;
        buffer.setSize$okio(buffer.size() - (long)n3);
        if (segment2.pos == segment2.limit) {
            buffer.head = segment2.pop();
            SegmentPool.recycle(segment2);
        }
        return n3;
    }

    public static final long commonReadDecimalLong(@NotNull Buffer buffer) {
        int n;
        Object object;
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        boolean bl = false;
        if (buffer.size() == 0L) {
            throw new EOFException();
        }
        long l = 0L;
        int n2 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        long l2 = -7L;
        do {
            Segment segment;
            Intrinsics.checkNotNull(buffer.head);
            object = segment.data;
            int n3 = segment.pos;
            int n4 = segment.limit;
            while (n3 < n4) {
                byte by = object[n3];
                if (by >= 48 && by <= 57) {
                    int n5 = 48 - by;
                    if (l < -922337203685477580L || l == -922337203685477580L && (long)n5 < l2) {
                        Buffer buffer2 = new Buffer().writeDecimalLong(l).writeByte(by);
                        if (!bl2) {
                            buffer2.readByte();
                        }
                        throw new NumberFormatException("Number too large: " + buffer2.readUtf8());
                    }
                    l *= 10L;
                    l += (long)n5;
                } else if (by == 45 && n2 == 0) {
                    bl2 = true;
                    --l2;
                } else {
                    bl3 = true;
                    break;
                }
                ++n3;
                ++n2;
            }
            if (n3 == n4) {
                buffer.head = segment.pop();
                SegmentPool.recycle(segment);
                continue;
            }
            segment.pos = n3;
        } while (!bl3 && buffer.head != null);
        buffer.setSize$okio(buffer.size() - (long)n2);
        int n6 = n = bl2 ? 2 : 1;
        if (n2 < n) {
            if (buffer.size() == 0L) {
                throw new EOFException();
            }
            object = bl2 ? "Expected a digit" : "Expected a digit or '-'";
            throw new NumberFormatException((String)object + " but was 0x" + -SegmentedByteString.toHexString(buffer.getByte(0L)));
        }
        return bl2 ? l : -l;
    }

    public static final long commonReadHexadecimalUnsignedLong(@NotNull Buffer buffer) {
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        boolean bl = false;
        if (buffer.size() == 0L) {
            throw new EOFException();
        }
        long l = 0L;
        int n = 0;
        boolean bl2 = false;
        do {
            Segment segment;
            Intrinsics.checkNotNull(buffer.head);
            byte[] byArray = segment.data;
            int n2 = segment.pos;
            int n3 = segment.limit;
            while (n2 < n3) {
                int n4 = 0;
                byte by = byArray[n2];
                if (by >= 48 && by <= 57) {
                    n4 = by - 48;
                } else if (by >= 97 && by <= 102) {
                    n4 = by - 97 + 10;
                } else if (by >= 65 && by <= 70) {
                    n4 = by - 65 + 10;
                } else {
                    if (n == 0) {
                        throw new NumberFormatException("Expected leading [0-9a-fA-F] character but was 0x" + -SegmentedByteString.toHexString(by));
                    }
                    bl2 = true;
                    break;
                }
                if ((l & 0xF000000000000000L) != 0L) {
                    Buffer buffer2 = new Buffer().writeHexadecimalUnsignedLong(l).writeByte(by);
                    throw new NumberFormatException("Number too large: " + buffer2.readUtf8());
                }
                l <<= 4;
                l |= (long)n4;
                ++n2;
                ++n;
            }
            if (n2 == n3) {
                buffer.head = segment.pop();
                SegmentPool.recycle(segment);
                continue;
            }
            segment.pos = n2;
        } while (!bl2 && buffer.head != null);
        buffer.setSize$okio(buffer.size() - (long)n);
        return l;
    }

    @NotNull
    public static final ByteString commonReadByteString(@NotNull Buffer buffer) {
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        boolean bl = false;
        return buffer.readByteString(buffer.size());
    }

    @NotNull
    public static final ByteString commonReadByteString(@NotNull Buffer buffer, long l) {
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        boolean bl = false;
        if (!(l >= 0L && l <= Integer.MAX_VALUE)) {
            boolean bl2 = false;
            String string = "byteCount: " + l;
            throw new IllegalArgumentException(string.toString());
        }
        if (buffer.size() < l) {
            throw new EOFException();
        }
        if (l >= 4096L) {
            ByteString byteString;
            ByteString byteString2 = byteString = buffer.snapshot((int)l);
            boolean bl3 = false;
            buffer.skip(l);
            return byteString;
        }
        return new ByteString(buffer.readByteArray(l));
    }

    public static final int commonSelect(@NotNull Buffer buffer, @NotNull Options options) {
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        Intrinsics.checkNotNullParameter(options, "options");
        boolean bl = false;
        int n = -Buffer.selectPrefix$default(buffer, options, false, 2, null);
        if (n == -1) {
            return -1;
        }
        int n2 = options.getByteStrings$okio()[n].size();
        buffer.skip(n2);
        return n;
    }

    public static final void commonReadFully(@NotNull Buffer buffer, @NotNull Buffer buffer2, long l) {
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        Intrinsics.checkNotNullParameter(buffer2, "sink");
        boolean bl = false;
        if (buffer.size() < l) {
            buffer2.write(buffer, buffer.size());
            throw new EOFException();
        }
        buffer2.write(buffer, l);
    }

    public static final long commonReadAll(@NotNull Buffer buffer, @NotNull Sink sink2) {
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        Intrinsics.checkNotNullParameter(sink2, "sink");
        boolean bl = false;
        long l = buffer.size();
        if (l > 0L) {
            sink2.write(buffer, l);
        }
        return l;
    }

    @NotNull
    public static final String commonReadUtf8(@NotNull Buffer buffer, long l) {
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        boolean bl = false;
        if (!(l >= 0L && l <= Integer.MAX_VALUE)) {
            boolean bl2 = false;
            String string = "byteCount: " + l;
            throw new IllegalArgumentException(string.toString());
        }
        if (buffer.size() < l) {
            throw new EOFException();
        }
        if (l == 0L) {
            return "";
        }
        Segment segment = buffer.head;
        Intrinsics.checkNotNull(segment);
        Segment segment2 = segment;
        if ((long)segment2.pos + l > (long)segment2.limit) {
            return _Utf8Kt.commonToUtf8String$default(buffer.readByteArray(l), 0, 0, 3, null);
        }
        String string = _Utf8Kt.commonToUtf8String(segment2.data, segment2.pos, segment2.pos + (int)l);
        segment2.pos += (int)l;
        buffer.setSize$okio(buffer.size() - l);
        if (segment2.pos == segment2.limit) {
            buffer.head = segment2.pop();
            SegmentPool.recycle(segment2);
        }
        return string;
    }

    @Nullable
    public static final String commonReadUtf8Line(@NotNull Buffer buffer) {
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        boolean bl = false;
        long l = buffer.indexOf((byte)10);
        return l != -1L ? -Buffer.readUtf8Line(buffer, l) : (buffer.size() != 0L ? buffer.readUtf8(buffer.size()) : null);
    }

    @NotNull
    public static final String commonReadUtf8LineStrict(@NotNull Buffer buffer, long l) {
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        boolean bl = false;
        if (!(l >= 0L)) {
            boolean bl2 = false;
            String string = "limit < 0: " + l;
            throw new IllegalArgumentException(string.toString());
        }
        long l2 = l == Long.MAX_VALUE ? Long.MAX_VALUE : l + 1L;
        long l3 = buffer.indexOf((byte)10, 0L, l2);
        if (l3 != -1L) {
            return -Buffer.readUtf8Line(buffer, l3);
        }
        if (l2 < buffer.size() && buffer.getByte(l2 - 1L) == 13 && buffer.getByte(l2) == 10) {
            return -Buffer.readUtf8Line(buffer, l2);
        }
        Buffer buffer2 = new Buffer();
        int n = 32;
        long l4 = buffer.size();
        boolean bl3 = false;
        buffer.copyTo(buffer2, 0L, Math.min((long)n, l4));
        throw new EOFException("\\n not found: limit=" + Math.min(buffer.size(), l) + " content=" + buffer2.readByteString().hex() + '\u2026');
    }

    public static final int commonReadUtf8CodePoint(@NotNull Buffer buffer) {
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        boolean bl = false;
        if (buffer.size() == 0L) {
            throw new EOFException();
        }
        int n = buffer.getByte(0L);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = n;
        int n6 = 128;
        int n7 = 0;
        if ((n5 & n6) == 0) {
            n5 = n;
            n6 = 127;
            n7 = 0;
            n2 = n5 & n6;
            n3 = 1;
            n4 = 0;
        } else {
            n5 = n;
            n6 = 224;
            n7 = 0;
            if ((n5 & n6) == 192) {
                n5 = n;
                n6 = 31;
                n7 = 0;
                n2 = n5 & n6;
                n3 = 2;
                n4 = 128;
            } else {
                n5 = n;
                n6 = 240;
                n7 = 0;
                if ((n5 & n6) == 224) {
                    n5 = n;
                    n6 = 15;
                    n7 = 0;
                    n2 = n5 & n6;
                    n3 = 3;
                    n4 = 2048;
                } else {
                    n5 = n;
                    n6 = 248;
                    n7 = 0;
                    if ((n5 & n6) == 240) {
                        n5 = n;
                        n6 = 7;
                        n7 = 0;
                        n2 = n5 & n6;
                        n3 = 4;
                        n4 = 65536;
                    } else {
                        buffer.skip(1L);
                        return 65533;
                    }
                }
            }
        }
        if (buffer.size() < (long)n3) {
            throw new EOFException("size < " + n3 + ": " + buffer.size() + " (to read code point prefixed 0x" + -SegmentedByteString.toHexString((byte)n) + ')');
        }
        for (n5 = 1; n5 < n3; ++n5) {
            n7 = n6 = (int)buffer.getByte(n5);
            int n8 = 192;
            boolean bl2 = false;
            if ((n7 & n8) == 128) {
                n2 <<= 6;
                n7 = n6;
                n8 = 63;
                bl2 = false;
                n2 |= n7 & n8;
                continue;
            }
            buffer.skip(n5);
            return 65533;
        }
        buffer.skip(n3);
        return n2 > 0x10FFFF ? 65533 : ((55296 <= n2 ? n2 < 57344 : false) ? 65533 : (n2 < n4 ? 65533 : n2));
    }

    @NotNull
    public static final Buffer commonWriteUtf8(@NotNull Buffer buffer, @NotNull String string, int n, int n2) {
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        Intrinsics.checkNotNullParameter(string, "string");
        boolean bl = false;
        if (!(n >= 0)) {
            boolean bl2 = false;
            String string2 = "beginIndex < 0: " + n;
            throw new IllegalArgumentException(string2.toString());
        }
        if (!(n2 >= n)) {
            boolean bl3 = false;
            String string3 = "endIndex < beginIndex: " + n2 + " < " + n;
            throw new IllegalArgumentException(string3.toString());
        }
        if (!(n2 <= string.length())) {
            boolean bl4 = false;
            String string4 = "endIndex > string.length: " + n2 + " > " + string.length();
            throw new IllegalArgumentException(string4.toString());
        }
        int n3 = n;
        while (n3 < n2) {
            char c;
            char c2;
            block12: {
                block11: {
                    c2 = string.charAt(n3);
                    if (c2 < '\u0080') {
                        Segment segment = buffer.writableSegment$okio(1);
                        byte[] byArray = segment.data;
                        int n4 = segment.limit - n3;
                        int n5 = Math.min(n2, 8192 - n4);
                        byArray[n4 + n3++] = (byte)c2;
                        while (n3 < n5 && (c2 = string.charAt(n3)) < '\u0080') {
                            byArray[n4 + n3++] = (byte)c2;
                        }
                        int n6 = n3 + n4 - segment.limit;
                        segment.limit += n6;
                        buffer.setSize$okio(buffer.size() + (long)n6);
                        continue;
                    }
                    if (c2 < '\u0800') {
                        Segment segment = buffer.writableSegment$okio(2);
                        segment.data[segment.limit] = (byte)(c2 >> 6 | 0xC0);
                        segment.data[segment.limit + 1] = (byte)(c2 & 0x3F | 0x80);
                        segment.limit += 2;
                        buffer.setSize$okio(buffer.size() + 2L);
                        ++n3;
                        continue;
                    }
                    if (c2 < '\ud800' || c2 > '\udfff') {
                        Segment segment = buffer.writableSegment$okio(3);
                        segment.data[segment.limit] = (byte)(c2 >> 12 | 0xE0);
                        segment.data[segment.limit + 1] = (byte)(c2 >> 6 & 0x3F | 0x80);
                        segment.data[segment.limit + 2] = (byte)(c2 & 0x3F | 0x80);
                        segment.limit += 3;
                        buffer.setSize$okio(buffer.size() + 3L);
                        ++n3;
                        continue;
                    }
                    char c3 = c = n3 + 1 < n2 ? string.charAt(n3 + 1) : (char)'\u0000';
                    if (c2 > '\udbff') break block11;
                    if ('\udc00' <= c ? c < '\ue000' : false) break block12;
                }
                buffer.writeByte(63);
                ++n3;
                continue;
            }
            int n7 = 65536 + ((c2 & 0x3FF) << 10 | c & 0x3FF);
            Segment segment = buffer.writableSegment$okio(4);
            segment.data[segment.limit] = (byte)(n7 >> 18 | 0xF0);
            segment.data[segment.limit + 1] = (byte)(n7 >> 12 & 0x3F | 0x80);
            segment.data[segment.limit + 2] = (byte)(n7 >> 6 & 0x3F | 0x80);
            segment.data[segment.limit + 3] = (byte)(n7 & 0x3F | 0x80);
            segment.limit += 4;
            buffer.setSize$okio(buffer.size() + 4L);
            n3 += 2;
        }
        return buffer;
    }

    @NotNull
    public static final Buffer commonWriteUtf8CodePoint(@NotNull Buffer buffer, int n) {
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        boolean bl = false;
        if (n < 128) {
            buffer.writeByte(n);
        } else if (n < 2048) {
            Segment segment = buffer.writableSegment$okio(2);
            segment.data[segment.limit] = (byte)(n >> 6 | 0xC0);
            segment.data[segment.limit + 1] = (byte)(n & 0x3F | 0x80);
            segment.limit += 2;
            buffer.setSize$okio(buffer.size() + 2L);
        } else {
            boolean bl2 = 55296 <= n ? n < 57344 : false;
            if (bl2) {
                buffer.writeByte(63);
            } else if (n < 65536) {
                Segment segment = buffer.writableSegment$okio(3);
                segment.data[segment.limit] = (byte)(n >> 12 | 0xE0);
                segment.data[segment.limit + 1] = (byte)(n >> 6 & 0x3F | 0x80);
                segment.data[segment.limit + 2] = (byte)(n & 0x3F | 0x80);
                segment.limit += 3;
                buffer.setSize$okio(buffer.size() + 3L);
            } else if (n <= 0x10FFFF) {
                Segment segment = buffer.writableSegment$okio(4);
                segment.data[segment.limit] = (byte)(n >> 18 | 0xF0);
                segment.data[segment.limit + 1] = (byte)(n >> 12 & 0x3F | 0x80);
                segment.data[segment.limit + 2] = (byte)(n >> 6 & 0x3F | 0x80);
                segment.data[segment.limit + 3] = (byte)(n & 0x3F | 0x80);
                segment.limit += 4;
                buffer.setSize$okio(buffer.size() + 4L);
            } else {
                throw new IllegalArgumentException("Unexpected code point: 0x" + -SegmentedByteString.toHexString(n));
            }
        }
        return buffer;
    }

    public static final long commonWriteAll(@NotNull Buffer buffer, @NotNull Source source2) {
        long l;
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        Intrinsics.checkNotNullParameter(source2, "source");
        boolean bl = false;
        long l2 = 0L;
        while ((l = source2.read(buffer, 8192L)) != -1L) {
            l2 += l;
        }
        return l2;
    }

    @NotNull
    public static final Buffer commonWrite(@NotNull Buffer buffer, @NotNull Source source2, long l) {
        long l2;
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        Intrinsics.checkNotNullParameter(source2, "source");
        boolean bl = false;
        for (long i = l; i > 0L; i -= l2) {
            l2 = source2.read(buffer, i);
            if (l2 != -1L) continue;
            throw new EOFException();
        }
        return buffer;
    }

    @NotNull
    public static final Buffer commonWriteByte(@NotNull Buffer buffer, int n) {
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        boolean bl = false;
        Segment segment = buffer.writableSegment$okio(1);
        int n2 = segment.limit;
        segment.limit = n2 + 1;
        segment.data[n2] = (byte)n;
        buffer.setSize$okio(buffer.size() + 1L);
        return buffer;
    }

    @NotNull
    public static final Buffer commonWriteShort(@NotNull Buffer buffer, int n) {
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        boolean bl = false;
        Segment segment = buffer.writableSegment$okio(2);
        byte[] byArray = segment.data;
        int n2 = segment.limit;
        byArray[n2++] = (byte)(n >>> 8 & 0xFF);
        byArray[n2++] = (byte)(n & 0xFF);
        segment.limit = n2;
        buffer.setSize$okio(buffer.size() + 2L);
        return buffer;
    }

    @NotNull
    public static final Buffer commonWriteInt(@NotNull Buffer buffer, int n) {
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        boolean bl = false;
        Segment segment = buffer.writableSegment$okio(4);
        byte[] byArray = segment.data;
        int n2 = segment.limit;
        byArray[n2++] = (byte)(n >>> 24 & 0xFF);
        byArray[n2++] = (byte)(n >>> 16 & 0xFF);
        byArray[n2++] = (byte)(n >>> 8 & 0xFF);
        byArray[n2++] = (byte)(n & 0xFF);
        segment.limit = n2;
        buffer.setSize$okio(buffer.size() + 4L);
        return buffer;
    }

    @NotNull
    public static final Buffer commonWriteLong(@NotNull Buffer buffer, long l) {
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        boolean bl = false;
        Segment segment = buffer.writableSegment$okio(8);
        byte[] byArray = segment.data;
        int n = segment.limit;
        byArray[n++] = (byte)(l >>> 56 & 0xFFL);
        byArray[n++] = (byte)(l >>> 48 & 0xFFL);
        byArray[n++] = (byte)(l >>> 40 & 0xFFL);
        byArray[n++] = (byte)(l >>> 32 & 0xFFL);
        byArray[n++] = (byte)(l >>> 24 & 0xFFL);
        byArray[n++] = (byte)(l >>> 16 & 0xFFL);
        byArray[n++] = (byte)(l >>> 8 & 0xFFL);
        byArray[n++] = (byte)(l & 0xFFL);
        segment.limit = n;
        buffer.setSize$okio(buffer.size() + 8L);
        return buffer;
    }

    public static final void commonWrite(@NotNull Buffer buffer, @NotNull Buffer buffer2, long l) {
        long l2;
        long l3;
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        Intrinsics.checkNotNullParameter(buffer2, "source");
        boolean bl = false;
        if (!(buffer2 != buffer)) {
            boolean bl2 = false;
            String string = "source == this";
            throw new IllegalArgumentException(string.toString());
        }
        -SegmentedByteString.checkOffsetAndCount(buffer2.size(), 0L, l3);
        for (l3 = l; l3 > 0L; l3 -= l2) {
            Segment segment;
            Segment segment2 = buffer2.head;
            Intrinsics.checkNotNull(segment2);
            int n = segment2.limit;
            Segment segment3 = buffer2.head;
            Intrinsics.checkNotNull(segment3);
            if (l3 < (long)(n - segment3.pos)) {
                Segment segment4;
                if (buffer.head != null) {
                    Segment segment5 = buffer.head;
                    Intrinsics.checkNotNull(segment5);
                    segment4 = segment5.prev;
                } else {
                    segment4 = segment = null;
                }
                if (segment != null && segment.owner && l3 + (long)segment.limit - (long)(segment.shared ? 0 : segment.pos) <= 8192L) {
                    Segment segment6 = buffer2.head;
                    Intrinsics.checkNotNull(segment6);
                    segment6.writeTo(segment, (int)l3);
                    buffer2.setSize$okio(buffer2.size() - l3);
                    buffer.setSize$okio(buffer.size() + l3);
                    return;
                }
                Segment segment7 = buffer2.head;
                Intrinsics.checkNotNull(segment7);
                buffer2.head = segment7.split((int)l3);
            }
            Segment segment8 = segment = buffer2.head;
            Intrinsics.checkNotNull(segment8);
            l2 = segment8.limit - segment.pos;
            buffer2.head = segment.pop();
            if (buffer.head == null) {
                buffer.head = segment;
                segment.next = segment.prev = segment;
            } else {
                Segment segment9;
                Segment segment10 = buffer.head;
                Intrinsics.checkNotNull(segment10);
                Segment segment11 = segment9 = segment10.prev;
                Intrinsics.checkNotNull(segment11);
                segment9 = segment11.push(segment);
                segment9.compact();
            }
            buffer2.setSize$okio(buffer2.size() - l2);
            buffer.setSize$okio(buffer.size() + l2);
        }
    }

    public static final long commonRead(@NotNull Buffer buffer, @NotNull Buffer buffer2, long l) {
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        Intrinsics.checkNotNullParameter(buffer2, "sink");
        boolean bl = false;
        long l2 = 0L;
        l2 = l;
        if (!(l2 >= 0L)) {
            boolean bl2 = false;
            String string = "byteCount < 0: " + l2;
            throw new IllegalArgumentException(string.toString());
        }
        if (buffer.size() == 0L) {
            return -1L;
        }
        if (l2 > buffer.size()) {
            l2 = buffer.size();
        }
        buffer2.write(buffer, l2);
        return l2;
    }

    public static final long commonIndexOf(@NotNull Buffer buffer, byte by, long l, long l2) {
        long l3;
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        boolean bl = false;
        long l4 = 0L;
        l4 = l;
        long l5 = 0L;
        l5 = l2;
        if (!(0L <= l4 ? l4 <= l5 : false)) {
            boolean bl2 = false;
            String string = "size=" + buffer.size() + " fromIndex=" + l4 + " toIndex=" + l5;
            throw new IllegalArgumentException(string.toString());
        }
        if (l5 > buffer.size()) {
            l5 = buffer.size();
        }
        if (l4 == l5) {
            return -1L;
        }
        Buffer buffer2 = buffer;
        long l6 = l4;
        boolean bl3 = false;
        Segment segment = buffer2.head;
        if (segment == null) {
            long l7 = -1L;
            Object var13_14 = null;
            boolean bl4 = false;
            return -1L;
        }
        Segment segment2 = segment;
        if (buffer2.size() - l6 < l6) {
            long l8;
            for (l8 = buffer2.size(); l8 > l6; l8 -= (long)(segment2.limit - segment2.pos)) {
                Intrinsics.checkNotNull(segment2.prev);
            }
            long l9 = l8;
            Segment segment3 = segment2;
            boolean bl5 = false;
            Segment segment4 = segment3;
            if (segment4 == null) {
                return -1L;
            }
            Segment segment5 = segment4;
            long l10 = l9;
            while (l10 < l5) {
                byte[] byArray = segment5.data;
                int n = (int)Math.min((long)segment5.limit, (long)segment5.pos + l5 - l10);
                for (int i = (int)((long)segment5.pos + l4 - l10); i < n; ++i) {
                    if (byArray[i] != by) continue;
                    return (long)(i - segment5.pos) + l10;
                }
                l4 = l10 += (long)(segment5.limit - segment5.pos);
                Intrinsics.checkNotNull(segment5.next);
            }
            return -1L;
        }
        long l11 = 0L;
        while ((l3 = l11 + (long)(segment2.limit - segment2.pos)) <= l6) {
            Intrinsics.checkNotNull(segment2.next);
            l11 = l3;
        }
        long l12 = l11;
        Segment segment6 = segment2;
        boolean bl6 = false;
        Segment segment7 = segment6;
        if (segment7 == null) {
            return -1L;
        }
        Segment segment8 = segment7;
        long l13 = l12;
        while (l13 < l5) {
            byte[] byArray = segment8.data;
            int n = (int)Math.min((long)segment8.limit, (long)segment8.pos + l5 - l13);
            for (int i = (int)((long)segment8.pos + l4 - l13); i < n; ++i) {
                if (byArray[i] != by) continue;
                return (long)(i - segment8.pos) + l13;
            }
            l4 = l13 += (long)(segment8.limit - segment8.pos);
            Intrinsics.checkNotNull(segment8.next);
        }
        return -1L;
    }

    public static final long commonIndexOf(@NotNull Buffer buffer, @NotNull ByteString byteString, long l) {
        long l2;
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        Intrinsics.checkNotNullParameter(byteString, "bytes");
        boolean bl = false;
        long l3 = 0L;
        l3 = l;
        if (!(byteString.size() > 0)) {
            boolean bl2 = false;
            String string = "bytes is empty";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(l3 >= 0L)) {
            boolean bl3 = false;
            String string = "fromIndex < 0: " + l3;
            throw new IllegalArgumentException(string.toString());
        }
        Buffer buffer2 = buffer;
        long l4 = l3;
        boolean bl4 = false;
        Segment segment = buffer2.head;
        if (segment == null) {
            long l5 = -1L;
            Object var11_14 = null;
            boolean bl5 = false;
            return -1L;
        }
        Segment segment2 = segment;
        if (buffer2.size() - l4 < l4) {
            long l6;
            for (l6 = buffer2.size(); l6 > l4; l6 -= (long)(segment2.limit - segment2.pos)) {
                Intrinsics.checkNotNull(segment2.prev);
            }
            long l7 = l6;
            Segment segment3 = segment2;
            boolean bl6 = false;
            Segment segment4 = segment3;
            if (segment4 == null) {
                return -1L;
            }
            Segment segment5 = segment4;
            long l8 = l7;
            byte[] byArray = byteString.internalArray$okio();
            byte by = byArray[0];
            int n = byteString.size();
            long l9 = buffer.size() - (long)n + 1L;
            while (l8 < l9) {
                byte[] byArray2 = segment5.data;
                int n2 = segment5.limit;
                long l10 = (long)segment5.pos + l9 - l8;
                boolean bl7 = false;
                int n3 = (int)Math.min((long)n2, l10);
                for (n2 = (int)((long)segment5.pos + l3 - l8); n2 < n3; ++n2) {
                    if (byArray2[n2] != by || !-Buffer.rangeEquals(segment5, n2 + 1, byArray, 1, n)) continue;
                    return (long)(n2 - segment5.pos) + l8;
                }
                l3 = l8 += (long)(segment5.limit - segment5.pos);
                Intrinsics.checkNotNull(segment5.next);
            }
            return -1L;
        }
        long l11 = 0L;
        while ((l2 = l11 + (long)(segment2.limit - segment2.pos)) <= l4) {
            Intrinsics.checkNotNull(segment2.next);
            l11 = l2;
        }
        long l12 = l11;
        Segment segment6 = segment2;
        boolean bl8 = false;
        Segment segment7 = segment6;
        if (segment7 == null) {
            return -1L;
        }
        Segment segment8 = segment7;
        long l13 = l12;
        byte[] byArray = byteString.internalArray$okio();
        byte by = byArray[0];
        int n = byteString.size();
        long l14 = buffer.size() - (long)n + 1L;
        while (l13 < l14) {
            byte[] byArray3 = segment8.data;
            int n4 = segment8.limit;
            long l15 = (long)segment8.pos + l14 - l13;
            boolean bl9 = false;
            int n5 = (int)Math.min((long)n4, l15);
            for (n4 = (int)((long)segment8.pos + l3 - l13); n4 < n5; ++n4) {
                if (byArray3[n4] != by || !-Buffer.rangeEquals(segment8, n4 + 1, byArray, 1, n)) continue;
                return (long)(n4 - segment8.pos) + l13;
            }
            l3 = l13 += (long)(segment8.limit - segment8.pos);
            Intrinsics.checkNotNull(segment8.next);
        }
        return -1L;
    }

    public static final long commonIndexOfElement(@NotNull Buffer buffer, @NotNull ByteString byteString, long l) {
        long l2;
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        Intrinsics.checkNotNullParameter(byteString, "targetBytes");
        boolean bl = false;
        long l3 = 0L;
        l3 = l;
        if (!(l3 >= 0L)) {
            boolean bl2 = false;
            String string = "fromIndex < 0: " + l3;
            throw new IllegalArgumentException(string.toString());
        }
        Buffer buffer2 = buffer;
        long l4 = l3;
        boolean bl3 = false;
        Segment segment = buffer2.head;
        if (segment == null) {
            long l5 = -1L;
            Object var11_12 = null;
            boolean bl4 = false;
            return -1L;
        }
        Segment segment2 = segment;
        if (buffer2.size() - l4 < l4) {
            long l6;
            for (l6 = buffer2.size(); l6 > l4; l6 -= (long)(segment2.limit - segment2.pos)) {
                Intrinsics.checkNotNull(segment2.prev);
            }
            long l7 = l6;
            Segment segment3 = segment2;
            boolean bl5 = false;
            Segment segment4 = segment3;
            if (segment4 == null) {
                return -1L;
            }
            Segment segment5 = segment4;
            long l8 = l7;
            if (byteString.size() == 2) {
                byte by = byteString.getByte(0);
                byte by2 = byteString.getByte(1);
                while (l8 < buffer.size()) {
                    byte[] byArray = segment5.data;
                    int n = segment5.limit;
                    for (int i = (int)((long)segment5.pos + l3 - l8); i < n; ++i) {
                        byte by3 = byArray[i];
                        if (by3 != by && by3 != by2) continue;
                        return (long)(i - segment5.pos) + l8;
                    }
                    l3 = l8 += (long)(segment5.limit - segment5.pos);
                    Intrinsics.checkNotNull(segment5.next);
                }
            } else {
                byte[] byArray = byteString.internalArray$okio();
                while (l8 < buffer.size()) {
                    byte[] byArray2 = segment5.data;
                    int n = segment5.limit;
                    for (int i = (int)((long)segment5.pos + l3 - l8); i < n; ++i) {
                        byte by = byArray2[i];
                        for (byte by4 : byArray) {
                            if (by != by4) continue;
                            return (long)(i - segment5.pos) + l8;
                        }
                    }
                    l3 = l8 += (long)(segment5.limit - segment5.pos);
                    Intrinsics.checkNotNull(segment5.next);
                }
            }
            return -1L;
        }
        long l9 = 0L;
        while ((l2 = l9 + (long)(segment2.limit - segment2.pos)) <= l4) {
            Intrinsics.checkNotNull(segment2.next);
            l9 = l2;
        }
        long l10 = l9;
        Segment segment6 = segment2;
        boolean bl6 = false;
        Segment segment7 = segment6;
        if (segment7 == null) {
            return -1L;
        }
        Segment segment8 = segment7;
        long l11 = l10;
        if (byteString.size() == 2) {
            byte by = byteString.getByte(0);
            byte by5 = byteString.getByte(1);
            while (l11 < buffer.size()) {
                byte[] byArray = segment8.data;
                int n = segment8.limit;
                for (int i = (int)((long)segment8.pos + l3 - l11); i < n; ++i) {
                    byte by6 = byArray[i];
                    if (by6 != by && by6 != by5) continue;
                    return (long)(i - segment8.pos) + l11;
                }
                l3 = l11 += (long)(segment8.limit - segment8.pos);
                Intrinsics.checkNotNull(segment8.next);
            }
        } else {
            byte[] byArray = byteString.internalArray$okio();
            while (l11 < buffer.size()) {
                byte[] byArray3 = segment8.data;
                int n = segment8.limit;
                for (int i = (int)((long)segment8.pos + l3 - l11); i < n; ++i) {
                    byte by = byArray3[i];
                    for (byte by7 : byArray) {
                        if (by != by7) continue;
                        return (long)(i - segment8.pos) + l11;
                    }
                }
                l3 = l11 += (long)(segment8.limit - segment8.pos);
                Intrinsics.checkNotNull(segment8.next);
            }
        }
        return -1L;
    }

    public static final boolean commonRangeEquals(@NotNull Buffer buffer, long l, @NotNull ByteString byteString, int n, int n2) {
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        Intrinsics.checkNotNullParameter(byteString, "bytes");
        boolean bl = false;
        if (l < 0L || n < 0 || n2 < 0 || buffer.size() - l < (long)n2 || byteString.size() - n < n2) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (buffer.getByte(l + (long)i) == byteString.getByte(n + i)) continue;
            return false;
        }
        return true;
    }

    public static final boolean commonEquals(@NotNull Buffer buffer, @Nullable Object object) {
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        boolean bl = false;
        if (buffer == object) {
            return true;
        }
        if (!(object instanceof Buffer)) {
            return false;
        }
        if (buffer.size() != ((Buffer)object).size()) {
            return false;
        }
        if (buffer.size() == 0L) {
            return true;
        }
        Segment segment = buffer.head;
        Intrinsics.checkNotNull(segment);
        Segment segment2 = segment;
        Segment segment3 = ((Buffer)object).head;
        Intrinsics.checkNotNull(segment3);
        Segment segment4 = segment3;
        int n = segment2.pos;
        int n2 = segment4.pos;
        long l = 0L;
        for (long i = 0L; i < buffer.size(); i += l) {
            l = Math.min(segment2.limit - n, segment4.limit - n2);
            long l2 = l;
            for (long j = 0L; j < l2; ++j) {
                if (segment2.data[n++] == segment4.data[n2++]) continue;
                return false;
            }
            if (n == segment2.limit) {
                Intrinsics.checkNotNull(segment2.next);
                n = segment2.pos;
            }
            if (n2 != segment4.limit) continue;
            Intrinsics.checkNotNull(segment4.next);
            n2 = segment4.pos;
        }
        return true;
    }

    public static final int commonHashCode(@NotNull Buffer buffer) {
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        boolean bl = false;
        Segment segment = buffer.head;
        if (segment == null) {
            return 0;
        }
        Segment segment2 = segment;
        int n = 1;
        do {
            int n2 = segment2.limit;
            for (int i = segment2.pos; i < n2; ++i) {
                n = 31 * n + segment2.data[i];
            }
            Intrinsics.checkNotNull(segment2.next);
        } while (segment2 != buffer.head);
        return n;
    }

    @NotNull
    public static final Buffer commonCopy(@NotNull Buffer buffer) {
        Segment segment;
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        boolean bl = false;
        Buffer buffer2 = new Buffer();
        if (buffer.size() == 0L) {
            return buffer2;
        }
        Segment segment2 = buffer.head;
        Intrinsics.checkNotNull(segment2);
        Segment segment3 = segment2;
        segment.next = segment.prev = (buffer2.head = (segment = segment3.sharedCopy()));
        Segment segment4 = segment3.next;
        while (segment4 != segment3) {
            Segment segment5 = segment.prev;
            Intrinsics.checkNotNull(segment5);
            Segment segment6 = segment4;
            Intrinsics.checkNotNull(segment6);
            segment5.push(segment6.sharedCopy());
            segment4 = segment4.next;
        }
        buffer2.setSize$okio(buffer.size());
        return buffer2;
    }

    @NotNull
    public static final ByteString commonSnapshot(@NotNull Buffer buffer) {
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        boolean bl = false;
        if (!(buffer.size() <= Integer.MAX_VALUE)) {
            boolean bl2 = false;
            String string = "size > Int.MAX_VALUE: " + buffer.size();
            throw new IllegalStateException(string.toString());
        }
        return buffer.snapshot((int)buffer.size());
    }

    @NotNull
    public static final ByteString commonSnapshot(@NotNull Buffer buffer, int n) {
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        boolean bl = false;
        if (n == 0) {
            return ByteString.EMPTY;
        }
        -SegmentedByteString.checkOffsetAndCount(buffer.size(), 0L, n);
        int n2 = 0;
        int n3 = 0;
        Segment segment = buffer.head;
        while (n2 < n) {
            Segment segment2 = segment;
            Intrinsics.checkNotNull(segment2);
            if (segment2.limit == segment.pos) {
                throw new AssertionError((Object)"s.limit == s.pos");
            }
            n2 += segment.limit - segment.pos;
            ++n3;
            segment = segment.next;
        }
        byte[][] byArrayArray = new byte[n3][];
        int[] nArray = new int[n3 * 2];
        n2 = 0;
        n3 = 0;
        segment = buffer.head;
        while (n2 < n) {
            Segment segment3 = segment;
            Intrinsics.checkNotNull(segment3);
            byArrayArray[n3] = segment3.data;
            nArray[n3] = Math.min(n2 += segment.limit - segment.pos, n);
            nArray[n3 + ((Object[])byArrayArray).length] = segment.pos;
            segment.shared = true;
            ++n3;
            segment = segment.next;
        }
        return new SegmentedByteString(byArrayArray, nArray);
    }

    @NotNull
    public static final Buffer$UnsafeCursor commonReadUnsafe(@NotNull Buffer buffer, @NotNull Buffer$UnsafeCursor buffer$UnsafeCursor) {
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        Intrinsics.checkNotNullParameter(buffer$UnsafeCursor, "unsafeCursor");
        Buffer$UnsafeCursor buffer$UnsafeCursor2 = -SegmentedByteString.resolveDefaultParameter(buffer$UnsafeCursor);
        if (!(buffer$UnsafeCursor2.buffer == null)) {
            boolean bl = false;
            String string = "already attached to a buffer";
            throw new IllegalStateException(string.toString());
        }
        buffer$UnsafeCursor2.buffer = buffer;
        buffer$UnsafeCursor2.readWrite = false;
        return buffer$UnsafeCursor2;
    }

    @NotNull
    public static final Buffer$UnsafeCursor commonReadAndWriteUnsafe(@NotNull Buffer buffer, @NotNull Buffer$UnsafeCursor buffer$UnsafeCursor) {
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        Intrinsics.checkNotNullParameter(buffer$UnsafeCursor, "unsafeCursor");
        Buffer$UnsafeCursor buffer$UnsafeCursor2 = -SegmentedByteString.resolveDefaultParameter(buffer$UnsafeCursor);
        if (!(buffer$UnsafeCursor2.buffer == null)) {
            boolean bl = false;
            String string = "already attached to a buffer";
            throw new IllegalStateException(string.toString());
        }
        buffer$UnsafeCursor2.buffer = buffer;
        buffer$UnsafeCursor2.readWrite = true;
        return buffer$UnsafeCursor2;
    }

    public static final int commonNext(@NotNull Buffer$UnsafeCursor buffer$UnsafeCursor) {
        Intrinsics.checkNotNullParameter(buffer$UnsafeCursor, "<this>");
        boolean bl = false;
        long l = buffer$UnsafeCursor.offset;
        Buffer buffer = buffer$UnsafeCursor.buffer;
        Intrinsics.checkNotNull(buffer);
        if (!(l != buffer.size())) {
            boolean bl2 = false;
            String string = "no more bytes";
            throw new IllegalStateException(string.toString());
        }
        return buffer$UnsafeCursor.offset == -1L ? buffer$UnsafeCursor.seek(0L) : buffer$UnsafeCursor.seek(buffer$UnsafeCursor.offset + (long)(buffer$UnsafeCursor.end - buffer$UnsafeCursor.start));
    }

    public static final int commonSeek(@NotNull Buffer$UnsafeCursor buffer$UnsafeCursor, long l) {
        Intrinsics.checkNotNullParameter(buffer$UnsafeCursor, "<this>");
        boolean bl = false;
        Buffer buffer = buffer$UnsafeCursor.buffer;
        if (buffer == null) {
            boolean bl2 = false;
            String string = "not attached to a buffer";
            throw new IllegalStateException(string.toString());
        }
        Buffer buffer2 = buffer;
        if (l < -1L || l > buffer2.size()) {
            throw new ArrayIndexOutOfBoundsException("offset=" + l + " > size=" + buffer2.size());
        }
        if (l == -1L || l == buffer2.size()) {
            buffer$UnsafeCursor.setSegment$okio(null);
            buffer$UnsafeCursor.offset = l;
            buffer$UnsafeCursor.data = null;
            buffer$UnsafeCursor.start = -1;
            buffer$UnsafeCursor.end = -1;
            return -1;
        }
        long l2 = 0L;
        long l3 = buffer2.size();
        Segment segment = buffer2.head;
        Segment segment2 = buffer2.head;
        if (buffer$UnsafeCursor.getSegment$okio() != null) {
            long l4 = buffer$UnsafeCursor.offset;
            int n = buffer$UnsafeCursor.start;
            Segment segment3 = buffer$UnsafeCursor.getSegment$okio();
            Intrinsics.checkNotNull(segment3);
            long l5 = l4 - (long)(n - segment3.pos);
            if (l5 > l) {
                l3 = l5;
                segment2 = buffer$UnsafeCursor.getSegment$okio();
            } else {
                l2 = l5;
                segment = buffer$UnsafeCursor.getSegment$okio();
            }
        }
        Segment segment4 = null;
        long l6 = 0L;
        if (l3 - l > l - l2) {
            segment4 = segment;
            l6 = l2;
            while (true) {
                Segment segment5 = segment4;
                Intrinsics.checkNotNull(segment5);
                if (l >= l6 + (long)(segment5.limit - segment4.pos)) {
                    l6 += (long)(segment4.limit - segment4.pos);
                    segment4 = segment4.next;
                    continue;
                }
                break;
            }
        } else {
            Segment segment6;
            segment4 = segment2;
            for (l6 = l3; l6 > l; l6 -= (long)(segment6.limit - segment4.pos)) {
                Segment segment7 = segment4;
                Intrinsics.checkNotNull(segment7);
                segment6 = segment4 = segment7.prev;
                Intrinsics.checkNotNull(segment6);
            }
        }
        if (buffer$UnsafeCursor.readWrite) {
            Segment segment8 = segment4;
            Intrinsics.checkNotNull(segment8);
            if (segment8.shared) {
                Segment segment9 = segment4.unsharedCopy();
                if (buffer2.head == segment4) {
                    buffer2.head = segment9;
                }
                segment4 = segment4.push(segment9);
                Segment segment10 = segment4.prev;
                Intrinsics.checkNotNull(segment10);
                segment10.pop();
            }
        }
        buffer$UnsafeCursor.setSegment$okio(segment4);
        buffer$UnsafeCursor.offset = l;
        Segment segment11 = segment4;
        Intrinsics.checkNotNull(segment11);
        buffer$UnsafeCursor.data = segment11.data;
        buffer$UnsafeCursor.start = segment4.pos + (int)(l - l6);
        buffer$UnsafeCursor.end = segment4.limit;
        return buffer$UnsafeCursor.end - buffer$UnsafeCursor.start;
    }

    public static final long commonResizeBuffer(@NotNull Buffer$UnsafeCursor buffer$UnsafeCursor, long l) {
        Intrinsics.checkNotNullParameter(buffer$UnsafeCursor, "<this>");
        boolean bl = false;
        Buffer buffer = buffer$UnsafeCursor.buffer;
        if (buffer == null) {
            boolean bl2 = false;
            String string = "not attached to a buffer";
            throw new IllegalStateException(string.toString());
        }
        Buffer buffer2 = buffer;
        if (!buffer$UnsafeCursor.readWrite) {
            boolean bl3 = false;
            String string = "resizeBuffer() only permitted for read/write buffers";
            throw new IllegalStateException(string.toString());
        }
        long l2 = buffer2.size();
        if (l <= l2) {
            int n;
            if (!(l >= 0L)) {
                boolean bl4 = false;
                String string = "newSize < 0: " + l;
                throw new IllegalArgumentException(string.toString());
            }
            for (long i = l2 - l; i > 0L; i -= (long)n) {
                Segment segment;
                Segment segment2 = buffer2.head;
                Intrinsics.checkNotNull(segment2);
                Segment segment3 = segment = segment2.prev;
                Intrinsics.checkNotNull(segment3);
                n = segment3.limit - segment.pos;
                if ((long)n <= i) {
                    buffer2.head = segment.pop();
                    SegmentPool.recycle(segment);
                    continue;
                }
                segment.limit -= (int)i;
                break;
            }
            buffer$UnsafeCursor.setSegment$okio(null);
            buffer$UnsafeCursor.offset = l;
            buffer$UnsafeCursor.data = null;
            buffer$UnsafeCursor.start = -1;
            buffer$UnsafeCursor.end = -1;
        } else if (l > l2) {
            int n;
            boolean bl5 = true;
            for (long i = l - l2; i > 0L; i -= (long)n) {
                Segment segment = buffer2.writableSegment$okio(1);
                int n2 = 8192 - segment.limit;
                boolean bl6 = false;
                n = (int)Math.min(i, (long)n2);
                segment.limit += n;
                if (!bl5) continue;
                buffer$UnsafeCursor.setSegment$okio(segment);
                buffer$UnsafeCursor.offset = l2;
                buffer$UnsafeCursor.data = segment.data;
                buffer$UnsafeCursor.start = segment.limit - n;
                buffer$UnsafeCursor.end = segment.limit;
                bl5 = false;
            }
        }
        buffer2.setSize$okio(l);
        return l2;
    }

    public static final long commonExpandBuffer(@NotNull Buffer$UnsafeCursor buffer$UnsafeCursor, int n) {
        Intrinsics.checkNotNullParameter(buffer$UnsafeCursor, "<this>");
        boolean bl = false;
        if (!(n > 0)) {
            boolean bl2 = false;
            String string = "minByteCount <= 0: " + n;
            throw new IllegalArgumentException(string.toString());
        }
        if (!(n <= 8192)) {
            boolean bl3 = false;
            String string = "minByteCount > Segment.SIZE: " + n;
            throw new IllegalArgumentException(string.toString());
        }
        Buffer buffer = buffer$UnsafeCursor.buffer;
        if (buffer == null) {
            boolean bl4 = false;
            String string = "not attached to a buffer";
            throw new IllegalStateException(string.toString());
        }
        Buffer buffer2 = buffer;
        if (!buffer$UnsafeCursor.readWrite) {
            boolean bl5 = false;
            String string = "expandBuffer() only permitted for read/write buffers";
            throw new IllegalStateException(string.toString());
        }
        long l = buffer2.size();
        Segment segment = buffer2.writableSegment$okio(n);
        int n2 = 8192 - segment.limit;
        segment.limit = 8192;
        buffer2.setSize$okio(l + (long)n2);
        buffer$UnsafeCursor.setSegment$okio(segment);
        buffer$UnsafeCursor.offset = l;
        buffer$UnsafeCursor.data = segment.data;
        buffer$UnsafeCursor.start = 8192 - n2;
        buffer$UnsafeCursor.end = 8192;
        return n2;
    }

    public static final void commonClose(@NotNull Buffer$UnsafeCursor buffer$UnsafeCursor) {
        Intrinsics.checkNotNullParameter(buffer$UnsafeCursor, "<this>");
        boolean bl = false;
        if (!(buffer$UnsafeCursor.buffer != null)) {
            boolean bl2 = false;
            String string = "not attached to a buffer";
            throw new IllegalStateException(string.toString());
        }
        buffer$UnsafeCursor.buffer = null;
        buffer$UnsafeCursor.setSegment$okio(null);
        buffer$UnsafeCursor.offset = -1L;
        buffer$UnsafeCursor.data = null;
        buffer$UnsafeCursor.start = -1;
        buffer$UnsafeCursor.end = -1;
    }
}

