/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.zip.Inflater;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.BufferedSource;
import okio.FileHandle;
import okio.FileMetadata;
import okio.FileSystem;
import okio.InflaterSource;
import okio.Okio;
import okio.Path;
import okio.Path$Companion;
import okio.Sink;
import okio.Source;
import okio.ZipFileSystem$Companion;
import okio.internal.FixedLengthSource;
import okio.internal.ZipEntry;
import okio.internal.ZipFilesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 '2\u00020\u0001:\u0001'B5\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003H\u0002J\u0018\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u000fH\u0016J\u0018\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\u0018\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\u001d2\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J \u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u001d2\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u000fH\u0002J\u0018\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u001d2\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\r\u001a\u00020\u0003H\u0016J \u0010$\u001a\u00020#2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010%\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u000fH\u0016J\u0010\u0010\u0012\u001a\u00020&2\u0006\u0010\r\u001a\u00020\u0003H\u0016R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lokio/ZipFileSystem;", "Lokio/FileSystem;", "zipPath", "Lokio/Path;", "fileSystem", "entries", "", "Lokio/internal/ZipEntry;", "comment", "", "(Lokio/Path;Lokio/FileSystem;Ljava/util/Map;Ljava/lang/String;)V", "appendingSink", "Lokio/Sink;", "file", "mustExist", "", "atomicMove", "", "source", "target", "canonicalize", "path", "canonicalizeInternal", "createDirectory", "dir", "mustCreate", "createSymlink", "delete", "list", "", "throwOnFailure", "listOrNull", "metadataOrNull", "Lokio/FileMetadata;", "openReadOnly", "Lokio/FileHandle;", "openReadWrite", "sink", "Lokio/Source;", "Companion", "okio"})
@SourceDebugExtension(value={"SMAP\nZipFileSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZipFileSystem.kt\nokio/ZipFileSystem\n+ 2 Okio.kt\nokio/Okio__OkioKt\n*L\n1#1,175:1\n52#2,5:176\n52#2,21:181\n60#2,10:202\n57#2,2:212\n71#2,2:214\n52#2,21:216\n*S KotlinDebug\n*F\n+ 1 ZipFileSystem.kt\nokio/ZipFileSystem\n*L\n102#1:176,5\n103#1:181,21\n102#1:202,10\n102#1:212,2\n102#1:214,2\n132#1:216,21\n*E\n"})
public final class ZipFileSystem
extends FileSystem {
    @NotNull
    private static final ZipFileSystem$Companion Companion = new ZipFileSystem$Companion(null);
    @NotNull
    private final Path zipPath;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final Map<Path, ZipEntry> entries;
    @Nullable
    private final String comment;
    @NotNull
    private static final Path ROOT = Path$Companion.get$default(Path.Companion, "/", false, 1, null);

    public ZipFileSystem(@NotNull Path path, @NotNull FileSystem fileSystem, @NotNull Map<Path, ZipEntry> map, @Nullable String string) {
        Intrinsics.checkNotNullParameter(path, "zipPath");
        Intrinsics.checkNotNullParameter(fileSystem, "fileSystem");
        Intrinsics.checkNotNullParameter(map, "entries");
        this.zipPath = path;
        this.fileSystem = fileSystem;
        this.entries = map;
        this.comment = string;
    }

    @Override
    @NotNull
    public Path canonicalize(@NotNull Path path) {
        Intrinsics.checkNotNullParameter(path, "path");
        Path path2 = this.canonicalizeInternal(path);
        if (!this.entries.containsKey(path2)) {
            throw new FileNotFoundException(String.valueOf(path));
        }
        return path2;
    }

    private final Path canonicalizeInternal(Path path) {
        return ROOT.resolve(path, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @Nullable
    public FileMetadata metadataOrNull(@NotNull Path path) {
        Throwable throwable;
        FileMetadata fileMetadata;
        block33: {
            Throwable throwable2;
            FileMetadata fileMetadata2;
            Closeable closeable;
            block32: {
                Intrinsics.checkNotNullParameter(path, "path");
                Path path2 = this.canonicalizeInternal(path);
                ZipEntry zipEntry = this.entries.get(path2);
                if (zipEntry == null) {
                    return null;
                }
                ZipEntry zipEntry2 = zipEntry;
                FileMetadata fileMetadata3 = new FileMetadata(!zipEntry2.isDirectory(), zipEntry2.isDirectory(), null, zipEntry2.isDirectory() ? null : Long.valueOf(zipEntry2.getSize()), null, zipEntry2.getLastModifiedAtMillis(), null, null, 128, null);
                if (zipEntry2.getOffset() == -1L) {
                    return fileMetadata3;
                }
                closeable = this.fileSystem.openReadOnly(this.zipPath);
                boolean bl = false;
                fileMetadata = null;
                throwable = null;
                FileHandle fileHandle = (FileHandle)closeable;
                boolean bl2 = false;
                Closeable closeable2 = Okio.buffer(fileHandle.source(zipEntry2.getOffset()));
                boolean bl3 = false;
                fileMetadata2 = null;
                throwable2 = null;
                BufferedSource bufferedSource = (BufferedSource)closeable2;
                boolean bl4 = false;
                fileMetadata2 = ZipFilesKt.readLocalHeader(bufferedSource, fileMetadata3);
                try {
                    Closeable closeable3 = closeable2;
                    if (closeable3 != null) {
                        closeable3.close();
                    }
                    break block32;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                }
                break block32;
                catch (Throwable throwable4) {
                    try {
                        throwable2 = throwable4;
                    }
                    catch (Throwable throwable5) {
                        try {
                            Closeable closeable4 = closeable2;
                            if (closeable4 != null) {
                                closeable4.close();
                            }
                        }
                        catch (Throwable throwable6) {
                            throwable2 = throwable6;
                        }
                        throw throwable5;
                    }
                    try {
                        Closeable closeable5 = closeable2;
                        if (closeable5 != null) {
                            closeable5.close();
                        }
                    }
                    catch (Throwable throwable7) {
                        if (throwable2 == null) {
                            throwable2 = throwable7;
                            break block32;
                        }
                        ExceptionsKt.addSuppressed(throwable2, throwable7);
                    }
                }
            }
            Throwable throwable8 = throwable2;
            if (throwable8 != null) {
                throw throwable8;
            }
            FileMetadata fileMetadata4 = fileMetadata2;
            Intrinsics.checkNotNull(fileMetadata4);
            fileMetadata = fileMetadata4;
            try {
                Closeable closeable6 = closeable;
                if (closeable6 != null) {
                    closeable6.close();
                }
                break block33;
            }
            catch (Throwable throwable9) {
                throwable = throwable9;
            }
            break block33;
            catch (Throwable throwable10) {
                try {
                    throwable = throwable10;
                }
                catch (Throwable throwable11) {
                    try {
                        Closeable closeable7 = closeable;
                        if (closeable7 != null) {
                            closeable7.close();
                        }
                    }
                    catch (Throwable throwable12) {
                        throwable = throwable12;
                    }
                    throw throwable11;
                }
                try {
                    Closeable closeable8 = closeable;
                    if (closeable8 != null) {
                        closeable8.close();
                    }
                }
                catch (Throwable throwable13) {
                    if (throwable == null) {
                        throwable = throwable13;
                        break block33;
                    }
                    ExceptionsKt.addSuppressed(throwable, throwable13);
                }
            }
        }
        Throwable throwable14 = throwable;
        if (throwable14 != null) {
            throw throwable14;
        }
        FileMetadata fileMetadata5 = fileMetadata;
        Intrinsics.checkNotNull(fileMetadata5);
        return fileMetadata5;
    }

    @Override
    @NotNull
    public FileHandle openReadOnly(@NotNull Path path) {
        Intrinsics.checkNotNullParameter(path, "file");
        throw new UnsupportedOperationException("not implemented yet!");
    }

    @Override
    @NotNull
    public FileHandle openReadWrite(@NotNull Path path, boolean bl, boolean bl2) {
        Intrinsics.checkNotNullParameter(path, "file");
        throw new IOException("zip entries are not writable");
    }

    @Override
    @NotNull
    public List<Path> list(@NotNull Path path) {
        Intrinsics.checkNotNullParameter(path, "dir");
        List<Path> list = this.list(path, true);
        Intrinsics.checkNotNull(list);
        return list;
    }

    @Override
    @Nullable
    public List<Path> listOrNull(@NotNull Path path) {
        Intrinsics.checkNotNullParameter(path, "dir");
        return this.list(path, false);
    }

    private final List<Path> list(Path path, boolean bl) {
        Path path2 = this.canonicalizeInternal(path);
        ZipEntry zipEntry = this.entries.get(path2);
        if (zipEntry == null) {
            if (bl) {
                throw new IOException("not a directory: " + path);
            }
            return null;
        }
        ZipEntry zipEntry2 = zipEntry;
        return CollectionsKt.toList((Iterable)zipEntry2.getChildren());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public Source source(@NotNull Path path) {
        Source source2;
        Throwable throwable;
        BufferedSource bufferedSource;
        ZipEntry zipEntry;
        block18: {
            Intrinsics.checkNotNullParameter(path, "file");
            Path path2 = this.canonicalizeInternal(path);
            ZipEntry zipEntry2 = this.entries.get(path2);
            if (zipEntry2 == null) {
                throw new FileNotFoundException("no such file: " + path);
            }
            zipEntry = zipEntry2;
            Closeable closeable = this.fileSystem.openReadOnly(this.zipPath);
            boolean bl = false;
            bufferedSource = null;
            throwable = null;
            FileHandle fileHandle = (FileHandle)closeable;
            boolean bl2 = false;
            bufferedSource = Okio.buffer(fileHandle.source(zipEntry.getOffset()));
            try {
                Closeable closeable2 = closeable;
                if (closeable2 != null) {
                    closeable2.close();
                }
                break block18;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
            }
            break block18;
            catch (Throwable throwable3) {
                try {
                    throwable = throwable3;
                }
                catch (Throwable throwable4) {
                    try {
                        Closeable closeable3 = closeable;
                        if (closeable3 != null) {
                            closeable3.close();
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                    }
                    throw throwable4;
                }
                try {
                    Closeable closeable4 = closeable;
                    if (closeable4 != null) {
                        closeable4.close();
                    }
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                        break block18;
                    }
                    ExceptionsKt.addSuppressed(throwable, throwable6);
                }
            }
        }
        Throwable throwable7 = throwable;
        if (throwable7 != null) {
            throw throwable7;
        }
        BufferedSource bufferedSource2 = bufferedSource;
        Intrinsics.checkNotNull(bufferedSource2);
        BufferedSource bufferedSource3 = bufferedSource2;
        ZipFilesKt.skipLocalHeader(bufferedSource3);
        if (zipEntry.getCompressionMethod() == 0) {
            source2 = new FixedLengthSource(bufferedSource3, zipEntry.getSize(), true);
        } else {
            InflaterSource inflaterSource = new InflaterSource(new FixedLengthSource(bufferedSource3, zipEntry.getCompressedSize(), true), new Inflater(true));
            source2 = new FixedLengthSource(inflaterSource, zipEntry.getSize(), false);
        }
        return source2;
    }

    @Override
    @NotNull
    public Sink sink(@NotNull Path path, boolean bl) {
        Intrinsics.checkNotNullParameter(path, "file");
        throw new IOException("zip file systems are read-only");
    }

    @Override
    @NotNull
    public Sink appendingSink(@NotNull Path path, boolean bl) {
        Intrinsics.checkNotNullParameter(path, "file");
        throw new IOException("zip file systems are read-only");
    }

    @Override
    public void createDirectory(@NotNull Path path, boolean bl) {
        Intrinsics.checkNotNullParameter(path, "dir");
        throw new IOException("zip file systems are read-only");
    }

    @Override
    public void atomicMove(@NotNull Path path, @NotNull Path path2) {
        Intrinsics.checkNotNullParameter(path, "source");
        Intrinsics.checkNotNullParameter(path2, "target");
        throw new IOException("zip file systems are read-only");
    }

    @Override
    public void delete(@NotNull Path path, boolean bl) {
        Intrinsics.checkNotNullParameter(path, "path");
        throw new IOException("zip file systems are read-only");
    }

    @Override
    public void createSymlink(@NotNull Path path, @NotNull Path path2) {
        Intrinsics.checkNotNullParameter(path, "source");
        Intrinsics.checkNotNullParameter(path2, "target");
        throw new IOException("zip file systems are read-only");
    }

    public static final /* synthetic */ Path access$getROOT$cp() {
        return ROOT;
    }
}

