/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.security.InvalidKeyException;
import java.security.MessageDigest;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.-SegmentedByteString;
import okio.Buffer;
import okio.ByteString;
import okio.ForwardingSink;
import okio.HashingSink$Companion;
import okio.Segment;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u00012\u00020\u0002:\u0001\u001aB\u0017\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u0017\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB\u001f\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000fJ\r\u0010\u0010\u001a\u00020\u000eH\u0007\u00a2\u0006\u0002\b\u0013J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0011\u0010\u0010\u001a\u00020\u000e8G\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lokio/HashingSink;", "Lokio/ForwardingSink;", "Lokio/Sink;", "sink", "digest", "Ljava/security/MessageDigest;", "(Lokio/Sink;Ljava/security/MessageDigest;)V", "algorithm", "", "(Lokio/Sink;Ljava/lang/String;)V", "mac", "Ljavax/crypto/Mac;", "(Lokio/Sink;Ljavax/crypto/Mac;)V", "key", "Lokio/ByteString;", "(Lokio/Sink;Lokio/ByteString;Ljava/lang/String;)V", "hash", "()Lokio/ByteString;", "messageDigest", "-deprecated_hash", "write", "", "source", "Lokio/Buffer;", "byteCount", "", "Companion", "okio"})
@SourceDebugExtension(value={"SMAP\nHashingSink.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HashingSink.kt\nokio/HashingSink\n+ 2 Util.kt\nokio/-SegmentedByteString\n*L\n1#1,148:1\n86#2:149\n*S KotlinDebug\n*F\n+ 1 HashingSink.kt\nokio/HashingSink\n*L\n75#1:149\n*E\n"})
public final class HashingSink
extends ForwardingSink
implements Sink {
    @NotNull
    public static final HashingSink$Companion Companion = new HashingSink$Companion(null);
    @Nullable
    private final MessageDigest messageDigest;
    @Nullable
    private final Mac mac;

    public HashingSink(@NotNull Sink sink2, @NotNull MessageDigest messageDigest) {
        Intrinsics.checkNotNullParameter(sink2, "sink");
        Intrinsics.checkNotNullParameter(messageDigest, "digest");
        super(sink2);
        this.messageDigest = messageDigest;
        this.mac = null;
    }

    public HashingSink(@NotNull Sink sink2, @NotNull String string) {
        Intrinsics.checkNotNullParameter(sink2, "sink");
        Intrinsics.checkNotNullParameter(string, "algorithm");
        MessageDigest messageDigest = MessageDigest.getInstance(string);
        Intrinsics.checkNotNullExpressionValue(messageDigest, "getInstance(...)");
        this(sink2, messageDigest);
    }

    public HashingSink(@NotNull Sink sink2, @NotNull Mac mac) {
        Intrinsics.checkNotNullParameter(sink2, "sink");
        Intrinsics.checkNotNullParameter(mac, "mac");
        super(sink2);
        this.mac = mac;
        this.messageDigest = null;
    }

    public HashingSink(@NotNull Sink sink2, @NotNull ByteString byteString, @NotNull String string) {
        Sink sink3;
        HashingSink hashingSink;
        Mac mac;
        Intrinsics.checkNotNullParameter(sink2, "sink");
        Intrinsics.checkNotNullParameter(byteString, "key");
        Intrinsics.checkNotNullParameter(string, "algorithm");
        Sink sink4 = sink2;
        HashingSink hashingSink2 = this;
        try {
            Mac mac2 = mac = Mac.getInstance(string);
            Sink sink5 = sink4;
            HashingSink hashingSink3 = hashingSink2;
            boolean bl = false;
            mac2.init(new SecretKeySpec(byteString.toByteArray(), string));
            Unit unit = Unit.INSTANCE;
            hashingSink = hashingSink3;
            sink3 = sink5;
        }
        catch (InvalidKeyException invalidKeyException) {
            HashingSink hashingSink4 = hashingSink2;
            Sink sink6 = sink4;
            throw new IllegalArgumentException(invalidKeyException);
        }
        Mac mac3 = mac;
        Intrinsics.checkNotNull(mac3);
        hashingSink(sink3, mac3);
    }

    @Override
    public void write(@NotNull Buffer buffer, long l) {
        int n;
        Intrinsics.checkNotNullParameter(buffer, "source");
        -SegmentedByteString.checkOffsetAndCount(buffer.size(), 0L, l);
        Segment segment = buffer.head;
        Intrinsics.checkNotNull(segment);
        Segment segment2 = segment;
        for (long i = 0L; i < l; i += (long)n) {
            long l2 = l - i;
            int n2 = segment2.limit - segment2.pos;
            boolean bl = false;
            n = (int)Math.min(l2, (long)n2);
            if (this.messageDigest != null) {
                this.messageDigest.update(segment2.data, segment2.pos, n);
            } else {
                Mac mac = this.mac;
                Intrinsics.checkNotNull(mac);
                mac.update(segment2.data, segment2.pos, n);
            }
            Intrinsics.checkNotNull(segment2.next);
        }
        super.write(buffer, l);
    }

    @JvmName(name="hash")
    @NotNull
    public final ByteString hash() {
        byte[] byArray;
        if (this.messageDigest != null) {
            byArray = this.messageDigest.digest();
        } else {
            Mac mac = this.mac;
            Intrinsics.checkNotNull(mac);
            byArray = mac.doFinal();
        }
        byte[] byArray2 = byArray;
        Intrinsics.checkNotNull(byArray2);
        return new ByteString(byArray2);
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="hash", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_hash")
    @NotNull
    public final ByteString -deprecated_hash() {
        return this.hash();
    }

    @JvmStatic
    @NotNull
    public static final HashingSink md5(@NotNull Sink sink2) {
        return Companion.md5(sink2);
    }

    @JvmStatic
    @NotNull
    public static final HashingSink sha1(@NotNull Sink sink2) {
        return Companion.sha1(sink2);
    }

    @JvmStatic
    @NotNull
    public static final HashingSink sha256(@NotNull Sink sink2) {
        return Companion.sha256(sink2);
    }

    @JvmStatic
    @NotNull
    public static final HashingSink sha512(@NotNull Sink sink2) {
        return Companion.sha512(sink2);
    }

    @JvmStatic
    @NotNull
    public static final HashingSink hmacSha1(@NotNull Sink sink2, @NotNull ByteString byteString) {
        return Companion.hmacSha1(sink2, byteString);
    }

    @JvmStatic
    @NotNull
    public static final HashingSink hmacSha256(@NotNull Sink sink2, @NotNull ByteString byteString) {
        return Companion.hmacSha256(sink2, byteString);
    }

    @JvmStatic
    @NotNull
    public static final HashingSink hmacSha512(@NotNull Sink sink2, @NotNull ByteString byteString) {
        return Companion.hmacSha512(sink2, byteString);
    }
}

