/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okio.-Base64;
import okio.-SegmentedByteString;
import okio.Buffer;
import okio.ByteString$Companion;
import okio._JvmPlatformKt;
import okio.internal.-ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 ]2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001]B\u000f\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0010H\u0016J\b\u0010\u0018\u001a\u00020\u0010H\u0016J\u0011\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u0000H\u0096\u0002J,\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u00042\b\b\u0002\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\tH\u0016J\u0015\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0010H\u0010\u00a2\u0006\u0002\b#J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0004J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0000J\u0013\u0010'\u001a\u00020%2\b\u0010\u001a\u001a\u0004\u0018\u00010(H\u0096\u0002J\u0016\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\tH\u0087\u0002\u00a2\u0006\u0002\b,J\u0015\u0010,\u001a\u00020*2\u0006\u0010+\u001a\u00020\tH\u0007\u00a2\u0006\u0002\b-J\r\u0010.\u001a\u00020\tH\u0010\u00a2\u0006\u0002\b/J\b\u0010\b\u001a\u00020\tH\u0016J\b\u00100\u001a\u00020\u0010H\u0016J\u001d\u00101\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u00102\u0006\u00102\u001a\u00020\u0000H\u0010\u00a2\u0006\u0002\b3J\u0010\u00104\u001a\u00020\u00002\u0006\u00102\u001a\u00020\u0000H\u0016J\u0010\u00105\u001a\u00020\u00002\u0006\u00102\u001a\u00020\u0000H\u0016J\u0010\u00106\u001a\u00020\u00002\u0006\u00102\u001a\u00020\u0000H\u0016J\u001a\u00107\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00042\b\b\u0002\u00108\u001a\u00020\tH\u0017J\u001a\u00107\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u00108\u001a\u00020\tH\u0007J\r\u00109\u001a\u00020\u0004H\u0010\u00a2\u0006\u0002\b:J\u0015\u0010;\u001a\u00020*2\u0006\u0010<\u001a\u00020\tH\u0010\u00a2\u0006\u0002\b=J\u001a\u0010>\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00042\b\b\u0002\u00108\u001a\u00020\tH\u0017J\u001a\u0010>\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u00108\u001a\u00020\tH\u0007J\u0006\u0010?\u001a\u00020\u0000J(\u0010@\u001a\u00020%2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010A\u001a\u00020\t2\u0006\u0010 \u001a\u00020\tH\u0016J(\u0010@\u001a\u00020%2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00002\u0006\u0010A\u001a\u00020\t2\u0006\u0010 \u001a\u00020\tH\u0016J\u0010\u0010B\u001a\u00020\u001c2\u0006\u0010C\u001a\u00020DH\u0002J\u0006\u0010E\u001a\u00020\u0000J\u0006\u0010F\u001a\u00020\u0000J\u0006\u0010G\u001a\u00020\u0000J\r\u0010\u000e\u001a\u00020\tH\u0007\u00a2\u0006\u0002\bHJ\u000e\u0010I\u001a\u00020%2\u0006\u0010J\u001a\u00020\u0004J\u000e\u0010I\u001a\u00020%2\u0006\u0010J\u001a\u00020\u0000J\u0010\u0010K\u001a\u00020\u00102\u0006\u0010L\u001a\u00020MH\u0016J\u001c\u0010N\u001a\u00020\u00002\b\b\u0002\u0010O\u001a\u00020\t2\b\b\u0002\u0010P\u001a\u00020\tH\u0017J\b\u0010Q\u001a\u00020\u0000H\u0016J\b\u0010R\u001a\u00020\u0000H\u0016J\b\u0010S\u001a\u00020\u0004H\u0016J\b\u0010T\u001a\u00020\u0010H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010U\u001a\u00020\u001c2\u0006\u0010V\u001a\u00020WH\u0016J%\u0010U\u001a\u00020\u001c2\u0006\u0010X\u001a\u00020Y2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010 \u001a\u00020\tH\u0010\u00a2\u0006\u0002\bZJ\u0010\u0010[\u001a\u00020\u001c2\u0006\u0010V\u001a\u00020\\H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\t8G\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000bR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006^"}, d2={"Lokio/ByteString;", "Ljava/io/Serializable;", "", "data", "", "([B)V", "getData$okio", "()[B", "hashCode", "", "getHashCode$okio", "()I", "setHashCode$okio", "(I)V", "size", "utf8", "", "getUtf8$okio", "()Ljava/lang/String;", "setUtf8$okio", "(Ljava/lang/String;)V", "asByteBuffer", "Ljava/nio/ByteBuffer;", "base64", "base64Url", "compareTo", "other", "copyInto", "", "offset", "target", "targetOffset", "byteCount", "digest", "algorithm", "digest$okio", "endsWith", "", "suffix", "equals", "", "get", "", "index", "getByte", "-deprecated_getByte", "getSize", "getSize$okio", "hex", "hmac", "key", "hmac$okio", "hmacSha1", "hmacSha256", "hmacSha512", "indexOf", "fromIndex", "internalArray", "internalArray$okio", "internalGet", "pos", "internalGet$okio", "lastIndexOf", "md5", "rangeEquals", "otherOffset", "readObject", "in", "Ljava/io/ObjectInputStream;", "sha1", "sha256", "sha512", "-deprecated_size", "startsWith", "prefix", "string", "charset", "Ljava/nio/charset/Charset;", "substring", "beginIndex", "endIndex", "toAsciiLowercase", "toAsciiUppercase", "toByteArray", "toString", "write", "out", "Ljava/io/OutputStream;", "buffer", "Lokio/Buffer;", "write$okio", "writeObject", "Ljava/io/ObjectOutputStream;", "Companion", "okio"})
@SourceDebugExtension(value={"SMAP\nByteString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ByteString.kt\nokio/ByteString\n+ 2 ByteString.kt\nokio/internal/-ByteString\n+ 3 Util.kt\nokio/-SegmentedByteString\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,364:1\n43#2,7:365\n53#2:372\n56#2:373\n64#2,4:374\n68#2:379\n70#2:381\n76#2,23:382\n104#2,23:405\n131#2,2:428\n133#2,9:431\n145#2:440\n148#2:441\n151#2:442\n154#2:443\n162#2:444\n172#2,3:445\n171#2:448\n185#2,2:449\n190#2:451\n194#2:452\n198#2:453\n202#2:454\n206#2,7:455\n219#2:462\n223#2,8:463\n235#2,4:471\n244#2,5:475\n253#2,6:480\n259#2,9:487\n322#2,8:496\n131#2,2:504\n133#2,9:507\n333#2,9:516\n68#3:378\n74#3:380\n74#3:486\n1#4:430\n1#4:506\n*S KotlinDebug\n*F\n+ 1 ByteString.kt\nokio/ByteString\n*L\n66#1:365,7\n71#1:372\n108#1:373\n110#1:374,4\n110#1:379\n110#1:381\n112#1:382,23\n114#1:405,23\n118#1:428,2\n118#1:431,9\n120#1:440\n129#1:441\n131#1:442\n133#1:443\n152#1:444\n159#1:445,3\n159#1:448\n166#1:449,2\n168#1:451\n170#1:452\n172#1:453\n174#1:454\n180#1:455,7\n183#1:462\n186#1:463,8\n188#1:471,4\n190#1:475,5\n192#1:480,6\n192#1:487,9\n194#1:496,8\n194#1:504,2\n194#1:507,9\n194#1:516,9\n110#1:378\n110#1:380\n192#1:486\n118#1:430\n194#1:506\n*E\n"})
public class ByteString
implements Serializable,
Comparable<ByteString> {
    @NotNull
    public static final ByteString$Companion Companion = new ByteString$Companion(null);
    @NotNull
    private final byte[] data;
    private transient int hashCode;
    @Nullable
    private transient String utf8;
    private static final long serialVersionUID = 1L;
    @JvmField
    @NotNull
    public static final ByteString EMPTY = new ByteString(new byte[0]);

    public ByteString(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter(byArray, "data");
        this.data = byArray;
    }

    @NotNull
    public final byte[] getData$okio() {
        return this.data;
    }

    public final int getHashCode$okio() {
        return this.hashCode;
    }

    public final void setHashCode$okio(int n) {
        this.hashCode = n;
    }

    @Nullable
    public final String getUtf8$okio() {
        return this.utf8;
    }

    public final void setUtf8$okio(@Nullable String string) {
        this.utf8 = string;
    }

    @NotNull
    public String utf8() {
        ByteString byteString = this;
        boolean bl = false;
        String string = byteString.getUtf8$okio();
        if (string == null) {
            string = _JvmPlatformKt.toUtf8String(byteString.internalArray$okio());
            byteString.setUtf8$okio(string);
        }
        return string;
    }

    @NotNull
    public String string(@NotNull Charset charset) {
        Intrinsics.checkNotNullParameter(charset, "charset");
        return new String(this.data, charset);
    }

    @NotNull
    public String base64() {
        ByteString byteString = this;
        boolean bl = false;
        return -Base64.encodeBase64$default(byteString.getData$okio(), null, 1, null);
    }

    @NotNull
    public final ByteString md5() {
        return this.digest$okio("MD5");
    }

    @NotNull
    public final ByteString sha1() {
        return this.digest$okio("SHA-1");
    }

    @NotNull
    public final ByteString sha256() {
        return this.digest$okio("SHA-256");
    }

    @NotNull
    public final ByteString sha512() {
        return this.digest$okio("SHA-512");
    }

    @NotNull
    public ByteString digest$okio(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "algorithm");
        MessageDigest messageDigest = MessageDigest.getInstance(string);
        boolean bl = false;
        messageDigest.update(this.data, 0, this.size());
        byte[] byArray = messageDigest.digest();
        Intrinsics.checkNotNull(byArray);
        return new ByteString(byArray);
    }

    @NotNull
    public ByteString hmacSha1(@NotNull ByteString byteString) {
        Intrinsics.checkNotNullParameter(byteString, "key");
        return this.hmac$okio("HmacSHA1", byteString);
    }

    @NotNull
    public ByteString hmacSha256(@NotNull ByteString byteString) {
        Intrinsics.checkNotNullParameter(byteString, "key");
        return this.hmac$okio("HmacSHA256", byteString);
    }

    @NotNull
    public ByteString hmacSha512(@NotNull ByteString byteString) {
        Intrinsics.checkNotNullParameter(byteString, "key");
        return this.hmac$okio("HmacSHA512", byteString);
    }

    @NotNull
    public ByteString hmac$okio(@NotNull String string, @NotNull ByteString byteString) {
        Intrinsics.checkNotNullParameter(string, "algorithm");
        Intrinsics.checkNotNullParameter(byteString, "key");
        try {
            Mac mac = Mac.getInstance(string);
            mac.init(new SecretKeySpec(byteString.toByteArray(), string));
            byte[] byArray = mac.doFinal(this.data);
            Intrinsics.checkNotNullExpressionValue(byArray, "doFinal(...)");
            return new ByteString(byArray);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalArgumentException(invalidKeyException);
        }
    }

    @NotNull
    public String base64Url() {
        ByteString byteString = this;
        boolean bl = false;
        return -Base64.encodeBase64(byteString.getData$okio(), -Base64.getBASE64_URL_SAFE());
    }

    @NotNull
    public String hex() {
        ByteString byteString = this;
        boolean bl = false;
        char[] cArray = new char[byteString.getData$okio().length * 2];
        int n = 0;
        for (byte by : byteString.getData$okio()) {
            int n2 = n++;
            byte by2 = by;
            int n3 = 4;
            boolean bl2 = false;
            cArray[n2] = -ByteString.getHEX_DIGIT_CHARS()[by2 >> n3 & 0xF];
            int n4 = n++;
            by2 = by;
            n3 = 15;
            bl2 = false;
            cArray[n4] = -ByteString.getHEX_DIGIT_CHARS()[by2 & n3];
        }
        return StringsKt.concatToString(cArray);
    }

    @NotNull
    public ByteString toAsciiLowercase() {
        ByteString byteString;
        block4: {
            ByteString byteString2 = this;
            boolean bl = false;
            for (int i = 0; i < byteString2.getData$okio().length; ++i) {
                byte by = byteString2.getData$okio()[i];
                if (by < 65 || by > 90) {
                    continue;
                }
                byte[] byArray = byteString2.getData$okio();
                byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
                Intrinsics.checkNotNullExpressionValue(byArray2, "copyOf(this, size)");
                byte[] byArray3 = byArray2;
                byArray3[i++] = (byte)(by - -32);
                while (i < byArray3.length) {
                    by = byArray3[i];
                    if (by < 65 || by > 90) {
                        ++i;
                        continue;
                    }
                    byArray3[i] = (byte)(by - -32);
                    ++i;
                }
                byteString = new ByteString(byArray3);
                break block4;
            }
            byteString = byteString2;
        }
        return byteString;
    }

    @NotNull
    public ByteString toAsciiUppercase() {
        ByteString byteString;
        block4: {
            ByteString byteString2 = this;
            boolean bl = false;
            for (int i = 0; i < byteString2.getData$okio().length; ++i) {
                byte by = byteString2.getData$okio()[i];
                if (by < 97 || by > 122) {
                    continue;
                }
                byte[] byArray = byteString2.getData$okio();
                byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
                Intrinsics.checkNotNullExpressionValue(byArray2, "copyOf(this, size)");
                byte[] byArray3 = byArray2;
                byArray3[i++] = (byte)(by - 32);
                while (i < byArray3.length) {
                    by = byArray3[i];
                    if (by < 97 || by > 122) {
                        ++i;
                        continue;
                    }
                    byArray3[i] = (byte)(by - 32);
                    ++i;
                }
                byteString = new ByteString(byArray3);
                break block4;
            }
            byteString = byteString2;
        }
        return byteString;
    }

    @JvmOverloads
    @NotNull
    public ByteString substring(int n, int n2) {
        ByteString byteString;
        ByteString byteString2 = this;
        boolean bl = false;
        int n3 = -SegmentedByteString.resolveDefaultParameter(byteString2, n2);
        if (!(n >= 0)) {
            boolean bl2 = false;
            String string = "beginIndex < 0";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(n3 <= byteString2.getData$okio().length)) {
            boolean bl3 = false;
            String string = "endIndex > length(" + byteString2.getData$okio().length + ')';
            throw new IllegalArgumentException(string.toString());
        }
        int n4 = n3 - n;
        if (!(n4 >= 0)) {
            boolean bl4 = false;
            String string = "endIndex < beginIndex";
            throw new IllegalArgumentException(string.toString());
        }
        if (n == 0 && n3 == byteString2.getData$okio().length) {
            byteString = byteString2;
        } else {
            byte[] byArray = byteString2.getData$okio();
            ByteString byteString3 = new ByteString(ArraysKt.copyOfRange(byArray, n, n3));
            byteString = byteString3;
        }
        return byteString;
    }

    public static /* synthetic */ ByteString substring$default(ByteString byteString, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: substring");
        }
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = -SegmentedByteString.getDEFAULT__ByteString_size();
        }
        return byteString.substring(n, n2);
    }

    public byte internalGet$okio(int n) {
        ByteString byteString = this;
        boolean bl = false;
        return byteString.getData$okio()[n];
    }

    @JvmName(name="getByte")
    public final byte getByte(int n) {
        return this.internalGet$okio(n);
    }

    @JvmName(name="size")
    public final int size() {
        return this.getSize$okio();
    }

    public int getSize$okio() {
        ByteString byteString = this;
        boolean bl = false;
        return byteString.getData$okio().length;
    }

    @NotNull
    public byte[] toByteArray() {
        ByteString byteString = this;
        boolean bl = false;
        byte[] byArray = byteString.getData$okio();
        byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
        Intrinsics.checkNotNullExpressionValue(byArray2, "copyOf(this, size)");
        return byArray2;
    }

    @NotNull
    public byte[] internalArray$okio() {
        ByteString byteString = this;
        boolean bl = false;
        return byteString.getData$okio();
    }

    @NotNull
    public ByteBuffer asByteBuffer() {
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.data).asReadOnlyBuffer();
        Intrinsics.checkNotNullExpressionValue(byteBuffer, "asReadOnlyBuffer(...)");
        return byteBuffer;
    }

    public void write(@NotNull OutputStream outputStream2) {
        Intrinsics.checkNotNullParameter(outputStream2, "out");
        outputStream2.write(this.data);
    }

    public void write$okio(@NotNull Buffer buffer, int n, int n2) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        -ByteString.commonWrite(this, buffer, n, n2);
    }

    public boolean rangeEquals(int n, @NotNull ByteString byteString, int n2, int n3) {
        Intrinsics.checkNotNullParameter(byteString, "other");
        ByteString byteString2 = this;
        boolean bl = false;
        return byteString.rangeEquals(n2, byteString2.getData$okio(), n, n3);
    }

    public boolean rangeEquals(int n, @NotNull byte[] byArray, int n2, int n3) {
        Intrinsics.checkNotNullParameter(byArray, "other");
        ByteString byteString = this;
        boolean bl = false;
        return n >= 0 && n <= byteString.getData$okio().length - n3 && n2 >= 0 && n2 <= byArray.length - n3 && -SegmentedByteString.arrayRangeEquals(byteString.getData$okio(), n, byArray, n2, n3);
    }

    public void copyInto(int n, @NotNull byte[] byArray, int n2, int n3) {
        Intrinsics.checkNotNullParameter(byArray, "target");
        ByteString byteString = this;
        boolean bl = false;
        ArraysKt.copyInto(byteString.getData$okio(), byArray, n2, n, n + n3);
    }

    public static /* synthetic */ void copyInto$default(ByteString byteString, int n, byte[] byArray, int n2, int n3, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copyInto");
        }
        if ((n4 & 1) != 0) {
            n = 0;
        }
        if ((n4 & 4) != 0) {
            n2 = 0;
        }
        byteString.copyInto(n, byArray, n2, n3);
    }

    public final boolean startsWith(@NotNull ByteString byteString) {
        Intrinsics.checkNotNullParameter(byteString, "prefix");
        ByteString byteString2 = this;
        boolean bl = false;
        return byteString2.rangeEquals(0, byteString, 0, byteString.size());
    }

    public final boolean startsWith(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter(byArray, "prefix");
        ByteString byteString = this;
        boolean bl = false;
        return byteString.rangeEquals(0, byArray, 0, byArray.length);
    }

    public final boolean endsWith(@NotNull ByteString byteString) {
        Intrinsics.checkNotNullParameter(byteString, "suffix");
        ByteString byteString2 = this;
        boolean bl = false;
        return byteString2.rangeEquals(byteString2.size() - byteString.size(), byteString, 0, byteString.size());
    }

    public final boolean endsWith(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter(byArray, "suffix");
        ByteString byteString = this;
        boolean bl = false;
        return byteString.rangeEquals(byteString.size() - byArray.length, byArray, 0, byArray.length);
    }

    @JvmOverloads
    public final int indexOf(@NotNull ByteString byteString, int n) {
        Intrinsics.checkNotNullParameter(byteString, "other");
        return this.indexOf(byteString.internalArray$okio(), n);
    }

    public static /* synthetic */ int indexOf$default(ByteString byteString, ByteString byteString2, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: indexOf");
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return byteString.indexOf(byteString2, n);
    }

    @JvmOverloads
    public int indexOf(@NotNull byte[] byArray, int n) {
        int n2;
        block3: {
            Intrinsics.checkNotNullParameter(byArray, "other");
            ByteString byteString = this;
            boolean bl = false;
            int n3 = byteString.getData$okio().length - byArray.length;
            int n4 = Math.max(n, 0);
            if (n4 <= n3) {
                while (true) {
                    if (-SegmentedByteString.arrayRangeEquals(byteString.getData$okio(), n4, byArray, 0, byArray.length)) {
                        n2 = n4;
                        break block3;
                    }
                    if (n4 == n3) break;
                    ++n4;
                }
            }
            n2 = -1;
        }
        return n2;
    }

    public static /* synthetic */ int indexOf$default(ByteString byteString, byte[] byArray, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: indexOf");
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return byteString.indexOf(byArray, n);
    }

    @JvmOverloads
    public final int lastIndexOf(@NotNull ByteString byteString, int n) {
        Intrinsics.checkNotNullParameter(byteString, "other");
        ByteString byteString2 = this;
        boolean bl = false;
        return byteString2.lastIndexOf(byteString.internalArray$okio(), n);
    }

    public static /* synthetic */ int lastIndexOf$default(ByteString byteString, ByteString byteString2, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: lastIndexOf");
        }
        if ((n2 & 2) != 0) {
            n = -SegmentedByteString.getDEFAULT__ByteString_size();
        }
        return byteString.lastIndexOf(byteString2, n);
    }

    @JvmOverloads
    public int lastIndexOf(@NotNull byte[] byArray, int n) {
        int n2;
        block1: {
            Intrinsics.checkNotNullParameter(byArray, "other");
            ByteString byteString = this;
            boolean bl = false;
            int n3 = -SegmentedByteString.resolveDefaultParameter(byteString, n);
            int n4 = byteString.getData$okio().length - byArray.length;
            for (int i = Math.min(n3, n4); -1 < i; --i) {
                if (!-SegmentedByteString.arrayRangeEquals(byteString.getData$okio(), i, byArray, 0, byArray.length)) continue;
                n2 = i;
                break block1;
            }
            n2 = -1;
        }
        return n2;
    }

    public static /* synthetic */ int lastIndexOf$default(ByteString byteString, byte[] byArray, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: lastIndexOf");
        }
        if ((n2 & 2) != 0) {
            n = -SegmentedByteString.getDEFAULT__ByteString_size();
        }
        return byteString.lastIndexOf(byArray, n);
    }

    public boolean equals(@Nullable Object object) {
        ByteString byteString = this;
        boolean bl = false;
        return object == byteString ? true : (object instanceof ByteString ? ((ByteString)object).size() == byteString.getData$okio().length && ((ByteString)object).rangeEquals(0, byteString.getData$okio(), 0, byteString.getData$okio().length) : false);
    }

    public int hashCode() {
        int n;
        ByteString byteString = this;
        boolean bl = false;
        int n2 = byteString.getHashCode$okio();
        if (n2 != 0) {
            n = n2;
        } else {
            int n3;
            int n4 = n3 = Arrays.hashCode(byteString.getData$okio());
            boolean bl2 = false;
            byteString.setHashCode$okio(n4);
            n = n3;
        }
        return n;
    }

    @Override
    public int compareTo(@NotNull ByteString byteString) {
        int n;
        block2: {
            Intrinsics.checkNotNullParameter(byteString, "other");
            ByteString byteString2 = this;
            boolean bl = false;
            int n2 = byteString2.size();
            int n3 = byteString.size();
            int n4 = Math.min(n2, n3);
            for (int i = 0; i < n4; ++i) {
                int n5 = byteString2.getByte(i);
                int n6 = 255;
                int n7 = 0;
                int n8 = n5 & n6;
                n6 = byteString.getByte(i);
                n7 = 255;
                boolean bl2 = false;
                n5 = n6 & n7;
                if (n8 == n5) {
                    continue;
                }
                n = n8 < n5 ? -1 : 1;
                break block2;
            }
            n = n2 == n3 ? 0 : (n2 < n3 ? -1 : 1);
        }
        return n;
    }

    @NotNull
    public String toString() {
        String string;
        ByteString byteString = this;
        boolean bl = false;
        if (byteString.getData$okio().length == 0) {
            string = "[size=0]";
        } else {
            int n = -ByteString.access$codePointIndexToCharIndex(byteString.getData$okio(), 64);
            if (n == -1) {
                if (byteString.getData$okio().length <= 64) {
                    string = "[hex=" + byteString.hex() + ']';
                } else {
                    ByteString byteString2;
                    StringBuilder stringBuilder = new StringBuilder().append("[size=").append(byteString.getData$okio().length).append(" hex=");
                    ByteString byteString3 = byteString;
                    int n2 = 0;
                    int n3 = 64;
                    boolean bl2 = false;
                    int n4 = -SegmentedByteString.resolveDefaultParameter(byteString3, n3);
                    if (!(n4 <= byteString3.getData$okio().length)) {
                        boolean bl3 = false;
                        String string2 = "endIndex > length(" + byteString3.getData$okio().length + ')';
                        throw new IllegalArgumentException(string2.toString());
                    }
                    int n5 = n4 - n2;
                    if (!(n5 >= 0)) {
                        boolean bl4 = false;
                        String string3 = "endIndex < beginIndex";
                        throw new IllegalArgumentException(string3.toString());
                    }
                    if (n4 == byteString3.getData$okio().length) {
                        byteString2 = byteString3;
                    } else {
                        byte[] byArray = byteString3.getData$okio();
                        ByteString byteString4 = new ByteString(ArraysKt.copyOfRange(byArray, n2, n4));
                        byteString2 = byteString4;
                    }
                    string = stringBuilder.append(byteString2.hex()).append("\u2026]").toString();
                }
            } else {
                String string4 = byteString.utf8();
                String string5 = string4.substring(0, n);
                Intrinsics.checkNotNullExpressionValue(string5, "this as java.lang.String\u2026ing(startIndex, endIndex)");
                String string6 = StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(string5, "\\", "\\\\", false, 4, null), "\n", "\\n", false, 4, null), "\r", "\\r", false, 4, null);
                string = n < string4.length() ? "[size=" + byteString.getData$okio().length + " text=" + string6 + "\u2026]" : "[text=" + string6 + ']';
            }
        }
        return string;
    }

    private final void readObject(ObjectInputStream objectInputStream) {
        int n = objectInputStream.readInt();
        ByteString byteString = Companion.read(objectInputStream, n);
        Field field = ByteString.class.getDeclaredField("data");
        field.setAccessible(true);
        field.set(this, byteString.data);
    }

    private final void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.writeInt(this.data.length);
        objectOutputStream.write(this.data);
    }

    @Deprecated(message="moved to operator function", replaceWith=@ReplaceWith(expression="this[index]", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_getByte")
    public final byte -deprecated_getByte(int n) {
        return this.getByte(n);
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="size", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_size")
    public final int -deprecated_size() {
        return this.size();
    }

    @JvmOverloads
    @NotNull
    public final ByteString substring(int n) {
        return ByteString.substring$default(this, n, 0, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final ByteString substring() {
        return ByteString.substring$default(this, 0, 0, 3, null);
    }

    @JvmOverloads
    public final int indexOf(@NotNull ByteString byteString) {
        Intrinsics.checkNotNullParameter(byteString, "other");
        return ByteString.indexOf$default(this, byteString, 0, 2, null);
    }

    @JvmOverloads
    public final int indexOf(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter(byArray, "other");
        return ByteString.indexOf$default(this, byArray, 0, 2, null);
    }

    @JvmOverloads
    public final int lastIndexOf(@NotNull ByteString byteString) {
        Intrinsics.checkNotNullParameter(byteString, "other");
        return ByteString.lastIndexOf$default(this, byteString, 0, 2, null);
    }

    @JvmOverloads
    public final int lastIndexOf(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter(byArray, "other");
        return ByteString.lastIndexOf$default(this, byArray, 0, 2, null);
    }

    @JvmStatic
    @NotNull
    public static final ByteString of(byte ... byArray) {
        return Companion.of(byArray);
    }

    @JvmStatic
    @JvmName(name="of")
    @NotNull
    public static final ByteString of(@NotNull byte[] byArray, int n, int n2) {
        return Companion.of(byArray, n, n2);
    }

    @JvmStatic
    @JvmName(name="of")
    @NotNull
    public static final ByteString of(@NotNull ByteBuffer byteBuffer) {
        return Companion.of(byteBuffer);
    }

    @JvmStatic
    @NotNull
    public static final ByteString encodeUtf8(@NotNull String string) {
        return Companion.encodeUtf8(string);
    }

    @JvmStatic
    @JvmName(name="encodeString")
    @NotNull
    public static final ByteString encodeString(@NotNull String string, @NotNull Charset charset) {
        return Companion.encodeString(string, charset);
    }

    @JvmStatic
    @Nullable
    public static final ByteString decodeBase64(@NotNull String string) {
        return Companion.decodeBase64(string);
    }

    @JvmStatic
    @NotNull
    public static final ByteString decodeHex(@NotNull String string) {
        return Companion.decodeHex(string);
    }

    @JvmStatic
    @JvmName(name="read")
    @NotNull
    public static final ByteString read(@NotNull InputStream inputStream2, int n) {
        return Companion.read(inputStream2, n);
    }
}

