/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.ws;

import java.io.Closeable;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.internal.Util;
import okhttp3.internal.ws.MessageInflater;
import okhttp3.internal.ws.WebSocketProtocol;
import okhttp3.internal.ws.WebSocketReader$FrameCallback;
import okio.Buffer;
import okio.Buffer$UnsafeCursor;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0001&B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0006\u0010 \u001a\u00020\u001fJ\b\u0010!\u001a\u00020\u001fH\u0002J\b\u0010\"\u001a\u00020\u001fH\u0002J\b\u0010#\u001a\u00020\u001fH\u0002J\b\u0010$\u001a\u00020\u001fH\u0002J\b\u0010%\u001a\u00020\u001fH\u0002R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006'"}, d2={"Lokhttp3/internal/ws/WebSocketReader;", "Ljava/io/Closeable;", "isClient", "", "source", "Lokio/BufferedSource;", "frameCallback", "Lokhttp3/internal/ws/WebSocketReader$FrameCallback;", "perMessageDeflate", "noContextTakeover", "(ZLokio/BufferedSource;Lokhttp3/internal/ws/WebSocketReader$FrameCallback;ZZ)V", "closed", "controlFrameBuffer", "Lokio/Buffer;", "frameLength", "", "isControlFrame", "isFinalFrame", "maskCursor", "Lokio/Buffer$UnsafeCursor;", "maskKey", "", "messageFrameBuffer", "messageInflater", "Lokhttp3/internal/ws/MessageInflater;", "opcode", "", "readingCompressedMessage", "getSource", "()Lokio/BufferedSource;", "close", "", "processNextFrame", "readControlFrame", "readHeader", "readMessage", "readMessageFrame", "readUntilNonControlFrame", "FrameCallback", "okhttp"})
@SourceDebugExtension(value={"SMAP\nWebSocketReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebSocketReader.kt\nokhttp3/internal/ws/WebSocketReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,298:1\n1#2:299\n*E\n"})
public final class WebSocketReader
implements Closeable {
    private final boolean isClient;
    @NotNull
    private final BufferedSource source;
    @NotNull
    private final WebSocketReader$FrameCallback frameCallback;
    private final boolean perMessageDeflate;
    private final boolean noContextTakeover;
    private boolean closed;
    private int opcode;
    private long frameLength;
    private boolean isFinalFrame;
    private boolean isControlFrame;
    private boolean readingCompressedMessage;
    @NotNull
    private final Buffer controlFrameBuffer;
    @NotNull
    private final Buffer messageFrameBuffer;
    @Nullable
    private MessageInflater messageInflater;
    @Nullable
    private final byte[] maskKey;
    @Nullable
    private final Buffer$UnsafeCursor maskCursor;

    public WebSocketReader(boolean bl, @NotNull BufferedSource bufferedSource, @NotNull WebSocketReader$FrameCallback webSocketReader$FrameCallback, boolean bl2, boolean bl3) {
        Intrinsics.checkNotNullParameter(bufferedSource, "source");
        Intrinsics.checkNotNullParameter(webSocketReader$FrameCallback, "frameCallback");
        this.isClient = bl;
        this.source = bufferedSource;
        this.frameCallback = webSocketReader$FrameCallback;
        this.perMessageDeflate = bl2;
        this.noContextTakeover = bl3;
        this.controlFrameBuffer = new Buffer();
        this.messageFrameBuffer = new Buffer();
        this.maskKey = this.isClient ? null : new byte[4];
        this.maskCursor = this.isClient ? null : new Buffer$UnsafeCursor();
    }

    @NotNull
    public final BufferedSource getSource() {
        return this.source;
    }

    public final void processNextFrame() {
        this.readHeader();
        if (this.isControlFrame) {
            this.readControlFrame();
        } else {
            this.readMessageFrame();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void readHeader() {
        boolean bl;
        boolean bl2;
        boolean bl3;
        if (this.closed) {
            throw new IOException("closed");
        }
        int n = 0;
        long l = this.source.timeout().timeoutNanos();
        this.source.timeout().clearTimeout();
        try {
            n = Util.and(this.source.readByte(), 255);
        }
        finally {
            this.source.timeout().timeout(l, TimeUnit.NANOSECONDS);
        }
        this.opcode = n & 0xF;
        this.isFinalFrame = (n & 0x80) != 0;
        boolean bl4 = this.isControlFrame = (n & 8) != 0;
        if (this.isControlFrame && !this.isFinalFrame) {
            throw new ProtocolException("Control frames must be final.");
        }
        boolean bl5 = (n & 0x40) != 0;
        switch (this.opcode) {
            case 1: 
            case 2: {
                boolean bl6;
                if (bl5) {
                    if (!this.perMessageDeflate) {
                        throw new ProtocolException("Unexpected rsv1 flag");
                    }
                    bl6 = true;
                } else {
                    bl6 = false;
                }
                this.readingCompressedMessage = bl6;
                break;
            }
            default: {
                if (!bl5) break;
                throw new ProtocolException("Unexpected rsv1 flag");
            }
        }
        boolean bl7 = bl3 = (n & 0x20) != 0;
        if (bl3) {
            throw new ProtocolException("Unexpected rsv2 flag");
        }
        boolean bl8 = bl2 = (n & 0x10) != 0;
        if (bl2) {
            throw new ProtocolException("Unexpected rsv3 flag");
        }
        int n2 = Util.and(this.source.readByte(), 255);
        boolean bl9 = bl = (n2 & 0x80) != 0;
        if (bl == this.isClient) {
            throw new ProtocolException(this.isClient ? "Server-sent frames must not be masked." : "Client-sent frames must be masked.");
        }
        this.frameLength = n2 & 0x7F;
        if (this.frameLength == 126L) {
            this.frameLength = Util.and(this.source.readShort(), 65535);
        } else if (this.frameLength == 127L) {
            this.frameLength = this.source.readLong();
            if (this.frameLength < 0L) {
                throw new ProtocolException("Frame length 0x" + Util.toHexString(this.frameLength) + " > 0x7FFFFFFFFFFFFFFF");
            }
        }
        if (this.isControlFrame && this.frameLength > 125L) {
            throw new ProtocolException("Control frame must be less than 125B.");
        }
        if (bl) {
            Intrinsics.checkNotNull(this.maskKey);
            this.source.readFully(this.maskKey);
        }
    }

    private final void readControlFrame() {
        if (this.frameLength > 0L) {
            this.source.readFully(this.controlFrameBuffer, this.frameLength);
            if (!this.isClient) {
                Buffer$UnsafeCursor buffer$UnsafeCursor = this.maskCursor;
                Intrinsics.checkNotNull(buffer$UnsafeCursor);
                this.controlFrameBuffer.readAndWriteUnsafe(buffer$UnsafeCursor);
                this.maskCursor.seek(0L);
                Intrinsics.checkNotNull(this.maskKey);
                WebSocketProtocol.INSTANCE.toggleMask(this.maskCursor, this.maskKey);
                this.maskCursor.close();
            }
        }
        switch (this.opcode) {
            case 9: {
                this.frameCallback.onReadPing(this.controlFrameBuffer.readByteString());
                break;
            }
            case 10: {
                this.frameCallback.onReadPong(this.controlFrameBuffer.readByteString());
                break;
            }
            case 8: {
                int n = 1005;
                String string = "";
                long l = this.controlFrameBuffer.size();
                if (l == 1L) {
                    throw new ProtocolException("Malformed close payload length of 1.");
                }
                if (l != 0L) {
                    n = this.controlFrameBuffer.readShort();
                    string = this.controlFrameBuffer.readUtf8();
                    String string2 = WebSocketProtocol.INSTANCE.closeCodeExceptionMessage(n);
                    if (string2 != null) {
                        throw new ProtocolException(string2);
                    }
                }
                this.frameCallback.onReadClose(n, string);
                this.closed = true;
                break;
            }
            default: {
                throw new ProtocolException("Unknown control opcode: " + Util.toHexString(this.opcode));
            }
        }
    }

    private final void readMessageFrame() {
        int n = this.opcode;
        if (n != 1 && n != 2) {
            throw new ProtocolException("Unknown opcode: " + Util.toHexString(n));
        }
        this.readMessage();
        if (this.readingCompressedMessage) {
            MessageInflater messageInflater = this.messageInflater;
            if (messageInflater == null) {
                MessageInflater messageInflater2;
                MessageInflater messageInflater3 = messageInflater2 = new MessageInflater(this.noContextTakeover);
                boolean bl = false;
                this.messageInflater = messageInflater3;
                messageInflater = messageInflater2;
            }
            MessageInflater messageInflater4 = messageInflater;
            messageInflater4.inflate(this.messageFrameBuffer);
        }
        if (n == 1) {
            this.frameCallback.onReadMessage(this.messageFrameBuffer.readUtf8());
        } else {
            this.frameCallback.onReadMessage(this.messageFrameBuffer.readByteString());
        }
    }

    private final void readUntilNonControlFrame() {
        while (!this.closed) {
            this.readHeader();
            if (!this.isControlFrame) break;
            this.readControlFrame();
        }
    }

    private final void readMessage() {
        block4: {
            do {
                if (this.closed) {
                    throw new IOException("closed");
                }
                if (this.frameLength > 0L) {
                    this.source.readFully(this.messageFrameBuffer, this.frameLength);
                    if (!this.isClient) {
                        Buffer$UnsafeCursor buffer$UnsafeCursor = this.maskCursor;
                        Intrinsics.checkNotNull(buffer$UnsafeCursor);
                        this.messageFrameBuffer.readAndWriteUnsafe(buffer$UnsafeCursor);
                        this.maskCursor.seek(this.messageFrameBuffer.size() - this.frameLength);
                        Intrinsics.checkNotNull(this.maskKey);
                        WebSocketProtocol.INSTANCE.toggleMask(this.maskCursor, this.maskKey);
                        this.maskCursor.close();
                    }
                }
                if (this.isFinalFrame) break block4;
                this.readUntilNonControlFrame();
            } while (this.opcode == 0);
            throw new ProtocolException("Expected continuation opcode. Got: " + Util.toHexString(this.opcode));
        }
    }

    @Override
    public void close() {
        block0: {
            MessageInflater messageInflater = this.messageInflater;
            if (messageInflater == null) break block0;
            messageInflater.close();
        }
    }
}

