/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform;

import android.os.Build;
import android.security.NetworkSecurityPolicy;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Protocol;
import okhttp3.internal.SuppressSignatureCheck;
import okhttp3.internal.platform.AndroidPlatform$Companion;
import okhttp3.internal.platform.AndroidPlatform$CustomTrustRootIndex;
import okhttp3.internal.platform.Platform;
import okhttp3.internal.platform.android.AndroidCertificateChainCleaner;
import okhttp3.internal.platform.android.AndroidSocketAdapter;
import okhttp3.internal.platform.android.BouncyCastleSocketAdapter;
import okhttp3.internal.platform.android.CloseGuard;
import okhttp3.internal.platform.android.ConscryptSocketAdapter;
import okhttp3.internal.platform.android.DeferredSocketAdapter;
import okhttp3.internal.platform.android.SocketAdapter;
import okhttp3.internal.platform.android.StandardAndroidSocketAdapter;
import okhttp3.internal.platform.android.StandardAndroidSocketAdapter$Companion;
import okhttp3.internal.tls.CertificateChainCleaner;
import okhttp3.internal.tls.TrustRootIndex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 )2\u00020\u0001:\u0002)*B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J-\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0011\u0010\u0014\u001a\r\u0012\t\u0012\u00070\u0015\u00a2\u0006\u0002\b\u00160\u0006H\u0016J \u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\u0013H\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\u00132\b\u0010&\u001a\u0004\u0018\u00010 H\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010'\u001a\u00020(H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lokhttp3/internal/platform/AndroidPlatform;", "Lokhttp3/internal/platform/Platform;", "()V", "closeGuard", "Lokhttp3/internal/platform/android/CloseGuard;", "socketAdapters", "", "Lokhttp3/internal/platform/android/SocketAdapter;", "buildCertificateChainCleaner", "Lokhttp3/internal/tls/CertificateChainCleaner;", "trustManager", "Ljavax/net/ssl/X509TrustManager;", "buildTrustRootIndex", "Lokhttp3/internal/tls/TrustRootIndex;", "configureTlsExtensions", "", "sslSocket", "Ljavax/net/ssl/SSLSocket;", "hostname", "", "protocols", "Lokhttp3/Protocol;", "Lkotlin/jvm/JvmSuppressWildcards;", "connectSocket", "socket", "Ljava/net/Socket;", "address", "Ljava/net/InetSocketAddress;", "connectTimeout", "", "getSelectedProtocol", "getStackTraceForCloseable", "", "closer", "isCleartextTrafficPermitted", "", "logCloseableLeak", "message", "stackTrace", "sslSocketFactory", "Ljavax/net/ssl/SSLSocketFactory;", "Companion", "CustomTrustRootIndex", "okhttp"})
@SuppressSignatureCheck
@SourceDebugExtension(value={"SMAP\nAndroidPlatform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidPlatform.kt\nokhttp3/internal/platform/AndroidPlatform\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,163:1\n766#2:164\n857#2,2:165\n1#3:167\n*S KotlinDebug\n*F\n+ 1 AndroidPlatform.kt\nokhttp3/internal/platform/AndroidPlatform\n*L\n52#1:164\n52#1:165,2\n*E\n"})
public final class AndroidPlatform
extends Platform {
    @NotNull
    public static final AndroidPlatform$Companion Companion;
    @NotNull
    private final List<SocketAdapter> socketAdapters;
    @NotNull
    private final CloseGuard closeGuard;
    private static final boolean isSupported;

    public AndroidPlatform() {
        Object object = new SocketAdapter[]{StandardAndroidSocketAdapter$Companion.buildIfSupported$default(StandardAndroidSocketAdapter.Companion, null, 1, null), new DeferredSocketAdapter(AndroidSocketAdapter.Companion.getPlayProviderFactory()), new DeferredSocketAdapter(ConscryptSocketAdapter.Companion.getFactory()), new DeferredSocketAdapter(BouncyCastleSocketAdapter.Companion.getFactory())};
        object = CollectionsKt.listOfNotNull(object);
        AndroidPlatform androidPlatform = this;
        boolean bl = false;
        Object object2 = object;
        Collection collection = new ArrayList();
        boolean bl2 = false;
        Iterator iterator2 = object2.iterator();
        while (iterator2.hasNext()) {
            Object t = iterator2.next();
            SocketAdapter socketAdapter = (SocketAdapter)t;
            boolean bl3 = false;
            if (!socketAdapter.isSupported()) continue;
            collection.add(t);
        }
        androidPlatform.socketAdapters = (List)collection;
        this.closeGuard = CloseGuard.Companion.get();
    }

    @Override
    public void connectSocket(@NotNull Socket socket, @NotNull InetSocketAddress inetSocketAddress, int n) {
        Intrinsics.checkNotNullParameter(socket, "socket");
        Intrinsics.checkNotNullParameter(inetSocketAddress, "address");
        try {
            socket.connect(inetSocketAddress, n);
        }
        catch (ClassCastException classCastException) {
            if (Build.VERSION.SDK_INT == 26) {
                throw new IOException("Exception in connect", classCastException);
            }
            throw classCastException;
        }
    }

    @Override
    @Nullable
    public X509TrustManager trustManager(@NotNull SSLSocketFactory sSLSocketFactory) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(sSLSocketFactory, "sslSocketFactory");
            Iterable iterable = this.socketAdapters;
            for (Object t : iterable) {
                SocketAdapter socketAdapter = (SocketAdapter)t;
                boolean bl = false;
                if (!socketAdapter.matchesSocketFactory(sSLSocketFactory)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        SocketAdapter socketAdapter = v0;
        return socketAdapter != null ? socketAdapter.trustManager(sSLSocketFactory) : null;
    }

    @Override
    public void configureTlsExtensions(@NotNull SSLSocket sSLSocket, @Nullable String string, @NotNull List<Protocol> list) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter(sSLSocket, "sslSocket");
            Intrinsics.checkNotNullParameter(list, "protocols");
            Iterable iterable = this.socketAdapters;
            for (Object t : iterable) {
                SocketAdapter socketAdapter = (SocketAdapter)t;
                boolean bl = false;
                if (!socketAdapter.matchesSocket(sSLSocket)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        SocketAdapter socketAdapter = v0;
        if (socketAdapter != null) {
            socketAdapter.configureTlsExtensions(sSLSocket, string, list);
        }
    }

    @Override
    @Nullable
    public String getSelectedProtocol(@NotNull SSLSocket sSLSocket) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(sSLSocket, "sslSocket");
            Iterable iterable = this.socketAdapters;
            for (Object t : iterable) {
                SocketAdapter socketAdapter = (SocketAdapter)t;
                boolean bl = false;
                if (!socketAdapter.matchesSocket(sSLSocket)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        SocketAdapter socketAdapter = v0;
        return socketAdapter != null ? socketAdapter.getSelectedProtocol(sSLSocket) : null;
    }

    @Override
    @Nullable
    public Object getStackTraceForCloseable(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "closer");
        return this.closeGuard.createAndOpen(string);
    }

    @Override
    public void logCloseableLeak(@NotNull String string, @Nullable Object object) {
        Intrinsics.checkNotNullParameter(string, "message");
        boolean bl = this.closeGuard.warnIfOpen(object);
        if (!bl) {
            Platform.log$default(this, string, 5, null, 4, null);
        }
    }

    @Override
    public boolean isCleartextTrafficPermitted(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "hostname");
        return Build.VERSION.SDK_INT >= 24 ? NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted(string) : (Build.VERSION.SDK_INT >= 23 ? NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted() : true);
    }

    @Override
    @NotNull
    public CertificateChainCleaner buildCertificateChainCleaner(@NotNull X509TrustManager x509TrustManager) {
        Intrinsics.checkNotNullParameter(x509TrustManager, "trustManager");
        AndroidCertificateChainCleaner androidCertificateChainCleaner = AndroidCertificateChainCleaner.Companion.buildIfSupported(x509TrustManager);
        return androidCertificateChainCleaner != null ? (CertificateChainCleaner)androidCertificateChainCleaner : super.buildCertificateChainCleaner(x509TrustManager);
    }

    @Override
    @NotNull
    public TrustRootIndex buildTrustRootIndex(@NotNull X509TrustManager x509TrustManager) {
        Object object;
        Intrinsics.checkNotNullParameter(x509TrustManager, "trustManager");
        try {
            Class[] classArray = new Class[]{X509Certificate.class};
            object = x509TrustManager.getClass().getDeclaredMethod("findTrustAnchorByIssuerAndSignature", classArray);
            ((Method)object).setAccessible(true);
            Intrinsics.checkNotNullExpressionValue(object, "method");
            object = new AndroidPlatform$CustomTrustRootIndex(x509TrustManager, (Method)object);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            object = super.buildTrustRootIndex(x509TrustManager);
        }
        return object;
    }

    public static final /* synthetic */ boolean access$isSupported$cp() {
        return isSupported;
    }

    static {
        boolean bl;
        Companion = new AndroidPlatform$Companion(null);
        if (!Platform.Companion.isAndroid()) {
            bl = false;
        } else if (Build.VERSION.SDK_INT >= 30) {
            bl = false;
        } else {
            if (!(Build.VERSION.SDK_INT >= 21)) {
                boolean bl2 = false;
                String string = "Expected Android API level 21+ but was " + Build.VERSION.SDK_INT;
                throw new IllegalStateException(string.toString());
            }
            bl = true;
        }
        isSupported = bl;
    }
}

