/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Headers;
import okhttp3.Headers$Builder;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response$Builder;
import okhttp3.internal.http.RequestLine;
import okhttp3.internal.http.StatusLine;
import okhttp3.internal.http2.Header;
import okhttp3.internal.http2.Http2ExchangeCodec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\b2\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lokhttp3/internal/http2/Http2ExchangeCodec$Companion;", "", "()V", "CONNECTION", "", "ENCODING", "HOST", "HTTP_2_SKIPPED_REQUEST_HEADERS", "", "HTTP_2_SKIPPED_RESPONSE_HEADERS", "KEEP_ALIVE", "PROXY_CONNECTION", "TE", "TRANSFER_ENCODING", "UPGRADE", "http2HeadersList", "Lokhttp3/internal/http2/Header;", "request", "Lokhttp3/Request;", "readHttp2HeadersList", "Lokhttp3/Response$Builder;", "headerBlock", "Lokhttp3/Headers;", "protocol", "Lokhttp3/Protocol;", "okhttp"})
public final class Http2ExchangeCodec$Companion {
    private Http2ExchangeCodec$Companion() {
    }

    @NotNull
    public final List<Header> http2HeadersList(@NotNull Request request) {
        Intrinsics.checkNotNullParameter(request, "request");
        Headers headers = request.headers();
        ArrayList<Header> arrayList = new ArrayList<Header>(headers.size() + 4);
        arrayList.add(new Header(Header.TARGET_METHOD, request.method()));
        arrayList.add(new Header(Header.TARGET_PATH, RequestLine.INSTANCE.requestPath(request.url())));
        String string = request.header("Host");
        if (string != null) {
            arrayList.add(new Header(Header.TARGET_AUTHORITY, string));
        }
        arrayList.add(new Header(Header.TARGET_SCHEME, request.url().scheme()));
        int n = headers.size();
        for (int i = 0; i < n; ++i) {
            String string2;
            String string3 = headers.name(i);
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue(locale, "US");
            Intrinsics.checkNotNullExpressionValue(string3.toLowerCase(locale), "this as java.lang.String).toLowerCase(locale)");
            if (Http2ExchangeCodec.access$getHTTP_2_SKIPPED_REQUEST_HEADERS$cp().contains(string2) && (!Intrinsics.areEqual(string2, "te") || !Intrinsics.areEqual(headers.value(i), "trailers"))) continue;
            arrayList.add(new Header(string2, headers.value(i)));
        }
        return arrayList;
    }

    @NotNull
    public final Response$Builder readHttp2HeadersList(@NotNull Headers headers, @NotNull Protocol protocol) {
        Intrinsics.checkNotNullParameter(headers, "headerBlock");
        Intrinsics.checkNotNullParameter((Object)protocol, "protocol");
        StatusLine statusLine = null;
        Headers$Builder headers$Builder = new Headers$Builder();
        int n = headers.size();
        for (int i = 0; i < n; ++i) {
            String string = headers.name(i);
            String string2 = headers.value(i);
            if (Intrinsics.areEqual(string, ":status")) {
                statusLine = StatusLine.Companion.parse("HTTP/1.1 " + string2);
                continue;
            }
            if (Http2ExchangeCodec.access$getHTTP_2_SKIPPED_RESPONSE_HEADERS$cp().contains(string)) continue;
            headers$Builder.addLenient$okhttp(string, string2);
        }
        if (statusLine == null) {
            throw new ProtocolException("Expected ':status' header not present");
        }
        return new Response$Builder().protocol(protocol).code(statusLine.code).message(statusLine.message).headers(headers$Builder.build());
    }

    public /* synthetic */ Http2ExchangeCodec$Companion(DefaultConstructorMarker defaultConstructorMarker) {
        this();
    }
}

