/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref$ObjectRef;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Headers;
import okhttp3.internal.Util;
import okhttp3.internal.concurrent.TaskQueue;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Header;
import okhttp3.internal.http2.Http2Connection;
import okhttp3.internal.http2.Http2Connection$ReaderRunnable$applyAndAckSettings$lambda$7$lambda$6$$inlined$execute$default$1;
import okhttp3.internal.http2.Http2Connection$ReaderRunnable$headers$lambda$2$$inlined$execute$default$1;
import okhttp3.internal.http2.Http2Connection$ReaderRunnable$ping$$inlined$execute$default$1;
import okhttp3.internal.http2.Http2Connection$ReaderRunnable$settings$$inlined$execute$default$1;
import okhttp3.internal.http2.Http2Reader;
import okhttp3.internal.http2.Http2Reader$Handler;
import okhttp3.internal.http2.Http2Stream;
import okhttp3.internal.http2.Settings;
import okio.BufferedSource;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0086\u0004\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u000f\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\u0003H\u0016J8\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J(\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\fH\u0016J \u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0010H\u0016J.\u0010$\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010%\u001a\u00020\f2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'H\u0016J\t\u0010)\u001a\u00020\u0003H\u0096\u0002J \u0010*\u001a\u00020\u00032\u0006\u0010+\u001a\u00020\u00172\u0006\u0010,\u001a\u00020\f2\u0006\u0010-\u001a\u00020\fH\u0016J(\u0010.\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010/\u001a\u00020\f2\u0006\u00100\u001a\u00020\f2\u0006\u00101\u001a\u00020\u0017H\u0016J&\u00102\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u00103\u001a\u00020\f2\f\u00104\u001a\b\u0012\u0004\u0012\u00020(0'H\u0016J\u0018\u00105\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u00106\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u00107\u001a\u00020\u0014H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u00068"}, d2={"Lokhttp3/internal/http2/Http2Connection$ReaderRunnable;", "Lokhttp3/internal/http2/Http2Reader$Handler;", "Lkotlin/Function0;", "", "reader", "Lokhttp3/internal/http2/Http2Reader;", "(Lokhttp3/internal/http2/Http2Connection;Lokhttp3/internal/http2/Http2Reader;)V", "getReader$okhttp", "()Lokhttp3/internal/http2/Http2Reader;", "ackSettings", "alternateService", "streamId", "", "origin", "", "protocol", "Lokio/ByteString;", "host", "port", "maxAge", "", "applyAndAckSettings", "clearPrevious", "", "settings", "Lokhttp3/internal/http2/Settings;", "data", "inFinished", "source", "Lokio/BufferedSource;", "length", "goAway", "lastGoodStreamId", "errorCode", "Lokhttp3/internal/http2/ErrorCode;", "debugData", "headers", "associatedStreamId", "headerBlock", "", "Lokhttp3/internal/http2/Header;", "invoke", "ping", "ack", "payload1", "payload2", "priority", "streamDependency", "weight", "exclusive", "pushPromise", "promisedStreamId", "requestHeaders", "rstStream", "windowUpdate", "windowSizeIncrement", "okhttp"})
@SourceDebugExtension(value={"SMAP\nHttp2Connection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http2Connection.kt\nokhttp3/internal/http2/Http2Connection$ReaderRunnable\n+ 2 TaskQueue.kt\nokhttp3/internal/concurrent/TaskQueue\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 Util.kt\nokhttp3/internal/Util\n*L\n1#1,1006:1\n90#2,13:1007\n90#2,13:1020\n90#2,13:1035\n90#2,13:1049\n37#3,2:1033\n37#3,2:1062\n563#4:1048\n563#4:1064\n*S KotlinDebug\n*F\n+ 1 Http2Connection.kt\nokhttp3/internal/http2/Http2Connection$ReaderRunnable\n*L\n687#1:1007,13\n715#1:1020,13\n758#1:1035,13\n806#1:1049,13\n753#1:1033,2\n824#1:1062,2\n797#1:1048\n841#1:1064\n*E\n"})
public final class Http2Connection$ReaderRunnable
implements Function0<Unit>,
Http2Reader$Handler {
    @NotNull
    private final Http2Reader reader;
    final /* synthetic */ Http2Connection this$0;

    public Http2Connection$ReaderRunnable(@NotNull Http2Connection http2Connection, Http2Reader http2Reader) {
        Intrinsics.checkNotNullParameter(http2Reader, "reader");
        this.this$0 = http2Connection;
        this.reader = http2Reader;
    }

    @NotNull
    public final Http2Reader getReader$okhttp() {
        return this.reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke() {
        ErrorCode errorCode = ErrorCode.INTERNAL_ERROR;
        ErrorCode errorCode2 = ErrorCode.INTERNAL_ERROR;
        IOException iOException = null;
        try {
            this.reader.readConnectionPreface(this);
            while (this.reader.nextFrame(false, this)) {
            }
            errorCode = ErrorCode.NO_ERROR;
            errorCode2 = ErrorCode.CANCEL;
        }
        catch (IOException iOException2) {
            iOException = iOException2;
            errorCode = ErrorCode.PROTOCOL_ERROR;
            errorCode2 = ErrorCode.PROTOCOL_ERROR;
        }
        finally {
            this.this$0.close$okhttp(errorCode, errorCode2, iOException);
            Util.closeQuietly(this.reader);
        }
    }

    @Override
    public void data(boolean bl, int n, @NotNull BufferedSource bufferedSource, int n2) {
        Intrinsics.checkNotNullParameter(bufferedSource, "source");
        if (this.this$0.pushedStream$okhttp(n)) {
            this.this$0.pushDataLater$okhttp(n, bufferedSource, n2, bl);
            return;
        }
        Http2Stream http2Stream = this.this$0.getStream(n);
        if (http2Stream == null) {
            this.this$0.writeSynResetLater$okhttp(n, ErrorCode.PROTOCOL_ERROR);
            this.this$0.updateConnectionFlowControl$okhttp(n2);
            bufferedSource.skip(n2);
            return;
        }
        http2Stream.receiveData(bufferedSource, n2);
        if (bl) {
            http2Stream.receiveHeaders(Util.EMPTY_HEADERS, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void headers(boolean bl, int n, int n2, @NotNull List<Header> list) {
        Intrinsics.checkNotNullParameter(list, "headerBlock");
        if (this.this$0.pushedStream$okhttp(n)) {
            this.this$0.pushHeadersLater$okhttp(n, list, bl);
            return;
        }
        Http2Stream http2Stream = null;
        Http2Connection http2Connection = this.this$0;
        Http2Connection http2Connection2 = this.this$0;
        Http2Connection http2Connection3 = http2Connection;
        synchronized (http2Connection3) {
            boolean bl2 = false;
            http2Stream = http2Connection2.getStream(n);
            if (http2Stream == null) {
                if (Http2Connection.access$isShutdown$p(http2Connection2)) {
                    return;
                }
                if (n <= http2Connection2.getLastGoodStreamId$okhttp()) {
                    return;
                }
                if (n % 2 == http2Connection2.getNextStreamId$okhttp() % 2) {
                    return;
                }
                Headers headers = Util.toHeaders(list);
                Http2Stream http2Stream2 = new Http2Stream(n, http2Connection2, false, bl, headers);
                http2Connection2.setLastGoodStreamId$okhttp(n);
                Object object = n;
                http2Connection2.getStreams$okhttp().put((Integer)object, http2Stream2);
                TaskQueue taskQueue = Http2Connection.access$getTaskRunner$p(http2Connection2).newQueue();
                object = http2Connection2.getConnectionName$okhttp() + '[' + n + "] onStream";
                long l = 0L;
                boolean bl3 = true;
                boolean bl4 = false;
                taskQueue.schedule(new Http2Connection$ReaderRunnable$headers$lambda$2$$inlined$execute$default$1((String)object, bl3, http2Connection2, http2Stream2), l);
                return;
            }
            Unit unit = Unit.INSTANCE;
        }
        http2Stream.receiveHeaders(Util.toHeaders(list), bl);
    }

    @Override
    public void rstStream(int n, @NotNull ErrorCode errorCode) {
        block1: {
            Http2Stream http2Stream;
            Intrinsics.checkNotNullParameter((Object)errorCode, "errorCode");
            if (this.this$0.pushedStream$okhttp(n)) {
                this.this$0.pushResetLater$okhttp(n, errorCode);
                return;
            }
            Http2Stream http2Stream2 = http2Stream = this.this$0.removeStream$okhttp(n);
            if (http2Stream2 == null) break block1;
            http2Stream2.receiveRstStream(errorCode);
        }
    }

    @Override
    public void settings(boolean bl, @NotNull Settings settings) {
        Intrinsics.checkNotNullParameter(settings, "settings");
        TaskQueue taskQueue = Http2Connection.access$getWriterQueue$p(this.this$0);
        String string = this.this$0.getConnectionName$okhttp() + " applyAndAckSettings";
        long l = 0L;
        boolean bl2 = true;
        boolean bl3 = false;
        taskQueue.schedule(new Http2Connection$ReaderRunnable$settings$$inlined$execute$default$1(string, bl2, this, bl, settings), l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void applyAndAckSettings(boolean bl, @NotNull Settings settings) {
        Object object;
        Unit unit;
        Object object2;
        Intrinsics.checkNotNullParameter(settings, "settings");
        long l = 0L;
        Http2Stream[] http2StreamArray = null;
        Ref$ObjectRef ref$ObjectRef = new Ref$ObjectRef();
        Http2Stream[] http2StreamArray2 = this.this$0.getWriter();
        Http2Connection http2Connection = this.this$0;
        Http2Stream[] http2StreamArray3 = http2StreamArray2;
        synchronized (http2StreamArray3) {
            boolean bl2 = false;
            object2 = http2Connection;
            synchronized (object2) {
                Http2Stream[] http2StreamArray4;
                Settings settings2;
                boolean bl3 = false;
                Settings settings3 = http2Connection.getPeerSettings();
                Ref$ObjectRef ref$ObjectRef2 = ref$ObjectRef;
                if (bl) {
                    settings2 = settings;
                } else {
                    Settings settings4;
                    Settings settings5 = settings4 = new Settings();
                    Ref$ObjectRef ref$ObjectRef3 = ref$ObjectRef2;
                    boolean bl4 = false;
                    settings5.merge(settings3);
                    settings5.merge(settings);
                    ref$ObjectRef2 = ref$ObjectRef3;
                    settings2 = settings4;
                }
                ref$ObjectRef2.element = settings2;
                long l2 = ((Settings)ref$ObjectRef.element).getInitialWindowSize();
                l = l2 - (long)settings3.getInitialWindowSize();
                if (l == 0L || http2Connection.getStreams$okhttp().isEmpty()) {
                    http2StreamArray4 = null;
                } else {
                    Collection<Http2Stream> collection = http2Connection.getStreams$okhttp().values();
                    boolean bl5 = false;
                    Collection<Http2Stream> collection2 = collection;
                    http2StreamArray4 = collection2.toArray(new Http2Stream[0]);
                }
                http2StreamArray = http2StreamArray4;
                http2Connection.setPeerSettings((Settings)ref$ObjectRef.element);
                TaskQueue taskQueue = Http2Connection.access$getSettingsListenerQueue$p(http2Connection);
                String string = http2Connection.getConnectionName$okhttp() + " onSettings";
                long l3 = 0L;
                boolean bl6 = true;
                boolean bl7 = false;
                taskQueue.schedule(new Http2Connection$ReaderRunnable$applyAndAckSettings$lambda$7$lambda$6$$inlined$execute$default$1(string, bl6, http2Connection, ref$ObjectRef), l3);
                unit = Unit.INSTANCE;
            }
            try {
                http2Connection.getWriter().applyAndAckSettings((Settings)ref$ObjectRef.element);
            }
            catch (IOException iOException) {
                Http2Connection.access$failConnection(http2Connection, iOException);
            }
            object = Unit.INSTANCE;
        }
        if (http2StreamArray != null) {
            http2StreamArray2 = http2StreamArray;
            int n = http2StreamArray2.length;
            for (int i = 0; i < n; ++i) {
                object2 = object = http2StreamArray2[i];
                synchronized (object2) {
                    boolean bl8 = false;
                    ((Http2Stream)object).addBytesToWriteWindow(l);
                    unit = Unit.INSTANCE;
                    continue;
                }
            }
        }
    }

    @Override
    public void ackSettings() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ping(boolean bl, int n, int n2) {
        if (bl) {
            Http2Connection http2Connection = this.this$0;
            Http2Connection http2Connection2 = this.this$0;
            Http2Connection http2Connection3 = http2Connection;
            synchronized (http2Connection3) {
                Object object;
                boolean bl2 = false;
                switch (n) {
                    case 1: {
                        long l = Http2Connection.access$getIntervalPongsReceived$p(http2Connection2);
                        Http2Connection.access$setIntervalPongsReceived$p(http2Connection2, l + 1L);
                        object = l;
                        break;
                    }
                    case 2: {
                        long l = Http2Connection.access$getDegradedPongsReceived$p(http2Connection2);
                        Http2Connection.access$setDegradedPongsReceived$p(http2Connection2, l + 1L);
                        object = l;
                        break;
                    }
                    case 3: {
                        long l = Http2Connection.access$getAwaitPongsReceived$p(http2Connection2);
                        Http2Connection.access$setAwaitPongsReceived$p(http2Connection2, l + 1L);
                        Http2Connection http2Connection4 = http2Connection2;
                        boolean bl3 = false;
                        Intrinsics.checkNotNull(http2Connection4, "null cannot be cast to non-null type java.lang.Object");
                        ((Object)http2Connection4).notifyAll();
                        object = Unit.INSTANCE;
                        break;
                    }
                    default: {
                        object = Unit.INSTANCE;
                    }
                }
                Unit unit = object;
            }
        } else {
            TaskQueue taskQueue = Http2Connection.access$getWriterQueue$p(this.this$0);
            String string = this.this$0.getConnectionName$okhttp() + " ping";
            Http2Connection http2Connection = this.this$0;
            long l = 0L;
            boolean bl4 = true;
            boolean bl5 = false;
            taskQueue.schedule(new Http2Connection$ReaderRunnable$ping$$inlined$execute$default$1(string, bl4, http2Connection, n, n2), l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void goAway(int n, @NotNull ErrorCode errorCode, @NotNull ByteString byteString) {
        Intrinsics.checkNotNullParameter((Object)errorCode, "errorCode");
        Intrinsics.checkNotNullParameter(byteString, "debugData");
        if (byteString.size() > 0) {
            // empty if block
        }
        Http2Stream[] http2StreamArray = null;
        Http2Stream[] http2StreamArray2 = this.this$0;
        Http2Connection http2Connection = this.this$0;
        Http2Stream[] http2StreamArray3 = http2StreamArray2;
        synchronized (http2StreamArray3) {
            boolean bl = false;
            Collection<Http2Stream> collection = http2Connection.getStreams$okhttp().values();
            boolean bl2 = false;
            Collection<Http2Stream> collection2 = collection;
            http2StreamArray = collection2.toArray(new Http2Stream[0]);
            Http2Connection.access$setShutdown$p(http2Connection, true);
            Unit object = Unit.INSTANCE;
        }
        for (Http2Stream http2Stream : http2StreamArray) {
            if (http2Stream.getId() <= n || !http2Stream.isLocallyInitiated()) continue;
            http2Stream.receiveRstStream(ErrorCode.REFUSED_STREAM);
            this.this$0.removeStream$okhttp(http2Stream.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void windowUpdate(int n, long l) {
        if (n == 0) {
            Http2Connection http2Connection = this.this$0;
            Http2Connection http2Connection2 = this.this$0;
            Http2Connection http2Connection3 = http2Connection;
            synchronized (http2Connection3) {
                boolean bl = false;
                Http2Connection.access$setWriteBytesMaximum$p(http2Connection2, http2Connection2.getWriteBytesMaximum() + l);
                Http2Connection http2Connection4 = http2Connection2;
                boolean bl2 = false;
                Intrinsics.checkNotNull(http2Connection4, "null cannot be cast to non-null type java.lang.Object");
                ((Object)http2Connection4).notifyAll();
                Unit unit = Unit.INSTANCE;
            }
        }
        Http2Stream http2Stream = this.this$0.getStream(n);
        if (http2Stream != null) {
            Http2Stream http2Stream2 = http2Stream;
            synchronized (http2Stream2) {
                boolean bl = false;
                http2Stream.addBytesToWriteWindow(l);
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    @Override
    public void priority(int n, int n2, int n3, boolean bl) {
    }

    @Override
    public void pushPromise(int n, int n2, @NotNull List<Header> list) {
        Intrinsics.checkNotNullParameter(list, "requestHeaders");
        this.this$0.pushRequestLater$okhttp(n2, list);
    }

    @Override
    public void alternateService(int n, @NotNull String string, @NotNull ByteString byteString, @NotNull String string2, int n2, long l) {
        Intrinsics.checkNotNullParameter(string, "origin");
        Intrinsics.checkNotNullParameter(byteString, "protocol");
        Intrinsics.checkNotNullParameter(string2, "host");
    }
}

