/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.http2.Header;
import okhttp3.internal.http2.Hpack;
import okhttp3.internal.http2.Huffman;
import okio.Buffer;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\u0018\u00002\u00020\u0001B#\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0014H\u0002J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u000bH\u0002J\u000e\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dJ\u0014\u0010\u001e\u001a\u00020\u00142\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0 J\u001e\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u0003R\u001c\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u0012\u0010\r\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lokhttp3/internal/http2/Hpack$Writer;", "", "headerTableSizeSetting", "", "useCompression", "", "out", "Lokio/Buffer;", "(IZLokio/Buffer;)V", "dynamicTable", "", "Lokhttp3/internal/http2/Header;", "[Lokhttp3/internal/http2/Header;", "dynamicTableByteCount", "emitDynamicTableSizeUpdate", "headerCount", "maxDynamicTableByteCount", "nextHeaderIndex", "smallestHeaderTableSizeSetting", "adjustDynamicTableByteCount", "", "clearDynamicTable", "evictToRecoverBytes", "bytesToRecover", "insertIntoDynamicTable", "entry", "resizeHeaderTable", "writeByteString", "data", "Lokio/ByteString;", "writeHeaders", "headerBlock", "", "writeInt", "value", "prefixMask", "bits", "okhttp"})
public final class Hpack$Writer {
    @JvmField
    public int headerTableSizeSetting;
    private final boolean useCompression;
    @NotNull
    private final Buffer out;
    private int smallestHeaderTableSizeSetting;
    private boolean emitDynamicTableSizeUpdate;
    @JvmField
    public int maxDynamicTableByteCount;
    @JvmField
    @NotNull
    public Header[] dynamicTable;
    private int nextHeaderIndex;
    @JvmField
    public int headerCount;
    @JvmField
    public int dynamicTableByteCount;

    @JvmOverloads
    public Hpack$Writer(int n, boolean bl, @NotNull Buffer buffer) {
        Intrinsics.checkNotNullParameter(buffer, "out");
        this.headerTableSizeSetting = n;
        this.useCompression = bl;
        this.out = buffer;
        this.smallestHeaderTableSizeSetting = Integer.MAX_VALUE;
        this.maxDynamicTableByteCount = this.headerTableSizeSetting;
        this.dynamicTable = new Header[8];
        this.nextHeaderIndex = this.dynamicTable.length - 1;
    }

    public /* synthetic */ Hpack$Writer(int n, boolean bl, Buffer buffer, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 4096;
        }
        if ((n2 & 2) != 0) {
            bl = true;
        }
        this(n, bl, buffer);
    }

    private final void clearDynamicTable() {
        ArraysKt.fill$default(this.dynamicTable, null, 0, 0, 6, null);
        this.nextHeaderIndex = this.dynamicTable.length - 1;
        this.headerCount = 0;
        this.dynamicTableByteCount = 0;
    }

    private final int evictToRecoverBytes(int n) {
        int n2 = n;
        int n3 = 0;
        if (n2 > 0) {
            for (int i = this.dynamicTable.length - 1; i >= this.nextHeaderIndex && n2 > 0; --i) {
                Header header = this.dynamicTable[i];
                Intrinsics.checkNotNull(header);
                n2 -= header.hpackSize;
                Header header2 = this.dynamicTable[i];
                Intrinsics.checkNotNull(header2);
                this.dynamicTableByteCount -= header2.hpackSize;
                int n4 = this.headerCount;
                this.headerCount = n4 + -1;
                ++n3;
            }
            System.arraycopy(this.dynamicTable, this.nextHeaderIndex + 1, this.dynamicTable, this.nextHeaderIndex + 1 + n3, this.headerCount);
            Arrays.fill(this.dynamicTable, this.nextHeaderIndex + 1, this.nextHeaderIndex + 1 + n3, null);
            this.nextHeaderIndex += n3;
        }
        return n3;
    }

    private final void insertIntoDynamicTable(Header header) {
        int n = header.hpackSize;
        if (n > this.maxDynamicTableByteCount) {
            this.clearDynamicTable();
            return;
        }
        int n2 = this.dynamicTableByteCount + n - this.maxDynamicTableByteCount;
        this.evictToRecoverBytes(n2);
        if (this.headerCount + 1 > this.dynamicTable.length) {
            Header[] headerArray = new Header[this.dynamicTable.length * 2];
            System.arraycopy(this.dynamicTable, 0, headerArray, this.dynamicTable.length, this.dynamicTable.length);
            this.nextHeaderIndex = this.dynamicTable.length - 1;
            this.dynamicTable = headerArray;
        }
        int n3 = this.nextHeaderIndex;
        this.nextHeaderIndex = n3 + -1;
        int n4 = n3;
        this.dynamicTable[n4] = header;
        n3 = this.headerCount;
        this.headerCount = n3 + 1;
        this.dynamicTableByteCount += n;
    }

    public final void writeHeaders(@NotNull List<Header> list) {
        Intrinsics.checkNotNullParameter(list, "headerBlock");
        if (this.emitDynamicTableSizeUpdate) {
            if (this.smallestHeaderTableSizeSetting < this.maxDynamicTableByteCount) {
                this.writeInt(this.smallestHeaderTableSizeSetting, 31, 32);
            }
            this.emitDynamicTableSizeUpdate = false;
            this.smallestHeaderTableSizeSetting = Integer.MAX_VALUE;
            this.writeInt(this.maxDynamicTableByteCount, 31, 32);
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Header header = list.get(i);
            ByteString byteString = header.name.toAsciiLowercase();
            ByteString byteString2 = header.value;
            int n2 = -1;
            int n3 = -1;
            Integer n4 = Hpack.INSTANCE.getNAME_TO_FIRST_INDEX().get(byteString);
            if (n4 != null) {
                n3 = n4 + 1;
                boolean bl = 2 <= n3 ? n3 < 8 : false;
                if (bl) {
                    if (Intrinsics.areEqual(Hpack.INSTANCE.getSTATIC_HEADER_TABLE()[n3 - 1].value, byteString2)) {
                        n2 = n3;
                    } else if (Intrinsics.areEqual(Hpack.INSTANCE.getSTATIC_HEADER_TABLE()[n3].value, byteString2)) {
                        n2 = n3 + 1;
                    }
                }
            }
            if (n2 == -1) {
                int n5 = this.dynamicTable.length;
                for (int j = this.nextHeaderIndex + 1; j < n5; ++j) {
                    Header header2 = this.dynamicTable[j];
                    Intrinsics.checkNotNull(header2);
                    if (!Intrinsics.areEqual(header2.name, byteString)) continue;
                    Header header3 = this.dynamicTable[j];
                    Intrinsics.checkNotNull(header3);
                    if (Intrinsics.areEqual(header3.value, byteString2)) {
                        n2 = j - this.nextHeaderIndex + Hpack.INSTANCE.getSTATIC_HEADER_TABLE().length;
                        break;
                    }
                    if (n3 != -1) continue;
                    n3 = j - this.nextHeaderIndex + Hpack.INSTANCE.getSTATIC_HEADER_TABLE().length;
                }
            }
            if (n2 != -1) {
                this.writeInt(n2, 127, 128);
                continue;
            }
            if (n3 == -1) {
                this.out.writeByte(64);
                this.writeByteString(byteString);
                this.writeByteString(byteString2);
                this.insertIntoDynamicTable(header);
                continue;
            }
            if (byteString.startsWith(Header.PSEUDO_PREFIX) && !Intrinsics.areEqual(Header.TARGET_AUTHORITY, byteString)) {
                this.writeInt(n3, 15, 0);
                this.writeByteString(byteString2);
                continue;
            }
            this.writeInt(n3, 63, 64);
            this.writeByteString(byteString2);
            this.insertIntoDynamicTable(header);
        }
    }

    public final void writeInt(int n, int n2, int n3) {
        int n4 = n;
        if (n4 < n2) {
            this.out.writeByte(n3 | n4);
            return;
        }
        this.out.writeByte(n3 | n2);
        n4 -= n2;
        while (n4 >= 128) {
            int n5 = n4 & 0x7F;
            this.out.writeByte(n5 | 0x80);
            n4 >>>= 7;
        }
        this.out.writeByte(n4);
    }

    public final void writeByteString(@NotNull ByteString byteString) {
        Intrinsics.checkNotNullParameter(byteString, "data");
        if (this.useCompression && Huffman.INSTANCE.encodedLength(byteString) < byteString.size()) {
            Buffer buffer = new Buffer();
            Huffman.INSTANCE.encode(byteString, buffer);
            ByteString byteString2 = buffer.readByteString();
            this.writeInt(byteString2.size(), 127, 128);
            this.out.write(byteString2);
        } else {
            this.writeInt(byteString.size(), 127, 0);
            this.out.write(byteString);
        }
    }

    public final void resizeHeaderTable(int n) {
        this.headerTableSizeSetting = n;
        int n2 = Math.min(n, 16384);
        if (this.maxDynamicTableByteCount == n2) {
            return;
        }
        if (n2 < this.maxDynamicTableByteCount) {
            this.smallestHeaderTableSizeSetting = Math.min(this.smallestHeaderTableSizeSetting, n2);
        }
        this.emitDynamicTableSizeUpdate = true;
        this.maxDynamicTableByteCount = n2;
        this.adjustDynamicTableByteCount();
    }

    private final void adjustDynamicTableByteCount() {
        if (this.maxDynamicTableByteCount < this.dynamicTableByteCount) {
            if (this.maxDynamicTableByteCount == 0) {
                this.clearDynamicTable();
            } else {
                this.evictToRecoverBytes(this.dynamicTableByteCount - this.maxDynamicTableByteCount);
            }
        }
    }

    @JvmOverloads
    public Hpack$Writer(int n, @NotNull Buffer buffer) {
        Intrinsics.checkNotNullParameter(buffer, "out");
        this(n, false, buffer, 2, null);
    }

    @JvmOverloads
    public Hpack$Writer(@NotNull Buffer buffer) {
        Intrinsics.checkNotNullParameter(buffer, "out");
        this(0, false, buffer, 3, null);
    }
}

