/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http1;

import java.io.EOFException;
import java.io.IOException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Response$Builder;
import okhttp3.internal.Util;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.http.ExchangeCodec;
import okhttp3.internal.http.HttpHeaders;
import okhttp3.internal.http.RequestLine;
import okhttp3.internal.http.StatusLine;
import okhttp3.internal.http1.HeadersReader;
import okhttp3.internal.http1.Http1ExchangeCodec$ChunkedSink;
import okhttp3.internal.http1.Http1ExchangeCodec$ChunkedSource;
import okhttp3.internal.http1.Http1ExchangeCodec$Companion;
import okhttp3.internal.http1.Http1ExchangeCodec$FixedLengthSource;
import okhttp3.internal.http1.Http1ExchangeCodec$KnownLengthSink;
import okhttp3.internal.http1.Http1ExchangeCodec$UnknownLengthSource;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ForwardingTimeout;
import okio.Sink;
import okio.Source;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u0000 ?2\u00020\u0001:\u0007<=>?@ABB'\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$H\u0002J\b\u0010%\u001a\u00020\u001cH\u0016J\b\u0010&\u001a\u00020\u001cH\u0016J\b\u0010'\u001a\u00020\u001eH\u0002J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020)2\u0006\u0010-\u001a\u00020!H\u0002J\b\u0010.\u001a\u00020\u001eH\u0002J\b\u0010/\u001a\u00020)H\u0002J\u0010\u00100\u001a\u00020)2\u0006\u00101\u001a\u00020\u0019H\u0016J\u0012\u00102\u001a\u0004\u0018\u0001032\u0006\u00104\u001a\u00020\u0010H\u0016J\u0010\u00105\u001a\u00020!2\u0006\u00101\u001a\u00020\u0019H\u0016J\u000e\u00106\u001a\u00020\u001c2\u0006\u00101\u001a\u00020\u0019J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u00107\u001a\u00020\u001c2\u0006\u00108\u001a\u00020\u00152\u0006\u00109\u001a\u00020:J\u0010\u0010;\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u0017H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0016\u001a\u00020\u0010*\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018R\u0018\u0010\u0016\u001a\u00020\u0010*\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u001a\u00a8\u0006C"}, d2={"Lokhttp3/internal/http1/Http1ExchangeCodec;", "Lokhttp3/internal/http/ExchangeCodec;", "client", "Lokhttp3/OkHttpClient;", "connection", "Lokhttp3/internal/connection/RealConnection;", "source", "Lokio/BufferedSource;", "sink", "Lokio/BufferedSink;", "(Lokhttp3/OkHttpClient;Lokhttp3/internal/connection/RealConnection;Lokio/BufferedSource;Lokio/BufferedSink;)V", "getConnection", "()Lokhttp3/internal/connection/RealConnection;", "headersReader", "Lokhttp3/internal/http1/HeadersReader;", "isClosed", "", "()Z", "state", "", "trailers", "Lokhttp3/Headers;", "isChunked", "Lokhttp3/Request;", "(Lokhttp3/Request;)Z", "Lokhttp3/Response;", "(Lokhttp3/Response;)Z", "cancel", "", "createRequestBody", "Lokio/Sink;", "request", "contentLength", "", "detachTimeout", "timeout", "Lokio/ForwardingTimeout;", "finishRequest", "flushRequest", "newChunkedSink", "newChunkedSource", "Lokio/Source;", "url", "Lokhttp3/HttpUrl;", "newFixedLengthSource", "length", "newKnownLengthSink", "newUnknownLengthSource", "openResponseBodySource", "response", "readResponseHeaders", "Lokhttp3/Response$Builder;", "expectContinue", "reportedContentLength", "skipConnectBody", "writeRequest", "headers", "requestLine", "", "writeRequestHeaders", "AbstractSource", "ChunkedSink", "ChunkedSource", "Companion", "FixedLengthSource", "KnownLengthSink", "UnknownLengthSource", "okhttp"})
@SourceDebugExtension(value={"SMAP\nHttp1ExchangeCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http1ExchangeCodec.kt\nokhttp3/internal/http1/Http1ExchangeCodec\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,505:1\n1#2:506\n*E\n"})
public final class Http1ExchangeCodec
implements ExchangeCodec {
    @NotNull
    public static final Http1ExchangeCodec$Companion Companion = new Http1ExchangeCodec$Companion(null);
    @Nullable
    private final OkHttpClient client;
    @NotNull
    private final RealConnection connection;
    @NotNull
    private final BufferedSource source;
    @NotNull
    private final BufferedSink sink;
    private int state;
    @NotNull
    private final HeadersReader headersReader;
    @Nullable
    private Headers trailers;
    private static final long NO_CHUNK_YET = -1L;
    private static final int STATE_IDLE = 0;
    private static final int STATE_OPEN_REQUEST_BODY = 1;
    private static final int STATE_WRITING_REQUEST_BODY = 2;
    private static final int STATE_READ_RESPONSE_HEADERS = 3;
    private static final int STATE_OPEN_RESPONSE_BODY = 4;
    private static final int STATE_READING_RESPONSE_BODY = 5;
    private static final int STATE_CLOSED = 6;

    public Http1ExchangeCodec(@Nullable OkHttpClient okHttpClient, @NotNull RealConnection realConnection, @NotNull BufferedSource bufferedSource, @NotNull BufferedSink bufferedSink) {
        Intrinsics.checkNotNullParameter(realConnection, "connection");
        Intrinsics.checkNotNullParameter(bufferedSource, "source");
        Intrinsics.checkNotNullParameter(bufferedSink, "sink");
        this.client = okHttpClient;
        this.connection = realConnection;
        this.source = bufferedSource;
        this.sink = bufferedSink;
        this.headersReader = new HeadersReader(this.source);
    }

    @Override
    @NotNull
    public RealConnection getConnection() {
        return this.connection;
    }

    private final boolean isChunked(Response response) {
        return StringsKt.equals("chunked", Response.header$default(response, "Transfer-Encoding", null, 2, null), true);
    }

    private final boolean isChunked(Request request) {
        return StringsKt.equals("chunked", request.header("Transfer-Encoding"), true);
    }

    public final boolean isClosed() {
        return this.state == 6;
    }

    @Override
    @NotNull
    public Sink createRequestBody(@NotNull Request request, long l) {
        Sink sink2;
        Intrinsics.checkNotNullParameter(request, "request");
        if (request.body() != null && request.body().isDuplex()) {
            throw new ProtocolException("Duplex connections are not supported for HTTP/1");
        }
        if (this.isChunked(request)) {
            sink2 = this.newChunkedSink();
        } else if (l != -1L) {
            sink2 = this.newKnownLengthSink();
        } else {
            throw new IllegalStateException("Cannot stream a request body without chunked encoding or a known content length!");
        }
        return sink2;
    }

    @Override
    public void cancel() {
        this.getConnection().cancel();
    }

    @Override
    public void writeRequestHeaders(@NotNull Request request) {
        Intrinsics.checkNotNullParameter(request, "request");
        Proxy.Type type = this.getConnection().route().proxy().type();
        Intrinsics.checkNotNullExpressionValue((Object)type, "connection.route().proxy.type()");
        String string = RequestLine.INSTANCE.get(request, type);
        this.writeRequest(request.headers(), string);
    }

    @Override
    public long reportedContentLength(@NotNull Response response) {
        Intrinsics.checkNotNullParameter(response, "response");
        return !HttpHeaders.promisesBody(response) ? 0L : (this.isChunked(response) ? -1L : Util.headersContentLength(response));
    }

    @Override
    @NotNull
    public Source openResponseBodySource(@NotNull Response response) {
        long l;
        Intrinsics.checkNotNullParameter(response, "response");
        return !HttpHeaders.promisesBody(response) ? this.newFixedLengthSource(0L) : (this.isChunked(response) ? this.newChunkedSource(response.request().url()) : ((l = Util.headersContentLength(response)) != -1L ? this.newFixedLengthSource(l) : this.newUnknownLengthSource()));
    }

    @Override
    @NotNull
    public Headers trailers() {
        if (!(this.state == 6)) {
            boolean bl = false;
            String string = "too early; can't read the trailers yet";
            throw new IllegalStateException(string.toString());
        }
        Headers headers = this.trailers;
        if (headers == null) {
            headers = Util.EMPTY_HEADERS;
        }
        return headers;
    }

    @Override
    public void flushRequest() {
        this.sink.flush();
    }

    @Override
    public void finishRequest() {
        this.sink.flush();
    }

    public final void writeRequest(@NotNull Headers headers, @NotNull String string) {
        Intrinsics.checkNotNullParameter(headers, "headers");
        Intrinsics.checkNotNullParameter(string, "requestLine");
        if (!(this.state == 0)) {
            boolean bl = false;
            String string2 = "state: " + this.state;
            throw new IllegalStateException(string2.toString());
        }
        this.sink.writeUtf8(string).writeUtf8("\r\n");
        int n = headers.size();
        for (int i = 0; i < n; ++i) {
            this.sink.writeUtf8(headers.name(i)).writeUtf8(": ").writeUtf8(headers.value(i)).writeUtf8("\r\n");
        }
        this.sink.writeUtf8("\r\n");
        this.state = 1;
    }

    @Override
    @Nullable
    public Response$Builder readResponseHeaders(boolean bl) {
        if (!(this.state == 1 || this.state == 2 || this.state == 3)) {
            boolean bl2 = false;
            String string = "state: " + this.state;
            throw new IllegalStateException(string.toString());
        }
        try {
            Response$Builder response$Builder;
            StatusLine statusLine = StatusLine.Companion.parse(this.headersReader.readLine());
            Response$Builder response$Builder2 = new Response$Builder().protocol(statusLine.protocol).code(statusLine.code).message(statusLine.message).headers(this.headersReader.readHeaders());
            if (bl && statusLine.code == 100) {
                response$Builder = null;
            } else if (statusLine.code == 100) {
                this.state = 3;
                response$Builder = response$Builder2;
            } else {
                int n = statusLine.code;
                boolean bl3 = 102 <= n ? n < 200 : false;
                if (bl3) {
                    this.state = 3;
                    response$Builder = response$Builder2;
                } else {
                    this.state = 4;
                    response$Builder = response$Builder2;
                }
            }
            return response$Builder;
        }
        catch (EOFException eOFException) {
            String string = this.getConnection().route().address().url().redact();
            throw new IOException("unexpected end of stream on " + string, eOFException);
        }
    }

    private final Sink newChunkedSink() {
        if (!(this.state == 1)) {
            boolean bl = false;
            String string = "state: " + this.state;
            throw new IllegalStateException(string.toString());
        }
        this.state = 2;
        return new Http1ExchangeCodec$ChunkedSink(this);
    }

    private final Sink newKnownLengthSink() {
        if (!(this.state == 1)) {
            boolean bl = false;
            String string = "state: " + this.state;
            throw new IllegalStateException(string.toString());
        }
        this.state = 2;
        return new Http1ExchangeCodec$KnownLengthSink(this);
    }

    private final Source newFixedLengthSource(long l) {
        if (!(this.state == 4)) {
            boolean bl = false;
            String string = "state: " + this.state;
            throw new IllegalStateException(string.toString());
        }
        this.state = 5;
        return new Http1ExchangeCodec$FixedLengthSource(this, l);
    }

    private final Source newChunkedSource(HttpUrl httpUrl) {
        if (!(this.state == 4)) {
            boolean bl = false;
            String string = "state: " + this.state;
            throw new IllegalStateException(string.toString());
        }
        this.state = 5;
        return new Http1ExchangeCodec$ChunkedSource(this, httpUrl);
    }

    private final Source newUnknownLengthSource() {
        if (!(this.state == 4)) {
            boolean bl = false;
            String string = "state: " + this.state;
            throw new IllegalStateException(string.toString());
        }
        this.state = 5;
        this.getConnection().noNewExchanges$okhttp();
        return new Http1ExchangeCodec$UnknownLengthSource(this);
    }

    private final void detachTimeout(ForwardingTimeout forwardingTimeout) {
        Timeout timeout2 = forwardingTimeout.delegate();
        forwardingTimeout.setDelegate(Timeout.NONE);
        timeout2.clearDeadline();
        timeout2.clearTimeout();
    }

    public final void skipConnectBody(@NotNull Response response) {
        Intrinsics.checkNotNullParameter(response, "response");
        long l = Util.headersContentLength(response);
        if (l == -1L) {
            return;
        }
        Source source2 = this.newFixedLengthSource(l);
        Util.skipAll(source2, Integer.MAX_VALUE, TimeUnit.MILLISECONDS);
        source2.close();
    }

    public static final /* synthetic */ BufferedSink access$getSink$p(Http1ExchangeCodec http1ExchangeCodec) {
        return http1ExchangeCodec.sink;
    }

    public static final /* synthetic */ void access$detachTimeout(Http1ExchangeCodec http1ExchangeCodec, ForwardingTimeout forwardingTimeout) {
        http1ExchangeCodec.detachTimeout(forwardingTimeout);
    }

    public static final /* synthetic */ void access$setState$p(Http1ExchangeCodec http1ExchangeCodec, int n) {
        http1ExchangeCodec.state = n;
    }

    public static final /* synthetic */ BufferedSource access$getSource$p(Http1ExchangeCodec http1ExchangeCodec) {
        return http1ExchangeCodec.source;
    }

    public static final /* synthetic */ int access$getState$p(Http1ExchangeCodec http1ExchangeCodec) {
        return http1ExchangeCodec.state;
    }

    public static final /* synthetic */ void access$setTrailers$p(Http1ExchangeCodec http1ExchangeCodec, Headers headers) {
        http1ExchangeCodec.trailers = headers;
    }

    public static final /* synthetic */ HeadersReader access$getHeadersReader$p(Http1ExchangeCodec http1ExchangeCodec) {
        return http1ExchangeCodec.headersReader;
    }

    public static final /* synthetic */ OkHttpClient access$getClient$p(Http1ExchangeCodec http1ExchangeCodec) {
        return http1ExchangeCodec.client;
    }

    public static final /* synthetic */ Headers access$getTrailers$p(Http1ExchangeCodec http1ExchangeCodec) {
        return http1ExchangeCodec.trailers;
    }
}

