/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.cache;

import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okhttp3.internal.Util;
import okhttp3.internal.cache.DiskLruCache$Companion;
import okhttp3.internal.cache.DiskLruCache$Editor;
import okhttp3.internal.cache.DiskLruCache$Entry;
import okhttp3.internal.cache.DiskLruCache$Snapshot;
import okhttp3.internal.cache.DiskLruCache$cleanupTask$1;
import okhttp3.internal.cache.DiskLruCache$newJournalWriter$faultHidingSink$1;
import okhttp3.internal.cache.DiskLruCache$snapshots$1;
import okhttp3.internal.cache.FaultHidingSink;
import okhttp3.internal.concurrent.TaskQueue;
import okhttp3.internal.concurrent.TaskRunner;
import okhttp3.internal.io.FileSystem;
import okhttp3.internal.platform.Platform;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000y\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010)\n\u0002\b\u0007*\u0001\u0014\u0018\u0000 [2\u00020\u00012\u00020\u0002:\u0004[\\]^B7\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u00108\u001a\u000209H\u0002J\b\u0010:\u001a\u000209H\u0016J!\u0010;\u001a\u0002092\n\u0010<\u001a\u00060=R\u00020\u00002\u0006\u0010>\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b?J\u0006\u0010@\u001a\u000209J \u0010A\u001a\b\u0018\u00010=R\u00020\u00002\u0006\u0010B\u001a\u00020(2\b\b\u0002\u0010C\u001a\u00020\u000bH\u0007J\u0006\u0010D\u001a\u000209J\b\u0010E\u001a\u000209H\u0016J\u0017\u0010F\u001a\b\u0018\u00010GR\u00020\u00002\u0006\u0010B\u001a\u00020(H\u0086\u0002J\u0006\u0010H\u001a\u000209J\u0006\u0010I\u001a\u00020\u0010J\b\u0010J\u001a\u00020\u0010H\u0002J\b\u0010K\u001a\u00020%H\u0002J\b\u0010L\u001a\u000209H\u0002J\b\u0010M\u001a\u000209H\u0002J\u0010\u0010N\u001a\u0002092\u0006\u0010O\u001a\u00020(H\u0002J\r\u0010P\u001a\u000209H\u0000\u00a2\u0006\u0002\bQJ\u000e\u0010R\u001a\u00020\u00102\u0006\u0010B\u001a\u00020(J\u0019\u0010S\u001a\u00020\u00102\n\u0010T\u001a\u00060)R\u00020\u0000H\u0000\u00a2\u0006\u0002\bUJ\b\u0010V\u001a\u00020\u0010H\u0002J\u0006\u00105\u001a\u00020\u000bJ\u0010\u0010W\u001a\f\u0012\b\u0012\u00060GR\u00020\u00000XJ\u0006\u0010Y\u001a\u000209J\u0010\u0010Z\u001a\u0002092\u0006\u0010B\u001a\u00020(H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0010X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010&\u001a\u0012\u0012\u0004\u0012\u00020(\u0012\b\u0012\u00060)R\u00020\u00000'X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R&\u0010\n\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020\u000b8F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u000e\u00101\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107\u00a8\u0006_"}, d2={"Lokhttp3/internal/cache/DiskLruCache;", "Ljava/io/Closeable;", "Ljava/io/Flushable;", "fileSystem", "Lokhttp3/internal/io/FileSystem;", "directory", "Ljava/io/File;", "appVersion", "", "valueCount", "maxSize", "", "taskRunner", "Lokhttp3/internal/concurrent/TaskRunner;", "(Lokhttp3/internal/io/FileSystem;Ljava/io/File;IIJLokhttp3/internal/concurrent/TaskRunner;)V", "civilizedFileSystem", "", "cleanupQueue", "Lokhttp3/internal/concurrent/TaskQueue;", "cleanupTask", "okhttp3/internal/cache/DiskLruCache$cleanupTask$1", "Lokhttp3/internal/cache/DiskLruCache$cleanupTask$1;", "closed", "getClosed$okhttp", "()Z", "setClosed$okhttp", "(Z)V", "getDirectory", "()Ljava/io/File;", "getFileSystem$okhttp", "()Lokhttp3/internal/io/FileSystem;", "hasJournalErrors", "initialized", "journalFile", "journalFileBackup", "journalFileTmp", "journalWriter", "Lokio/BufferedSink;", "lruEntries", "Ljava/util/LinkedHashMap;", "", "Lokhttp3/internal/cache/DiskLruCache$Entry;", "getLruEntries$okhttp", "()Ljava/util/LinkedHashMap;", "value", "getMaxSize", "()J", "setMaxSize", "(J)V", "mostRecentRebuildFailed", "mostRecentTrimFailed", "nextSequenceNumber", "redundantOpCount", "size", "getValueCount$okhttp", "()I", "checkNotClosed", "", "close", "completeEdit", "editor", "Lokhttp3/internal/cache/DiskLruCache$Editor;", "success", "completeEdit$okhttp", "delete", "edit", "key", "expectedSequenceNumber", "evictAll", "flush", "get", "Lokhttp3/internal/cache/DiskLruCache$Snapshot;", "initialize", "isClosed", "journalRebuildRequired", "newJournalWriter", "processJournal", "readJournal", "readJournalLine", "line", "rebuildJournal", "rebuildJournal$okhttp", "remove", "removeEntry", "entry", "removeEntry$okhttp", "removeOldestEntry", "snapshots", "", "trimToSize", "validateKey", "Companion", "Editor", "Entry", "Snapshot", "okhttp"})
@SourceDebugExtension(value={"SMAP\nDiskLruCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiskLruCache.kt\nokhttp3/internal/cache/DiskLruCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Util.kt\nokhttp3/internal/Util\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,1065:1\n1#2:1066\n608#3,4:1067\n37#4,2:1071\n37#4,2:1073\n*S KotlinDebug\n*F\n+ 1 DiskLruCache.kt\nokhttp3/internal/cache/DiskLruCache\n*L\n215#1:1067,4\n672#1:1071,2\n721#1:1073,2\n*E\n"})
public final class DiskLruCache
implements Closeable,
Flushable {
    @NotNull
    public static final DiskLruCache$Companion Companion = new DiskLruCache$Companion(null);
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final File directory;
    private final int appVersion;
    private final int valueCount;
    private long maxSize;
    @NotNull
    private final File journalFile;
    @NotNull
    private final File journalFileTmp;
    @NotNull
    private final File journalFileBackup;
    private long size;
    @Nullable
    private BufferedSink journalWriter;
    @NotNull
    private final LinkedHashMap<String, DiskLruCache$Entry> lruEntries;
    private int redundantOpCount;
    private boolean hasJournalErrors;
    private boolean civilizedFileSystem;
    private boolean initialized;
    private boolean closed;
    private boolean mostRecentTrimFailed;
    private boolean mostRecentRebuildFailed;
    private long nextSequenceNumber;
    @NotNull
    private final TaskQueue cleanupQueue;
    @NotNull
    private final DiskLruCache$cleanupTask$1 cleanupTask;
    @JvmField
    @NotNull
    public static final String JOURNAL_FILE = "journal";
    @JvmField
    @NotNull
    public static final String JOURNAL_FILE_TEMP = "journal.tmp";
    @JvmField
    @NotNull
    public static final String JOURNAL_FILE_BACKUP = "journal.bkp";
    @JvmField
    @NotNull
    public static final String MAGIC = "libcore.io.DiskLruCache";
    @JvmField
    @NotNull
    public static final String VERSION_1 = "1";
    @JvmField
    public static final long ANY_SEQUENCE_NUMBER = -1L;
    @JvmField
    @NotNull
    public static final Regex LEGAL_KEY_PATTERN = new Regex("[a-z0-9_-]{1,120}");
    @JvmField
    @NotNull
    public static final String CLEAN = "CLEAN";
    @JvmField
    @NotNull
    public static final String DIRTY = "DIRTY";
    @JvmField
    @NotNull
    public static final String REMOVE = "REMOVE";
    @JvmField
    @NotNull
    public static final String READ = "READ";

    public DiskLruCache(@NotNull FileSystem fileSystem, @NotNull File file, int n, int n2, long l, @NotNull TaskRunner taskRunner) {
        Intrinsics.checkNotNullParameter(fileSystem, "fileSystem");
        Intrinsics.checkNotNullParameter(file, "directory");
        Intrinsics.checkNotNullParameter(taskRunner, "taskRunner");
        this.fileSystem = fileSystem;
        this.directory = file;
        this.appVersion = n;
        this.valueCount = n2;
        this.maxSize = l;
        this.lruEntries = new LinkedHashMap(0, 0.75f, true);
        this.cleanupQueue = taskRunner.newQueue();
        String string = Util.okHttpName + " Cache";
        this.cleanupTask = new DiskLruCache$cleanupTask$1(this, string);
        if (!(l > 0L)) {
            boolean bl = false;
            String string2 = "maxSize <= 0";
            throw new IllegalArgumentException(string2.toString());
        }
        if (!(this.valueCount > 0)) {
            boolean bl = false;
            String string3 = "valueCount <= 0";
            throw new IllegalArgumentException(string3.toString());
        }
        this.journalFile = new File(this.directory, JOURNAL_FILE);
        this.journalFileTmp = new File(this.directory, JOURNAL_FILE_TEMP);
        this.journalFileBackup = new File(this.directory, JOURNAL_FILE_BACKUP);
    }

    @NotNull
    public final FileSystem getFileSystem$okhttp() {
        return this.fileSystem;
    }

    @NotNull
    public final File getDirectory() {
        return this.directory;
    }

    public final int getValueCount$okhttp() {
        return this.valueCount;
    }

    public final synchronized long getMaxSize() {
        return this.maxSize;
    }

    public final synchronized void setMaxSize(long l) {
        this.maxSize = l;
        if (this.initialized) {
            TaskQueue.schedule$default(this.cleanupQueue, this.cleanupTask, 0L, 2, null);
        }
    }

    @NotNull
    public final LinkedHashMap<String, DiskLruCache$Entry> getLruEntries$okhttp() {
        return this.lruEntries;
    }

    public final boolean getClosed$okhttp() {
        return this.closed;
    }

    public final void setClosed$okhttp(boolean bl) {
        this.closed = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void initialize() {
        DiskLruCache diskLruCache = this;
        boolean bl = false;
        if (Util.assertionsEnabled && !Thread.holdsLock(diskLruCache)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + diskLruCache));
        }
        if (this.initialized) {
            return;
        }
        if (this.fileSystem.exists(this.journalFileBackup)) {
            if (this.fileSystem.exists(this.journalFile)) {
                this.fileSystem.delete(this.journalFileBackup);
            } else {
                this.fileSystem.rename(this.journalFileBackup, this.journalFile);
            }
        }
        this.civilizedFileSystem = Util.isCivilized(this.fileSystem, this.journalFileBackup);
        if (this.fileSystem.exists(this.journalFile)) {
            try {
                this.readJournal();
                this.processJournal();
                this.initialized = true;
                return;
            }
            catch (IOException iOException) {
                Platform.Companion.get().log("DiskLruCache " + this.directory + " is corrupt: " + iOException.getMessage() + ", removing", 5, iOException);
                try {
                    this.delete();
                }
                finally {
                    this.closed = false;
                }
            }
        }
        this.rebuildJournal$okhttp();
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void readJournal() {
        Closeable closeable = Okio.buffer(this.fileSystem.source(this.journalFile));
        Throwable throwable = null;
        try {
            Object object = (BufferedSource)closeable;
            boolean bl = false;
            String string = object.readUtf8LineStrict();
            String string2 = object.readUtf8LineStrict();
            String string3 = object.readUtf8LineStrict();
            String string4 = object.readUtf8LineStrict();
            String string5 = object.readUtf8LineStrict();
            if (!Intrinsics.areEqual(MAGIC, string)) throw new IOException("unexpected journal header: [" + string + ", " + string2 + ", " + string4 + ", " + string5 + ']');
            if (!Intrinsics.areEqual(VERSION_1, string2)) throw new IOException("unexpected journal header: [" + string + ", " + string2 + ", " + string4 + ", " + string5 + ']');
            if (!Intrinsics.areEqual(String.valueOf(this.appVersion), string3)) throw new IOException("unexpected journal header: [" + string + ", " + string2 + ", " + string4 + ", " + string5 + ']');
            if (!Intrinsics.areEqual(String.valueOf(this.valueCount), string4)) throw new IOException("unexpected journal header: [" + string + ", " + string2 + ", " + string4 + ", " + string5 + ']');
            if (((CharSequence)string5).length() > 0) {
                throw new IOException("unexpected journal header: [" + string + ", " + string2 + ", " + string4 + ", " + string5 + ']');
            }
            int n = 0;
            try {
                while (true) {
                    this.readJournalLine(object.readUtf8LineStrict());
                    ++n;
                }
            }
            catch (EOFException eOFException) {
                this.redundantOpCount = n - this.lruEntries.size();
                if (!object.exhausted()) {
                    this.rebuildJournal$okhttp();
                } else {
                    this.journalWriter = this.newJournalWriter();
                }
                object = Unit.INSTANCE;
                return;
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    private final BufferedSink newJournalWriter() {
        Sink sink2 = this.fileSystem.appendingSink(this.journalFile);
        FaultHidingSink faultHidingSink2 = new FaultHidingSink(sink2, new DiskLruCache$newJournalWriter$faultHidingSink$1(this));
        return Okio.buffer(faultHidingSink2);
    }

    private final void readJournalLine(String string) {
        DiskLruCache$Entry diskLruCache$Entry;
        int n = StringsKt.indexOf$default((CharSequence)string, ' ', 0, false, 6, null);
        if (n == -1) {
            throw new IOException("unexpected journal line: " + string);
        }
        int n2 = n + 1;
        int n3 = StringsKt.indexOf$default((CharSequence)string, ' ', n2, false, 4, null);
        String string2 = null;
        if (n3 == -1) {
            String string3 = string.substring(n2);
            Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).substring(startIndex)");
            string2 = string3;
            if (n == REMOVE.length() && StringsKt.startsWith$default(string, REMOVE, false, 2, null)) {
                this.lruEntries.remove(string2);
                return;
            }
        } else {
            String string4 = string.substring(n2, n3);
            Intrinsics.checkNotNullExpressionValue(string4, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            string2 = string4;
        }
        if ((diskLruCache$Entry = this.lruEntries.get(string2)) == null) {
            diskLruCache$Entry = new DiskLruCache$Entry(this, string2);
            ((Map)this.lruEntries).put(string2, diskLruCache$Entry);
        }
        if (n3 != -1 && n == CLEAN.length() && StringsKt.startsWith$default(string, CLEAN, false, 2, null)) {
            String string5 = string.substring(n3 + 1);
            Intrinsics.checkNotNullExpressionValue(string5, "this as java.lang.String).substring(startIndex)");
            char[] cArray = new char[]{' '};
            List list = StringsKt.split$default((CharSequence)string5, cArray, false, 0, 6, null);
            diskLruCache$Entry.setReadable$okhttp(true);
            diskLruCache$Entry.setCurrentEditor$okhttp(null);
            diskLruCache$Entry.setLengths$okhttp(list);
        } else if (n3 == -1 && n == DIRTY.length() && StringsKt.startsWith$default(string, DIRTY, false, 2, null)) {
            diskLruCache$Entry.setCurrentEditor$okhttp(new DiskLruCache$Editor(this, diskLruCache$Entry));
        } else if (n3 != -1 || n != READ.length() || !StringsKt.startsWith$default(string, READ, false, 2, null)) {
            throw new IOException("unexpected journal line: " + string);
        }
    }

    private final void processJournal() {
        this.fileSystem.delete(this.journalFileTmp);
        Iterator<DiskLruCache$Entry> iterator2 = this.lruEntries.values().iterator();
        while (iterator2.hasNext()) {
            int n;
            int n2;
            DiskLruCache$Entry diskLruCache$Entry;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "i.next()");
            if (diskLruCache$Entry.getCurrentEditor$okhttp() == null) {
                n2 = this.valueCount;
                for (n = 0; n < n2; ++n) {
                    this.size += diskLruCache$Entry.getLengths$okhttp()[n];
                }
                continue;
            }
            diskLruCache$Entry.setCurrentEditor$okhttp(null);
            n2 = this.valueCount;
            for (n = 0; n < n2; ++n) {
                this.fileSystem.delete(diskLruCache$Entry.getCleanFiles$okhttp().get(n));
                this.fileSystem.delete(diskLruCache$Entry.getDirtyFiles$okhttp().get(n));
            }
            iterator2.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void rebuildJournal$okhttp() {
        BufferedSink bufferedSink = this.journalWriter;
        if (bufferedSink != null) {
            bufferedSink.close();
        }
        Closeable closeable = Okio.buffer(this.fileSystem.sink(this.journalFileTmp));
        Throwable throwable = null;
        try {
            Object object = (BufferedSink)closeable;
            boolean bl = false;
            object.writeUtf8(MAGIC).writeByte(10);
            object.writeUtf8(VERSION_1).writeByte(10);
            object.writeDecimalLong(this.appVersion).writeByte(10);
            object.writeDecimalLong(this.valueCount).writeByte(10);
            object.writeByte(10);
            for (DiskLruCache$Entry diskLruCache$Entry : this.lruEntries.values()) {
                if (diskLruCache$Entry.getCurrentEditor$okhttp() != null) {
                    object.writeUtf8(DIRTY).writeByte(32);
                    object.writeUtf8(diskLruCache$Entry.getKey$okhttp());
                    object.writeByte(10);
                    continue;
                }
                object.writeUtf8(CLEAN).writeByte(32);
                object.writeUtf8(diskLruCache$Entry.getKey$okhttp());
                diskLruCache$Entry.writeLengths$okhttp((BufferedSink)object);
                object.writeByte(10);
            }
            object = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        if (this.fileSystem.exists(this.journalFile)) {
            this.fileSystem.rename(this.journalFile, this.journalFileBackup);
        }
        this.fileSystem.rename(this.journalFileTmp, this.journalFile);
        this.fileSystem.delete(this.journalFileBackup);
        this.journalWriter = this.newJournalWriter();
        this.hasJournalErrors = false;
        this.mostRecentRebuildFailed = false;
    }

    @Nullable
    public final synchronized DiskLruCache$Snapshot get(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "key");
        this.initialize();
        this.checkNotClosed();
        this.validateKey(string);
        DiskLruCache$Entry diskLruCache$Entry = this.lruEntries.get(string);
        if (diskLruCache$Entry == null) {
            return null;
        }
        DiskLruCache$Entry diskLruCache$Entry2 = diskLruCache$Entry;
        DiskLruCache$Snapshot diskLruCache$Snapshot = diskLruCache$Entry2.snapshot$okhttp();
        if (diskLruCache$Snapshot == null) {
            return null;
        }
        DiskLruCache$Snapshot diskLruCache$Snapshot2 = diskLruCache$Snapshot;
        int n = this.redundantOpCount;
        this.redundantOpCount = n + 1;
        BufferedSink bufferedSink = this.journalWriter;
        Intrinsics.checkNotNull(bufferedSink);
        bufferedSink.writeUtf8(READ).writeByte(32).writeUtf8(string).writeByte(10);
        if (this.journalRebuildRequired()) {
            TaskQueue.schedule$default(this.cleanupQueue, this.cleanupTask, 0L, 2, null);
        }
        return diskLruCache$Snapshot2;
    }

    @JvmOverloads
    @Nullable
    public final synchronized DiskLruCache$Editor edit(@NotNull String string, long l) {
        Intrinsics.checkNotNullParameter(string, "key");
        this.initialize();
        this.checkNotClosed();
        this.validateKey(string);
        DiskLruCache$Entry diskLruCache$Entry = this.lruEntries.get(string);
        if (l != ANY_SEQUENCE_NUMBER && (diskLruCache$Entry == null || diskLruCache$Entry.getSequenceNumber$okhttp() != l)) {
            return null;
        }
        DiskLruCache$Entry diskLruCache$Entry2 = diskLruCache$Entry;
        if ((diskLruCache$Entry2 != null ? diskLruCache$Entry2.getCurrentEditor$okhttp() : null) != null) {
            return null;
        }
        if (diskLruCache$Entry != null && diskLruCache$Entry.getLockingSourceCount$okhttp() != 0) {
            return null;
        }
        if (this.mostRecentTrimFailed || this.mostRecentRebuildFailed) {
            TaskQueue.schedule$default(this.cleanupQueue, this.cleanupTask, 0L, 2, null);
            return null;
        }
        BufferedSink bufferedSink = this.journalWriter;
        Intrinsics.checkNotNull(bufferedSink);
        BufferedSink bufferedSink2 = bufferedSink;
        bufferedSink2.writeUtf8(DIRTY).writeByte(32).writeUtf8(string).writeByte(10);
        bufferedSink2.flush();
        if (this.hasJournalErrors) {
            return null;
        }
        if (diskLruCache$Entry == null) {
            diskLruCache$Entry = new DiskLruCache$Entry(this, string);
            ((Map)this.lruEntries).put(string, diskLruCache$Entry);
        }
        DiskLruCache$Editor diskLruCache$Editor = new DiskLruCache$Editor(this, diskLruCache$Entry);
        diskLruCache$Entry.setCurrentEditor$okhttp(diskLruCache$Editor);
        return diskLruCache$Editor;
    }

    public static /* synthetic */ DiskLruCache$Editor edit$default(DiskLruCache diskLruCache, String string, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = ANY_SEQUENCE_NUMBER;
        }
        return diskLruCache.edit(string, l);
    }

    public final synchronized long size() {
        this.initialize();
        return this.size;
    }

    public final synchronized void completeEdit$okhttp(@NotNull DiskLruCache$Editor diskLruCache$Editor, boolean bl) {
        BufferedSink bufferedSink;
        int n;
        int n2;
        Intrinsics.checkNotNullParameter(diskLruCache$Editor, "editor");
        DiskLruCache$Entry diskLruCache$Entry = diskLruCache$Editor.getEntry$okhttp();
        if (!Intrinsics.areEqual(diskLruCache$Entry.getCurrentEditor$okhttp(), diskLruCache$Editor)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        if (bl && !diskLruCache$Entry.getReadable$okhttp()) {
            n2 = this.valueCount;
            for (n = 0; n < n2; ++n) {
                boolean[] blArray = diskLruCache$Editor.getWritten$okhttp();
                Intrinsics.checkNotNull(blArray);
                if (!blArray[n]) {
                    diskLruCache$Editor.abort();
                    throw new IllegalStateException("Newly created entry didn't create value for index " + n);
                }
                if (this.fileSystem.exists(diskLruCache$Entry.getDirtyFiles$okhttp().get(n))) continue;
                diskLruCache$Editor.abort();
                return;
            }
        }
        n2 = this.valueCount;
        for (n = 0; n < n2; ++n) {
            File file = diskLruCache$Entry.getDirtyFiles$okhttp().get(n);
            if (bl && !diskLruCache$Entry.getZombie$okhttp()) {
                long l;
                if (!this.fileSystem.exists(file)) continue;
                File file2 = diskLruCache$Entry.getCleanFiles$okhttp().get(n);
                this.fileSystem.rename(file, file2);
                long l2 = diskLruCache$Entry.getLengths$okhttp()[n];
                diskLruCache$Entry.getLengths$okhttp()[n] = l = this.fileSystem.size(file2);
                this.size = this.size - l2 + l;
                continue;
            }
            this.fileSystem.delete(file);
        }
        diskLruCache$Entry.setCurrentEditor$okhttp(null);
        if (diskLruCache$Entry.getZombie$okhttp()) {
            this.removeEntry$okhttp(diskLruCache$Entry);
            return;
        }
        n = this.redundantOpCount;
        this.redundantOpCount = n + 1;
        BufferedSink bufferedSink2 = this.journalWriter;
        Intrinsics.checkNotNull(bufferedSink2);
        BufferedSink bufferedSink3 = bufferedSink = bufferedSink2;
        boolean bl2 = false;
        if (diskLruCache$Entry.getReadable$okhttp() || bl) {
            diskLruCache$Entry.setReadable$okhttp(true);
            bufferedSink3.writeUtf8(CLEAN).writeByte(32);
            bufferedSink3.writeUtf8(diskLruCache$Entry.getKey$okhttp());
            diskLruCache$Entry.writeLengths$okhttp(bufferedSink3);
            bufferedSink3.writeByte(10);
            if (bl) {
                long l = this.nextSequenceNumber;
                this.nextSequenceNumber = l + 1L;
                diskLruCache$Entry.setSequenceNumber$okhttp(l);
            }
        } else {
            this.lruEntries.remove(diskLruCache$Entry.getKey$okhttp());
            bufferedSink3.writeUtf8(REMOVE).writeByte(32);
            bufferedSink3.writeUtf8(diskLruCache$Entry.getKey$okhttp());
            bufferedSink3.writeByte(10);
        }
        bufferedSink3.flush();
        if (this.size > this.maxSize || this.journalRebuildRequired()) {
            TaskQueue.schedule$default(this.cleanupQueue, this.cleanupTask, 0L, 2, null);
        }
    }

    private final boolean journalRebuildRequired() {
        int n = 2000;
        return this.redundantOpCount >= n && this.redundantOpCount >= this.lruEntries.size();
    }

    public final synchronized boolean remove(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "key");
        this.initialize();
        this.checkNotClosed();
        this.validateKey(string);
        DiskLruCache$Entry diskLruCache$Entry = this.lruEntries.get(string);
        if (diskLruCache$Entry == null) {
            return false;
        }
        DiskLruCache$Entry diskLruCache$Entry2 = diskLruCache$Entry;
        boolean bl = this.removeEntry$okhttp(diskLruCache$Entry2);
        if (bl && this.size <= this.maxSize) {
            this.mostRecentTrimFailed = false;
        }
        return bl;
    }

    public final boolean removeEntry$okhttp(@NotNull DiskLruCache$Entry diskLruCache$Entry) {
        int n;
        boolean bl;
        BufferedSink bufferedSink;
        Intrinsics.checkNotNullParameter(diskLruCache$Entry, "entry");
        if (!this.civilizedFileSystem) {
            if (diskLruCache$Entry.getLockingSourceCount$okhttp() > 0) {
                BufferedSink bufferedSink2 = this.journalWriter;
                if (bufferedSink2 != null) {
                    bufferedSink = bufferedSink2;
                    bl = false;
                    bufferedSink.writeUtf8(DIRTY);
                    bufferedSink.writeByte(32);
                    bufferedSink.writeUtf8(diskLruCache$Entry.getKey$okhttp());
                    bufferedSink.writeByte(10);
                    bufferedSink.flush();
                }
            }
            if (diskLruCache$Entry.getLockingSourceCount$okhttp() > 0 || diskLruCache$Entry.getCurrentEditor$okhttp() != null) {
                diskLruCache$Entry.setZombie$okhttp(true);
                return true;
            }
        }
        DiskLruCache$Editor diskLruCache$Editor = diskLruCache$Entry.getCurrentEditor$okhttp();
        if (diskLruCache$Editor != null) {
            diskLruCache$Editor.detach$okhttp();
        }
        int n2 = this.valueCount;
        for (n = 0; n < n2; ++n) {
            this.fileSystem.delete(diskLruCache$Entry.getCleanFiles$okhttp().get(n));
            this.size -= diskLruCache$Entry.getLengths$okhttp()[n];
            diskLruCache$Entry.getLengths$okhttp()[n] = 0L;
        }
        n = this.redundantOpCount;
        this.redundantOpCount = n + 1;
        BufferedSink bufferedSink3 = this.journalWriter;
        if (bufferedSink3 != null) {
            bufferedSink = bufferedSink3;
            bl = false;
            bufferedSink.writeUtf8(REMOVE);
            bufferedSink.writeByte(32);
            bufferedSink.writeUtf8(diskLruCache$Entry.getKey$okhttp());
            bufferedSink.writeByte(10);
        }
        this.lruEntries.remove(diskLruCache$Entry.getKey$okhttp());
        if (this.journalRebuildRequired()) {
            TaskQueue.schedule$default(this.cleanupQueue, this.cleanupTask, 0L, 2, null);
        }
        return true;
    }

    private final synchronized void checkNotClosed() {
        if (!(!this.closed)) {
            boolean bl = false;
            String string = "cache is closed";
            throw new IllegalStateException(string.toString());
        }
    }

    @Override
    public synchronized void flush() {
        if (!this.initialized) {
            return;
        }
        this.checkNotClosed();
        this.trimToSize();
        BufferedSink bufferedSink = this.journalWriter;
        Intrinsics.checkNotNull(bufferedSink);
        bufferedSink.flush();
    }

    public final synchronized boolean isClosed() {
        return this.closed;
    }

    @Override
    public synchronized void close() {
        if (!this.initialized || this.closed) {
            this.closed = true;
            return;
        }
        Collection<DiskLruCache$Entry> collection = this.lruEntries.values();
        Intrinsics.checkNotNullExpressionValue(collection, "lruEntries.values");
        Collection<DiskLruCache$Entry> collection2 = collection;
        int n = 0;
        Collection<DiskLruCache$Entry> object2 = collection2;
        for (DiskLruCache$Entry diskLruCache$Entry : object2.toArray(new DiskLruCache$Entry[0])) {
            if (diskLruCache$Entry.getCurrentEditor$okhttp() == null) continue;
            DiskLruCache$Editor diskLruCache$Editor = diskLruCache$Entry.getCurrentEditor$okhttp();
            if (diskLruCache$Editor == null) continue;
            diskLruCache$Editor.detach$okhttp();
        }
        this.trimToSize();
        BufferedSink bufferedSink = this.journalWriter;
        Intrinsics.checkNotNull(bufferedSink);
        bufferedSink.close();
        this.journalWriter = null;
        this.closed = true;
    }

    public final void trimToSize() {
        while (this.size > this.maxSize) {
            if (this.removeOldestEntry()) continue;
            return;
        }
        this.mostRecentTrimFailed = false;
    }

    private final boolean removeOldestEntry() {
        for (DiskLruCache$Entry diskLruCache$Entry : this.lruEntries.values()) {
            if (diskLruCache$Entry.getZombie$okhttp()) continue;
            Intrinsics.checkNotNullExpressionValue(diskLruCache$Entry, "toEvict");
            this.removeEntry$okhttp(diskLruCache$Entry);
            return true;
        }
        return false;
    }

    public final void delete() {
        this.close();
        this.fileSystem.deleteContents(this.directory);
    }

    public final synchronized void evictAll() {
        this.initialize();
        Collection<DiskLruCache$Entry> collection = this.lruEntries.values();
        Intrinsics.checkNotNullExpressionValue(collection, "lruEntries.values");
        Collection<DiskLruCache$Entry> collection2 = collection;
        int n = 0;
        Collection<DiskLruCache$Entry> object2 = collection2;
        for (DiskLruCache$Entry diskLruCache$Entry : object2.toArray(new DiskLruCache$Entry[0])) {
            Intrinsics.checkNotNullExpressionValue(diskLruCache$Entry, "entry");
            this.removeEntry$okhttp(diskLruCache$Entry);
        }
        this.mostRecentTrimFailed = false;
    }

    private final void validateKey(String string) {
        if (!LEGAL_KEY_PATTERN.matches(string)) {
            boolean bl = false;
            String string2 = "keys must match regex [a-z0-9_-]{1,120}: \"" + string + '\"';
            throw new IllegalArgumentException(string2.toString());
        }
    }

    @NotNull
    public final synchronized Iterator<DiskLruCache$Snapshot> snapshots() {
        this.initialize();
        return new DiskLruCache$snapshots$1(this);
    }

    @JvmOverloads
    @Nullable
    public final DiskLruCache$Editor edit(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "key");
        return DiskLruCache.edit$default(this, string, 0L, 2, null);
    }

    public static final /* synthetic */ void access$setHasJournalErrors$p(DiskLruCache diskLruCache, boolean bl) {
        diskLruCache.hasJournalErrors = bl;
    }

    public static final /* synthetic */ boolean access$getCivilizedFileSystem$p(DiskLruCache diskLruCache) {
        return diskLruCache.civilizedFileSystem;
    }

    public static final /* synthetic */ boolean access$getInitialized$p(DiskLruCache diskLruCache) {
        return diskLruCache.initialized;
    }

    public static final /* synthetic */ void access$setMostRecentTrimFailed$p(DiskLruCache diskLruCache, boolean bl) {
        diskLruCache.mostRecentTrimFailed = bl;
    }

    public static final /* synthetic */ boolean access$journalRebuildRequired(DiskLruCache diskLruCache) {
        return diskLruCache.journalRebuildRequired();
    }

    public static final /* synthetic */ void access$setRedundantOpCount$p(DiskLruCache diskLruCache, int n) {
        diskLruCache.redundantOpCount = n;
    }

    public static final /* synthetic */ void access$setMostRecentRebuildFailed$p(DiskLruCache diskLruCache, boolean bl) {
        diskLruCache.mostRecentRebuildFailed = bl;
    }

    public static final /* synthetic */ void access$setJournalWriter$p(DiskLruCache diskLruCache, BufferedSink bufferedSink) {
        diskLruCache.journalWriter = bufferedSink;
    }
}

