/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.cache;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Cache;
import okhttp3.Call;
import okhttp3.EventListener;
import okhttp3.Interceptor;
import okhttp3.Interceptor$Chain;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Response$Builder;
import okhttp3.ResponseBody;
import okhttp3.internal.Util;
import okhttp3.internal.cache.CacheInterceptor$Companion;
import okhttp3.internal.cache.CacheInterceptor$cacheWritingResponse$cacheWritingSource$1;
import okhttp3.internal.cache.CacheRequest;
import okhttp3.internal.cache.CacheStrategy;
import okhttp3.internal.cache.CacheStrategy$Factory;
import okhttp3.internal.connection.RealCall;
import okhttp3.internal.http.HttpHeaders;
import okhttp3.internal.http.HttpMethod;
import okhttp3.internal.http.RealResponseBody;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\bH\u0002J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lokhttp3/internal/cache/CacheInterceptor;", "Lokhttp3/Interceptor;", "cache", "Lokhttp3/Cache;", "(Lokhttp3/Cache;)V", "getCache$okhttp", "()Lokhttp3/Cache;", "cacheWritingResponse", "Lokhttp3/Response;", "cacheRequest", "Lokhttp3/internal/cache/CacheRequest;", "response", "intercept", "chain", "Lokhttp3/Interceptor$Chain;", "Companion", "okhttp"})
public final class CacheInterceptor
implements Interceptor {
    @NotNull
    public static final CacheInterceptor$Companion Companion = new CacheInterceptor$Companion(null);
    @Nullable
    private final Cache cache;

    public CacheInterceptor(@Nullable Cache cache) {
        this.cache = cache;
    }

    @Nullable
    public final Cache getCache$okhttp() {
        return this.cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Response intercept(@NotNull Interceptor$Chain interceptor$Chain) {
        Response response;
        Object object;
        Response response2;
        Request request;
        Call call;
        block23: {
            ResponseBody responseBody;
            Object object2;
            Intrinsics.checkNotNullParameter(interceptor$Chain, "chain");
            call = interceptor$Chain.call();
            Cache cache = this.cache;
            Response response3 = cache != null ? cache.get$okhttp(interceptor$Chain.request()) : null;
            long l = System.currentTimeMillis();
            CacheStrategy cacheStrategy = new CacheStrategy$Factory(l, interceptor$Chain.request(), response3).compute();
            request = cacheStrategy.getNetworkRequest();
            response2 = cacheStrategy.getCacheResponse();
            Cache cache2 = this.cache;
            if (cache2 != null) {
                cache2.trackResponse$okhttp(cacheStrategy);
            }
            if ((object2 = call instanceof RealCall ? (RealCall)call : null) == null || (object2 = ((RealCall)object2).getEventListener$okhttp()) == null) {
                object2 = object = EventListener.NONE;
            }
            if (response3 != null && response2 == null) {
                ResponseBody responseBody2 = response3.body();
                if (responseBody2 != null) {
                    Util.closeQuietly(responseBody2);
                }
            }
            if (request == null && response2 == null) {
                Response response4;
                Response response5 = response4 = new Response$Builder().request(interceptor$Chain.request()).protocol(Protocol.HTTP_1_1).code(504).message("Unsatisfiable Request (only-if-cached)").body(Util.EMPTY_RESPONSE).sentRequestAtMillis(-1L).receivedResponseAtMillis(System.currentTimeMillis()).build();
                boolean bl = false;
                ((EventListener)object).satisfactionFailure(call, response5);
                return response4;
            }
            if (request == null) {
                Response response6;
                Response response7 = response2;
                Intrinsics.checkNotNull(response7);
                Response response8 = response6 = response7.newBuilder().cacheResponse(CacheInterceptor$Companion.access$stripBody(Companion, response2)).build();
                boolean bl = false;
                ((EventListener)object).cacheHit(call, response8);
                return response6;
            }
            if (response2 != null) {
                ((EventListener)object).cacheConditionalHit(call, response2);
            } else if (this.cache != null) {
                ((EventListener)object).cacheMiss(call);
            }
            response = null;
            try {
                response = interceptor$Chain.proceed(request);
                if (response != null || response3 == null) break block23;
                responseBody = response3.body();
            }
            catch (Throwable throwable) {
                if (response3 != null) {
                    ResponseBody responseBody3 = response3.body();
                    if (responseBody3 != null) {
                        Util.closeQuietly(responseBody3);
                    }
                }
                throw throwable;
            }
            if (responseBody != null) {
                Util.closeQuietly(responseBody);
            }
        }
        if (response2 != null) {
            Response response9 = response;
            boolean bl = response9 != null ? response9.code() == 304 : false;
            if (bl) {
                Response response10;
                Response response11 = response2.newBuilder().headers(CacheInterceptor$Companion.access$combine(Companion, response2.headers(), response.headers())).sentRequestAtMillis(response.sentRequestAtMillis()).receivedResponseAtMillis(response.receivedResponseAtMillis()).cacheResponse(CacheInterceptor$Companion.access$stripBody(Companion, response2)).networkResponse(CacheInterceptor$Companion.access$stripBody(Companion, response)).build();
                ResponseBody responseBody = response.body();
                Intrinsics.checkNotNull(responseBody);
                responseBody.close();
                Cache cache = this.cache;
                Intrinsics.checkNotNull(cache);
                cache.trackConditionalCacheHit$okhttp();
                this.cache.update$okhttp(response2, response11);
                Response response12 = response10 = response11;
                boolean bl2 = false;
                ((EventListener)object).cacheHit(call, response12);
                return response10;
            }
            ResponseBody responseBody = response2.body();
            if (responseBody != null) {
                Util.closeQuietly(responseBody);
            }
        }
        Response response13 = response;
        Intrinsics.checkNotNull(response13);
        Response response14 = response13.newBuilder().cacheResponse(CacheInterceptor$Companion.access$stripBody(Companion, response2)).networkResponse(CacheInterceptor$Companion.access$stripBody(Companion, response)).build();
        if (this.cache != null) {
            if (HttpHeaders.promisesBody(response14) && CacheStrategy.Companion.isCacheable(response14, request)) {
                Response response15;
                CacheRequest cacheRequest = this.cache.put$okhttp(response14);
                Response response16 = response15 = this.cacheWritingResponse(cacheRequest, response14);
                boolean bl = false;
                if (response2 != null) {
                    ((EventListener)object).cacheMiss(call);
                }
                return response15;
            }
            if (HttpMethod.INSTANCE.invalidatesCache(request.method())) {
                try {
                    this.cache.remove$okhttp(request);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return response14;
    }

    private final Response cacheWritingResponse(CacheRequest cacheRequest, Response response) {
        if (cacheRequest == null) {
            return response;
        }
        Sink sink2 = cacheRequest.body();
        ResponseBody responseBody = response.body();
        Intrinsics.checkNotNull(responseBody);
        BufferedSource bufferedSource = responseBody.source();
        BufferedSink bufferedSink = Okio.buffer(sink2);
        CacheInterceptor$cacheWritingResponse$cacheWritingSource$1 cacheInterceptor$cacheWritingResponse$cacheWritingSource$1 = new CacheInterceptor$cacheWritingResponse$cacheWritingSource$1(bufferedSource, cacheRequest, bufferedSink);
        String string = Response.header$default(response, "Content-Type", null, 2, null);
        long l = response.body().contentLength();
        return response.newBuilder().body(new RealResponseBody(string, l, Okio.buffer(cacheInterceptor$cacheWritingResponse$cacheWritingSource$1))).build();
    }
}

