/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.authenticator;

import java.net.Authenticator;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.SocketAddress;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Address;
import okhttp3.Authenticator;
import okhttp3.Challenge;
import okhttp3.Credentials;
import okhttp3.Dns;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import okhttp3.internal.authenticator.JavaNetAuthenticator$WhenMappings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001c\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lokhttp3/internal/authenticator/JavaNetAuthenticator;", "Lokhttp3/Authenticator;", "defaultDns", "Lokhttp3/Dns;", "(Lokhttp3/Dns;)V", "authenticate", "Lokhttp3/Request;", "route", "Lokhttp3/Route;", "response", "Lokhttp3/Response;", "connectToInetAddress", "Ljava/net/InetAddress;", "Ljava/net/Proxy;", "url", "Lokhttp3/HttpUrl;", "dns", "okhttp"})
public final class JavaNetAuthenticator
implements Authenticator {
    @NotNull
    private final Dns defaultDns;

    public JavaNetAuthenticator(@NotNull Dns dns) {
        Intrinsics.checkNotNullParameter(dns, "defaultDns");
        this.defaultDns = dns;
    }

    public /* synthetic */ JavaNetAuthenticator(Dns dns, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            dns = Dns.SYSTEM;
        }
        this(dns);
    }

    @Override
    @Nullable
    public Request authenticate(@Nullable Route route, @NotNull Response response) {
        Intrinsics.checkNotNullParameter(response, "response");
        List<Challenge> list = response.challenges();
        Request request = response.request();
        HttpUrl httpUrl = request.url();
        boolean bl = response.code() == 407;
        Object object = route;
        if (object == null || (object = ((Route)object).proxy()) == null) {
            object = Proxy.NO_PROXY;
        }
        Object object2 = object;
        for (Challenge challenge : list) {
            PasswordAuthentication passwordAuthentication;
            PasswordAuthentication passwordAuthentication2;
            Object object3;
            Object object4;
            if (!StringsKt.equals("Basic", challenge.scheme(), true)) continue;
            Object object5 = route;
            if (object5 == null || (object5 = ((Route)object5).address()) == null || (object5 = ((Address)object5).dns()) == null) {
                object5 = object4 = this.defaultDns;
            }
            if (bl) {
                SocketAddress socketAddress = ((Proxy)object2).address();
                Intrinsics.checkNotNull(socketAddress, "null cannot be cast to non-null type java.net.InetSocketAddress");
                object3 = (InetSocketAddress)socketAddress;
                String string = ((InetSocketAddress)object3).getHostName();
                Intrinsics.checkNotNullExpressionValue(object2, "proxy");
                passwordAuthentication2 = java.net.Authenticator.requestPasswordAuthentication(string, this.connectToInetAddress((Proxy)object2, httpUrl, (Dns)object4), ((InetSocketAddress)object3).getPort(), httpUrl.scheme(), challenge.realm(), challenge.scheme(), httpUrl.url(), Authenticator.RequestorType.PROXY);
            } else {
                String string = httpUrl.host();
                Intrinsics.checkNotNullExpressionValue(object2, "proxy");
                passwordAuthentication2 = java.net.Authenticator.requestPasswordAuthentication(string, this.connectToInetAddress((Proxy)object2, httpUrl, (Dns)object4), httpUrl.port(), httpUrl.scheme(), challenge.realm(), challenge.scheme(), httpUrl.url(), Authenticator.RequestorType.SERVER);
            }
            if ((passwordAuthentication = passwordAuthentication2) == null) continue;
            object3 = bl ? "Proxy-Authorization" : "Authorization";
            String string = passwordAuthentication.getUserName();
            Intrinsics.checkNotNullExpressionValue(string, "auth.userName");
            char[] cArray = passwordAuthentication.getPassword();
            Intrinsics.checkNotNullExpressionValue(cArray, "auth.password");
            char[] cArray2 = cArray;
            String string2 = Credentials.basic(string, new String(cArray2), challenge.charset());
            return request.newBuilder().header((String)object3, string2).build();
        }
        return null;
    }

    private final InetAddress connectToInetAddress(Proxy proxy, HttpUrl httpUrl, Dns dns) {
        InetAddress inetAddress;
        Proxy.Type type = proxy.type();
        if ((type == null ? -1 : JavaNetAuthenticator$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) == 1) {
            inetAddress = CollectionsKt.first(dns.lookup(httpUrl.host()));
        } else {
            SocketAddress socketAddress = proxy.address();
            Intrinsics.checkNotNull(socketAddress, "null cannot be cast to non-null type java.net.InetSocketAddress");
            InetAddress inetAddress2 = ((InetSocketAddress)socketAddress).getAddress();
            inetAddress = inetAddress2;
            Intrinsics.checkNotNullExpressionValue(inetAddress2, "address() as InetSocketAddress).address");
        }
        return inetAddress;
    }

    public JavaNetAuthenticator() {
        this(null, 1, null);
    }
}

