/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.MultipartBody$Part;
import okhttp3.RequestBody;
import okhttp3.internal.Util;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003J \u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u00020\u00002\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\bJ\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lokhttp3/MultipartBody$Builder;", "", "boundary", "", "(Ljava/lang/String;)V", "Lokio/ByteString;", "parts", "", "Lokhttp3/MultipartBody$Part;", "type", "Lokhttp3/MediaType;", "addFormDataPart", "name", "value", "filename", "body", "Lokhttp3/RequestBody;", "addPart", "headers", "Lokhttp3/Headers;", "part", "build", "Lokhttp3/MultipartBody;", "setType", "okhttp"})
@SourceDebugExtension(value={"SMAP\nMultipartBody.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultipartBody.kt\nokhttp3/MultipartBody$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,345:1\n1#2:346\n*E\n"})
public final class MultipartBody$Builder {
    @NotNull
    private final ByteString boundary;
    @NotNull
    private MediaType type;
    @NotNull
    private final List<MultipartBody$Part> parts;

    @JvmOverloads
    public MultipartBody$Builder(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "boundary");
        this.boundary = ByteString.Companion.encodeUtf8(string);
        this.type = MultipartBody.MIXED;
        this.parts = new ArrayList();
    }

    public /* synthetic */ MultipartBody$Builder(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            String string2 = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue(string2, "randomUUID().toString()");
            string = string2;
        }
        this(string);
    }

    @NotNull
    public final MultipartBody$Builder setType(@NotNull MediaType mediaType) {
        MultipartBody$Builder multipartBody$Builder;
        Intrinsics.checkNotNullParameter(mediaType, "type");
        MultipartBody$Builder multipartBody$Builder2 = multipartBody$Builder = this;
        boolean bl = false;
        if (!Intrinsics.areEqual(mediaType.type(), "multipart")) {
            boolean bl2 = false;
            String string = "multipart != " + mediaType;
            throw new IllegalArgumentException(string.toString());
        }
        multipartBody$Builder2.type = mediaType;
        return multipartBody$Builder;
    }

    @NotNull
    public final MultipartBody$Builder addPart(@NotNull RequestBody requestBody) {
        MultipartBody$Builder multipartBody$Builder;
        Intrinsics.checkNotNullParameter(requestBody, "body");
        MultipartBody$Builder multipartBody$Builder2 = multipartBody$Builder = this;
        boolean bl = false;
        multipartBody$Builder2.addPart(MultipartBody$Part.Companion.create(requestBody));
        return multipartBody$Builder;
    }

    @NotNull
    public final MultipartBody$Builder addPart(@Nullable Headers headers, @NotNull RequestBody requestBody) {
        MultipartBody$Builder multipartBody$Builder;
        Intrinsics.checkNotNullParameter(requestBody, "body");
        MultipartBody$Builder multipartBody$Builder2 = multipartBody$Builder = this;
        boolean bl = false;
        multipartBody$Builder2.addPart(MultipartBody$Part.Companion.create(headers, requestBody));
        return multipartBody$Builder;
    }

    @NotNull
    public final MultipartBody$Builder addFormDataPart(@NotNull String string, @NotNull String string2) {
        MultipartBody$Builder multipartBody$Builder;
        Intrinsics.checkNotNullParameter(string, "name");
        Intrinsics.checkNotNullParameter(string2, "value");
        MultipartBody$Builder multipartBody$Builder2 = multipartBody$Builder = this;
        boolean bl = false;
        multipartBody$Builder2.addPart(MultipartBody$Part.Companion.createFormData(string, string2));
        return multipartBody$Builder;
    }

    @NotNull
    public final MultipartBody$Builder addFormDataPart(@NotNull String string, @Nullable String string2, @NotNull RequestBody requestBody) {
        MultipartBody$Builder multipartBody$Builder;
        Intrinsics.checkNotNullParameter(string, "name");
        Intrinsics.checkNotNullParameter(requestBody, "body");
        MultipartBody$Builder multipartBody$Builder2 = multipartBody$Builder = this;
        boolean bl = false;
        multipartBody$Builder2.addPart(MultipartBody$Part.Companion.createFormData(string, string2, requestBody));
        return multipartBody$Builder;
    }

    @NotNull
    public final MultipartBody$Builder addPart(@NotNull MultipartBody$Part multipartBody$Part) {
        MultipartBody$Builder multipartBody$Builder;
        Intrinsics.checkNotNullParameter(multipartBody$Part, "part");
        MultipartBody$Builder multipartBody$Builder2 = multipartBody$Builder = this;
        boolean bl = false;
        ((Collection)multipartBody$Builder2.parts).add(multipartBody$Part);
        return multipartBody$Builder;
    }

    @NotNull
    public final MultipartBody build() {
        if (!(!((Collection)this.parts).isEmpty())) {
            boolean bl = false;
            String string = "Multipart body must have at least one part.";
            throw new IllegalStateException(string.toString());
        }
        return new MultipartBody(this.boundary, this.type, Util.toImmutableList(this.parts));
    }

    @JvmOverloads
    public MultipartBody$Builder() {
        this(null, 1, null);
    }
}

