/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLPeerUnverifiedException;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import okhttp3.CertificatePinner$Builder;
import okhttp3.CertificatePinner$Companion;
import okhttp3.CertificatePinner$Pin;
import okhttp3.CertificatePinner$check$1;
import okhttp3.internal.tls.CertificateChainCleaner;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 \"2\u00020\u0001:\u0003!\"#B!\b\u0000\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J)\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u0011H\u0000\u00a2\u0006\u0002\b\u0014J)\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0016\"\u00020\u0017H\u0007\u00a2\u0006\u0002\u0010\u0018J\u001c\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0012J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\u00122\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0015\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006$"}, d2={"Lokhttp3/CertificatePinner;", "", "pins", "", "Lokhttp3/CertificatePinner$Pin;", "certificateChainCleaner", "Lokhttp3/internal/tls/CertificateChainCleaner;", "(Ljava/util/Set;Lokhttp3/internal/tls/CertificateChainCleaner;)V", "getCertificateChainCleaner$okhttp", "()Lokhttp3/internal/tls/CertificateChainCleaner;", "getPins", "()Ljava/util/Set;", "check", "", "hostname", "", "cleanedPeerCertificatesFn", "Lkotlin/Function0;", "", "Ljava/security/cert/X509Certificate;", "check$okhttp", "peerCertificates", "", "Ljava/security/cert/Certificate;", "(Ljava/lang/String;[Ljava/security/cert/Certificate;)V", "equals", "", "other", "findMatchingPins", "hashCode", "", "withCertificateChainCleaner", "withCertificateChainCleaner$okhttp", "Builder", "Companion", "Pin", "okhttp"})
@SourceDebugExtension(value={"SMAP\nCertificatePinner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CertificatePinner.kt\nokhttp3/CertificatePinner\n+ 2 Util.kt\nokhttp3/internal/Util\n*L\n1#1,370:1\n625#2,8:371\n*S KotlinDebug\n*F\n+ 1 CertificatePinner.kt\nokhttp3/CertificatePinner\n*L\n216#1:371,8\n*E\n"})
public final class CertificatePinner {
    @NotNull
    public static final CertificatePinner$Companion Companion = new CertificatePinner$Companion(null);
    @NotNull
    private final Set<CertificatePinner$Pin> pins;
    @Nullable
    private final CertificateChainCleaner certificateChainCleaner;
    @JvmField
    @NotNull
    public static final CertificatePinner DEFAULT = new CertificatePinner$Builder().build();

    public CertificatePinner(@NotNull Set<CertificatePinner$Pin> set, @Nullable CertificateChainCleaner certificateChainCleaner) {
        Intrinsics.checkNotNullParameter(set, "pins");
        this.pins = set;
        this.certificateChainCleaner = certificateChainCleaner;
    }

    public /* synthetic */ CertificatePinner(Set set, CertificateChainCleaner certificateChainCleaner, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            certificateChainCleaner = null;
        }
        this(set, certificateChainCleaner);
    }

    @NotNull
    public final Set<CertificatePinner$Pin> getPins() {
        return this.pins;
    }

    @Nullable
    public final CertificateChainCleaner getCertificateChainCleaner$okhttp() {
        return this.certificateChainCleaner;
    }

    public final void check(@NotNull String string, @NotNull List<? extends Certificate> list) {
        Intrinsics.checkNotNullParameter(string, "hostname");
        Intrinsics.checkNotNullParameter(list, "peerCertificates");
        this.check$okhttp(string, new CertificatePinner$check$1(this, list, string));
    }

    public final void check$okhttp(@NotNull String string, @NotNull Function0<? extends List<? extends X509Certificate>> function0) {
        Comparable<StringBuilder> comparable;
        Intrinsics.checkNotNullParameter(string, "hostname");
        Intrinsics.checkNotNullParameter(function0, "cleanedPeerCertificatesFn");
        List<CertificatePinner$Pin> list = this.findMatchingPins(string);
        if (list.isEmpty()) {
            return;
        }
        List<? extends X509Certificate> list2 = function0.invoke();
        for (X509Certificate serializable22 : list2) {
            comparable = null;
            ByteString bl = null;
            for (CertificatePinner$Pin certificatePinner$Pin : list) {
                String string2 = certificatePinner$Pin.getHashAlgorithm();
                if (Intrinsics.areEqual(string2, "sha256")) {
                    if (bl == null) {
                        bl = Companion.sha256Hash(serializable22);
                    }
                    if (!Intrinsics.areEqual(certificatePinner$Pin.getHash(), bl)) continue;
                    return;
                }
                if (Intrinsics.areEqual(string2, "sha1")) {
                    if (comparable == null) {
                        comparable = Companion.sha1Hash(serializable22);
                    }
                    if (!Intrinsics.areEqual(certificatePinner$Pin.getHash(), comparable)) continue;
                    return;
                }
                throw new AssertionError((Object)("unsupported hashAlgorithm: " + certificatePinner$Pin.getHashAlgorithm()));
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        comparable = stringBuilder;
        boolean bl = false;
        ((StringBuilder)comparable).append("Certificate pinning failure!");
        ((StringBuilder)comparable).append("\n  Peer certificate chain:");
        for (X509Certificate x509Certificate : list2) {
            ((StringBuilder)comparable).append("\n    ");
            ((StringBuilder)comparable).append(Companion.pin(x509Certificate));
            ((StringBuilder)comparable).append(": ");
            ((StringBuilder)comparable).append(x509Certificate.getSubjectDN().getName());
        }
        ((StringBuilder)comparable).append("\n  Pinned certificates for ");
        ((StringBuilder)comparable).append(string);
        ((StringBuilder)comparable).append(":");
        for (CertificatePinner$Pin certificatePinner$Pin : list) {
            ((StringBuilder)comparable).append("\n    ");
            ((StringBuilder)comparable).append(certificatePinner$Pin);
        }
        String string3 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string3, "StringBuilder().apply(builderAction).toString()");
        String string4 = string3;
        throw new SSLPeerUnverifiedException(string4);
    }

    @Deprecated(message="replaced with {@link #check(String, List)}.", replaceWith=@ReplaceWith(expression="check(hostname, peerCertificates.toList())", imports={}))
    public final void check(@NotNull String string, Certificate ... certificateArray) {
        Intrinsics.checkNotNullParameter(string, "hostname");
        Intrinsics.checkNotNullParameter(certificateArray, "peerCertificates");
        this.check(string, ArraysKt.toList(certificateArray));
    }

    @NotNull
    public final List<CertificatePinner$Pin> findMatchingPins(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "hostname");
        Iterable iterable = this.pins;
        boolean bl = false;
        List list = CollectionsKt.emptyList();
        for (Object t : iterable) {
            CertificatePinner$Pin certificatePinner$Pin = (CertificatePinner$Pin)t;
            boolean bl2 = false;
            if (!certificatePinner$Pin.matchesHostname(string)) continue;
            if (list.isEmpty()) {
                list = new ArrayList();
            }
            List list2 = list;
            Intrinsics.checkNotNull(list2, "null cannot be cast to non-null type kotlin.collections.MutableList<T of okhttp3.internal.Util.filterList>");
            TypeIntrinsics.asMutableList(list2).add(t);
        }
        return list;
    }

    @NotNull
    public final CertificatePinner withCertificateChainCleaner$okhttp(@NotNull CertificateChainCleaner certificateChainCleaner) {
        Intrinsics.checkNotNullParameter(certificateChainCleaner, "certificateChainCleaner");
        return Intrinsics.areEqual(this.certificateChainCleaner, certificateChainCleaner) ? this : new CertificatePinner(this.pins, certificateChainCleaner);
    }

    public boolean equals(@Nullable Object object) {
        return object instanceof CertificatePinner && Intrinsics.areEqual(((CertificatePinner)object).pins, this.pins) && Intrinsics.areEqual(((CertificatePinner)object).certificateChainCleaner, this.certificateChainCleaner);
    }

    public int hashCode() {
        int n = 37;
        n = 41 * n + ((Object)this.pins).hashCode();
        CertificateChainCleaner certificateChainCleaner = this.certificateChainCleaner;
        n = 41 * n + (certificateChainCleaner != null ? certificateChainCleaner.hashCode() : 0);
        return n;
    }

    @JvmStatic
    @NotNull
    public static final ByteString sha1Hash(@NotNull X509Certificate x509Certificate) {
        return Companion.sha1Hash(x509Certificate);
    }

    @JvmStatic
    @NotNull
    public static final ByteString sha256Hash(@NotNull X509Certificate x509Certificate) {
        return Companion.sha256Hash(x509Certificate);
    }

    @JvmStatic
    @NotNull
    public static final String pin(@NotNull Certificate certificate) {
        return Companion.pin(certificate);
    }
}

