/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.security.cert.X509Certificate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.CertificatePinner;
import okhttp3.internal.HostnamesKt;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0003J\b\u0010\u0018\u001a\u00020\u0003H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0019"}, d2={"Lokhttp3/CertificatePinner$Pin;", "", "pattern", "", "pin", "(Ljava/lang/String;Ljava/lang/String;)V", "hash", "Lokio/ByteString;", "getHash", "()Lokio/ByteString;", "hashAlgorithm", "getHashAlgorithm", "()Ljava/lang/String;", "getPattern", "equals", "", "other", "hashCode", "", "matchesCertificate", "certificate", "Ljava/security/cert/X509Certificate;", "matchesHostname", "hostname", "toString", "okhttp"})
public final class CertificatePinner$Pin {
    @NotNull
    private final String pattern;
    @NotNull
    private final String hashAlgorithm;
    @NotNull
    private final ByteString hash;

    public CertificatePinner$Pin(@NotNull String string, @NotNull String string2) {
        Intrinsics.checkNotNullParameter(string, "pattern");
        Intrinsics.checkNotNullParameter(string2, "pin");
        if (!(StringsKt.startsWith$default(string, "*.", false, 2, null) && StringsKt.indexOf$default((CharSequence)string, "*", 1, false, 4, null) == -1 || StringsKt.startsWith$default(string, "**.", false, 2, null) && StringsKt.indexOf$default((CharSequence)string, "*", 2, false, 4, null) == -1 || StringsKt.indexOf$default((CharSequence)string, "*", 0, false, 6, null) == -1)) {
            boolean bl = false;
            String string3 = "Unexpected pattern: " + string;
            throw new IllegalArgumentException(string3.toString());
        }
        String string4 = HostnamesKt.toCanonicalHost(string);
        if (string4 == null) {
            throw new IllegalArgumentException("Invalid pattern: " + string);
        }
        this.pattern = string4;
        if (StringsKt.startsWith$default(string2, "sha1/", false, 2, null)) {
            this.hashAlgorithm = "sha1";
            String string5 = string2.substring(5);
            Intrinsics.checkNotNullExpressionValue(string5, "this as java.lang.String).substring(startIndex)");
            ByteString byteString = ByteString.Companion.decodeBase64(string5);
            if (byteString == null) {
                throw new IllegalArgumentException("Invalid pin hash: " + string2);
            }
            this.hash = byteString;
        } else if (StringsKt.startsWith$default(string2, "sha256/", false, 2, null)) {
            this.hashAlgorithm = "sha256";
            String string6 = string2.substring(7);
            Intrinsics.checkNotNullExpressionValue(string6, "this as java.lang.String).substring(startIndex)");
            ByteString byteString = ByteString.Companion.decodeBase64(string6);
            if (byteString == null) {
                throw new IllegalArgumentException("Invalid pin hash: " + string2);
            }
            this.hash = byteString;
        } else {
            throw new IllegalArgumentException("pins must start with 'sha256/' or 'sha1/': " + string2);
        }
    }

    @NotNull
    public final String getPattern() {
        return this.pattern;
    }

    @NotNull
    public final String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    @NotNull
    public final ByteString getHash() {
        return this.hash;
    }

    public final boolean matchesHostname(@NotNull String string) {
        boolean bl;
        Intrinsics.checkNotNullParameter(string, "hostname");
        if (StringsKt.startsWith$default(this.pattern, "**.", false, 2, null)) {
            int n = this.pattern.length() - 3;
            int n2 = string.length() - n;
            bl = StringsKt.regionMatches$default(string, string.length() - n, this.pattern, 3, n, false, 16, null) && (n2 == 0 || string.charAt(n2 - 1) == '.');
        } else if (StringsKt.startsWith$default(this.pattern, "*.", false, 2, null)) {
            int n = this.pattern.length() - 1;
            int n3 = string.length() - n;
            bl = StringsKt.regionMatches$default(string, string.length() - n, this.pattern, 1, n, false, 16, null) && StringsKt.lastIndexOf$default((CharSequence)string, '.', n3 - 1, false, 4, null) == -1;
        } else {
            bl = Intrinsics.areEqual(string, this.pattern);
        }
        return bl;
    }

    public final boolean matchesCertificate(@NotNull X509Certificate x509Certificate) {
        Intrinsics.checkNotNullParameter(x509Certificate, "certificate");
        String string = this.hashAlgorithm;
        return Intrinsics.areEqual(string, "sha256") ? Intrinsics.areEqual(this.hash, CertificatePinner.Companion.sha256Hash(x509Certificate)) : (Intrinsics.areEqual(string, "sha1") ? Intrinsics.areEqual(this.hash, CertificatePinner.Companion.sha1Hash(x509Certificate)) : false);
    }

    @NotNull
    public String toString() {
        return this.hashAlgorithm + '/' + this.hash.base64();
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CertificatePinner$Pin)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.pattern, ((CertificatePinner$Pin)object).pattern)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.hashAlgorithm, ((CertificatePinner$Pin)object).hashAlgorithm)) {
            return false;
        }
        return Intrinsics.areEqual(this.hash, ((CertificatePinner$Pin)object).hash);
    }

    public int hashCode() {
        int n = this.pattern.hashCode();
        n = 31 * n + this.hashAlgorithm.hashCode();
        n = 31 * n + this.hash.hashCode();
        return n;
    }
}

