/*
 * Decompiled with CFR 0.152.
 */
package io.github.bhowell2.dirwatcher;

import io.github.bhowell2.dirwatcher.DirWatcher$Callback;
import io.github.bhowell2.dirwatcher.DirWatcher$WatchKeyEventHandler;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirWatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(DirWatcher.class);
    private static final AtomicInteger DIR_WATCHER_COUNT = new AtomicInteger(0);
    private static final WatchEvent.Kind[] ALL_STANDARD_WATCH_EVENT_KINDS = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.OVERFLOW};
    private final ConcurrentHashMap<Path, WatchKey> pathWatchKeys;
    private final ConcurrentHashMap<WatchKey, Set<DirWatcher$WatchKeyEventHandler>> watchKeyHandlers;
    private final WatchService watchService;
    private final Executor defaultCallbackExecutor;
    private volatile boolean started = false;
    private boolean stopWatcher = false;

    public DirWatcher() {
        this(FileSystems.getDefault().newWatchService(), null);
    }

    public DirWatcher(WatchService watchService) {
        this(watchService, null);
    }

    public DirWatcher(Executor executor) {
        this(FileSystems.getDefault().newWatchService(), executor);
    }

    public DirWatcher(WatchService watchService, Executor executor) {
        Objects.requireNonNull(watchService, "Cannot watch without a WatchService.");
        this.watchService = watchService;
        this.defaultCallbackExecutor = executor;
        this.pathWatchKeys = new ConcurrentHashMap(1, 0.7f, 1);
        this.watchKeyHandlers = new ConcurrentHashMap(1, 0.7f, 1);
    }

    public void registerDirectoryForAllKinds(Path path, DirWatcher$Callback dirWatcher$Callback) {
        this.registerDirectoryForAllKinds(path, false, dirWatcher$Callback);
    }

    public void registerDirectoryForAllKinds(Path path, boolean bl, DirWatcher$Callback dirWatcher$Callback) {
        this.registerDirectoryForAllKinds(path, bl, null, dirWatcher$Callback);
    }

    public void registerDirectoryForAllKinds(Path path, boolean bl, Executor executor, DirWatcher$Callback dirWatcher$Callback) {
        this.registerDirectory(path, bl, executor, dirWatcher$Callback, ALL_STANDARD_WATCH_EVENT_KINDS);
    }

    public void registerDirectory(Path path, DirWatcher$Callback dirWatcher$Callback, WatchEvent.Kind ... kindArray) {
        this.registerDirectory(path, false, dirWatcher$Callback, kindArray);
    }

    public void registerDirectory(Path path, boolean bl, DirWatcher$Callback dirWatcher$Callback, WatchEvent.Kind ... kindArray) {
        this.registerDirectory(path, bl, null, dirWatcher$Callback, kindArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDirectory(Path path2, boolean bl, Executor executor, DirWatcher$Callback dirWatcher$Callback, WatchEvent.Kind ... kindArray) {
        Objects.requireNonNull(dirWatcher$Callback);
        Objects.requireNonNull(kindArray);
        Path path3 = path2.toRealPath(new LinkOption[0]);
        DirWatcher dirWatcher = this;
        synchronized (dirWatcher) {
            WatchKey watchKey = this.pathWatchKeys.get(path3);
            if (watchKey == null) {
                watchKey = path3.register(this.watchService, ALL_STANDARD_WATCH_EVENT_KINDS);
                this.pathWatchKeys.putIfAbsent(path3, watchKey);
            }
            DirWatcher$WatchKeyEventHandler dirWatcher$WatchKeyEventHandler = new DirWatcher$WatchKeyEventHandler(this, watchKey, path3, bl, executor, dirWatcher$Callback, Arrays.asList(kindArray));
            Set<DirWatcher$WatchKeyEventHandler> set = this.watchKeyHandlers.get(watchKey);
            if (set == null) {
                set = new HashSet<DirWatcher$WatchKeyEventHandler>();
                set.add(dirWatcher$WatchKeyEventHandler);
                this.watchKeyHandlers.put(watchKey, Collections.unmodifiableSet(set));
            } else if (!set.contains(dirWatcher$WatchKeyEventHandler)) {
                set = new HashSet<DirWatcher$WatchKeyEventHandler>(set);
                set.add(dirWatcher$WatchKeyEventHandler);
                this.watchKeyHandlers.put(watchKey, Collections.unmodifiableSet(set));
            } else {
                LOGGER.warn("Overriding callback for path {}.", (Object)path2);
                HashSet<DirWatcher$WatchKeyEventHandler> hashSet = new HashSet<DirWatcher$WatchKeyEventHandler>(set.size());
                for (DirWatcher$WatchKeyEventHandler dirWatcher$WatchKeyEventHandler2 : set) {
                    if (dirWatcher$WatchKeyEventHandler2.equals(dirWatcher$WatchKeyEventHandler)) continue;
                    hashSet.add(dirWatcher$WatchKeyEventHandler2);
                }
                hashSet.add(dirWatcher$WatchKeyEventHandler);
                this.watchKeyHandlers.put(watchKey, Collections.unmodifiableSet(hashSet));
            }
            this.startWatcher();
        }
        if (bl) {
            Files.list(path2).filter(path -> Files.isDirectory(path, new LinkOption[0])).forEach(path -> {
                try {
                    this.registerDirectory((Path)path, bl, executor, dirWatcher$Callback, kindArray);
                }
                catch (Exception exception) {
                    LOGGER.error("Failed to recursively register directory.", exception);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterAllCallbacksForPath(Path path) {
        DirWatcher dirWatcher = this;
        synchronized (dirWatcher) {
            WatchKey watchKey = this.pathWatchKeys.remove(path.toRealPath(new LinkOption[0]));
            if (watchKey != null) {
                this.watchKeyHandlers.remove(watchKey);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterCallbackForPath(Path path, DirWatcher$Callback dirWatcher$Callback) {
        DirWatcher dirWatcher = this;
        synchronized (dirWatcher) {
            Set<DirWatcher$WatchKeyEventHandler> set;
            path = path.toRealPath(new LinkOption[0]);
            WatchKey watchKey = this.pathWatchKeys.get(path);
            if (watchKey != null && (set = this.watchKeyHandlers.get(watchKey)) != null) {
                HashSet<DirWatcher$WatchKeyEventHandler> hashSet = new HashSet<DirWatcher$WatchKeyEventHandler>(set.size() - 1);
                for (DirWatcher$WatchKeyEventHandler dirWatcher$WatchKeyEventHandler : set) {
                    if (DirWatcher$WatchKeyEventHandler.access$000(dirWatcher$WatchKeyEventHandler).equals(dirWatcher$Callback)) continue;
                    hashSet.add(dirWatcher$WatchKeyEventHandler);
                }
                if (hashSet.size() == 0) {
                    this.pathWatchKeys.remove(path);
                    this.watchKeyHandlers.remove(watchKey);
                } else {
                    this.watchKeyHandlers.put(watchKey, Collections.unmodifiableSet(hashSet));
                }
                return set.size() != hashSet.size();
            }
            return false;
        }
    }

    private synchronized void startWatcher() {
        if (!this.started) {
            new Thread(() -> {
                while (true) {
                    boolean bl;
                    if (this.stopWatcher) {
                        try {
                            this.watchService.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return;
                    }
                    WatchKey watchKey = null;
                    try {
                        watchKey = this.watchService.poll(1L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                    if (watchKey == null) continue;
                    Set<DirWatcher$WatchKeyEventHandler> set = this.watchKeyHandlers.get(watchKey);
                    List<WatchEvent<?>> list = watchKey.pollEvents();
                    if (set != null) {
                        for (DirWatcher$WatchKeyEventHandler dirWatcher$WatchKeyEventHandler : set) {
                            dirWatcher$WatchKeyEventHandler.handleEvents(list);
                        }
                    }
                    if (bl = watchKey.reset()) continue;
                    DirWatcher dirWatcher = this;
                    synchronized (dirWatcher) {
                        Path path = null;
                        for (Map.Entry<Path, WatchKey> entry : this.pathWatchKeys.entrySet()) {
                            if (!entry.getValue().equals(watchKey)) continue;
                            path = entry.getKey();
                            break;
                        }
                    }
                }
            }, "DirWatcher-" + DIR_WATCHER_COUNT.getAndIncrement()).start();
            this.started = true;
        }
    }

    public void stopWatcher() {
        this.stopWatcher = true;
    }

    static /* synthetic */ Executor access$100(DirWatcher dirWatcher) {
        return dirWatcher.defaultCallbackExecutor;
    }

    static /* synthetic */ Logger access$200() {
        return LOGGER;
    }
}

