/*
 * Decompiled with CFR 0.152.
 */
package io.github.bhowell2.dirwatcher;

import io.github.bhowell2.dirwatcher.DirWatcher;
import io.github.bhowell2.dirwatcher.DirWatcher$Callback;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;

final class DirWatcher$WatchKeyEventHandler {
    private final WatchKey key;
    private final Path realDirPath;
    private final DirWatcher$Callback callback;
    private final Set<WatchEvent.Kind> subscriptionKinds;
    private final boolean recursive;
    private final Executor executor;
    final /* synthetic */ DirWatcher this$0;

    public DirWatcher$WatchKeyEventHandler(DirWatcher dirWatcher, WatchKey watchKey, Path path, boolean bl, Executor executor, DirWatcher$Callback dirWatcher$Callback, List<WatchEvent.Kind> list) {
        this.this$0 = dirWatcher;
        Objects.requireNonNull(watchKey);
        Objects.requireNonNull(path);
        Objects.requireNonNull(dirWatcher$Callback);
        Objects.requireNonNull(list);
        this.key = watchKey;
        this.realDirPath = path;
        this.executor = executor;
        this.callback = dirWatcher$Callback;
        this.subscriptionKinds = new HashSet<WatchEvent.Kind>(list);
        this.recursive = bl;
    }

    private void runCallback(Path path, WatchEvent.Kind kind) {
        if (this.executor != null) {
            this.executor.execute(() -> this.callback.call(this.realDirPath, path, kind));
        } else if (DirWatcher.access$100(this.this$0) != null) {
            DirWatcher.access$100(this.this$0).execute(() -> this.callback.call(this.realDirPath, path, kind));
        } else {
            this.callback.call(this.realDirPath, path, kind);
        }
    }

    public void handleEvents(List<WatchEvent<?>> list) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            WatchEvent<?> watchEvent = list.get(i);
            Path path = (Path)watchEvent.context();
            WatchEvent.Kind<?> kind = watchEvent.kind();
            if (this.recursive && kind == StandardWatchEventKinds.ENTRY_CREATE && Files.isDirectory(this.realDirPath.resolve(path), new LinkOption[0])) {
                try {
                    this.this$0.registerDirectory(this.realDirPath.resolve(path), this.recursive, this.executor, this.callback, this.subscriptionKinds.toArray(new WatchEvent.Kind[0]));
                }
                catch (Exception exception) {
                    DirWatcher.access$200().error("Failed to recursively register directory.", exception);
                }
            }
            if (!this.subscriptionKinds.contains(watchEvent.kind())) continue;
            this.runCallback((Path)watchEvent.context(), watchEvent.kind());
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DirWatcher$WatchKeyEventHandler dirWatcher$WatchKeyEventHandler = (DirWatcher$WatchKeyEventHandler)object;
        return this.realDirPath.equals(dirWatcher$WatchKeyEventHandler.realDirPath) && this.callback.equals(dirWatcher$WatchKeyEventHandler.callback);
    }

    public int hashCode() {
        return Objects.hash(this.realDirPath, this.callback);
    }

    static /* synthetic */ DirWatcher$Callback access$000(DirWatcher$WatchKeyEventHandler dirWatcher$WatchKeyEventHandler) {
        return dirWatcher$WatchKeyEventHandler.callback;
    }
}

